(ns hara.code.manage.var
  (:require [hara.code.framework :as base]
            [hara.string :as string]
            [hara.code.query :as query]
            [hara.code.navigate :as nav]))

(defn create-candidates
  "create candidates for searching a file
 
   (create-candidates '[clojure.core :as clj :refer [apply]]
                      'clojure.core/apply
                      'apply)
   => '#{clojure.core/apply clj/apply apply}"
  {:added "3.0"}
  [nsform var sym]
  (if-let [[_ & {:keys [as refer]}] nsform]
    (-> (set [var
              (if as (symbol (str as) (str sym)))
              (if (or (= refer :all)
                      ((set refer) sym))
                sym)])
        (disj nil))
    #{var}))

(defn find-candidates
  "find candidates given a zip"
  {:added "3.0"}
  [nav var]
  (let [nsp    (symbol (namespace var))
        sym    (symbol (name var))
        nsform (-> (query/$* nav
                             [{:first :require} '| {:first nsp}])
                   (first))
        candidates (create-candidates nsform var sym)]
    [candidates nsp sym]))

(defn find-usages
  "finds usages of a var
 
   (project/in-context (find-usages {:var 'hara.code.format.var/find-usages}))"
  {:added "3.0"}
  [ns {:keys [var] :as params} lookup project]
  (let [path   (lookup ns)
        code   (slurp path)
        nav   (nav/parse-root code)
        [candidates nsp sym] (find-candidates nav var)]
    (base/locate-code ns
                      (assoc params
                             :query [{:or (map #(hash-map :is %) candidates)}])
                      lookup
                      project)))
