(ns hara.function
  (:require [hara.module :as module]
            [hara.function.base.native]
            [hara.function.base.arg]
            [hara.function.base.dispatch]
            [hara.function.base.executive]
            [hara.function.base.form]
            [hara.function.base.hook]
            [hara.function.base.macro]
            [hara.function.base.memoize]
            [hara.function.base.multi])
  (:refer-clojure :exclude [memoize fn]))

(module/include
 
 (hara.function.base.arg          arg-check
                                  arg-count
                                  varg-count
                                  vargs?)
 
 (hara.function.base.dispatch     invoke
                                  call
                                  message 
                                  op)
 
 (hara.function.base.executive    defexecutive)
 
 (hara.function.base.form         form-fn
                                  form-eval
                                  form-apply)
 
 (hara.function.base.hook         list-patched
                                  patch
                                  patched?
                                  unpatch)

 (hara.function.base.invoke       definvoke
                                  form-arglists
                                  fn)
 
 (hara.function.base.macro        const
                                  applym
                                  create-args
                                  create-def-form
                                  defcompose
                                  lookup
                                  deflookup)
 
 (hara.function.base.memoize      memoize
                                  memoize-clear
                                  memoize-remove
                                  defmemoize)
 
 (hara.function.base.multi        multi?
                                  multi-clone
                                  multi-keys
                                  multi-has?
                                  multi-list
                                  multi-get
                                  multi-remove
                                  multi-match?
                                  multi-add))
