(ns haar.rx.core
  (:refer-clojure :exclude [+  * or cat range]))

(def ^{:private true} escape-str "\\")

(def word (re-pattern (str escape-str "w")))

(def non-word (re-pattern (str escape-str "W")))

(def tab (re-pattern (str escape-str "t") ))

(def escape (re-pattern (str escape-str "e")))

(def digit (re-pattern (str escape-str "d")))

(def non-digit (re-pattern (str escape-str "D")))

(def whitespace (re-pattern (str escape-str "s")))

(def non-whitespace (re-pattern (str escape-str "S")))

(defn- char-class [s]
  (re-pattern (format "\\p{%s}" s)))

(def lower (char-class "Lower"))

(def upper (char-class "Upper"))

(def alpha (char-class "Alpha"))

(def alnum (char-class "Alnum"))

(def blank (char-class "Blank"))

(def space (char-class "Space"))

(def beginning-of-line (re-pattern "^"))

(def end-of-line (re-pattern "$"))

(def word-boundary (re-pattern (str escape-str "b")))

(def non-word-boundary (re-pattern (str escape-str "B")))

(def backslash (re-pattern (str "\\\\")))

(defn + [x] (re-pattern (str x "+")))

(defn * [x] (re-pattern (str x "*")))

(defn ? [x] (re-pattern (str x "?")))

(defn n-times [x n] (re-pattern (str x (format "{%s}" n))))

(defn or [& args]
  (re-pattern (format "[%s]" (reduce str (map str args)))))

(defn except [& args]
  (re-pattern (format "[^%s]" (reduce str (map str args)))))

(defn range [from to]
  (re-pattern (format "[%s-%s]" (str from) (str to))))

(defn cat [x y & more]
  (re-pattern (reduce str
                      (map str (list* x y more)))))

(defn group [x] (re-pattern (format "(%s)" (str x))))

(comment

  (let [s "\\displaystyle sum _{1}"]
    (re-find
     (cat backslash (+ word) (+ whitespace) (group (+ word)))
     s))
  
  )
