(ns gws.balanced.client
  (:require [clj-http.client :as client]))

(def endpoint "https://api.balancedpayments.com")
(def user-agent "gws-balanced/0.1.2")

(defrecord BalancedClient [secret clj-http-options])

(defn call
  "Calls the supplied Balanced endpoint and returns the decoded response body."
  ([client method path]
   (call client method path {}))
  ([client method path params]
   (let [endpoint (str endpoint path)
         params (merge {:as :json
                        :content-type :json
                        :basic-auth [(:secret client) ""]
                        :method method
                        :url endpoint
                        :headers {:accept "application/vnd.api+json;revision=1.1"
                                  :user-agent user-agent}}
                       (if (= method :get)
                         {:query-params params}
                         {:form-params params})
                       (:clj-http-options client))]
     (:body (client/request params)))))

(defn create
  ([secret]
   (create secret {}))
  ([secret clj-http-options]
   (->BalancedClient secret clj-http-options)))
