(ns gws.balanced.api.customers
  (:refer-clojure :exclude [get list])
  (:require [gws.balanced.client :as client]))

(defn list
  ([client]
   (list client {}))
  ([client options]
   (let [path "/customers"]
     (client/call client :get path options))))

(defn get
  [client id]
  (let [path (format "/customers/%s" id)]
    (client/call client :get path)))

(defn create!
  [client customer]
  (let [path "/customers"]
    (client/call client :post path customer)))

(defn update!
  [client id customer]
  (let [path (format "/customers/%s" id)]
    (client/call client :put path customer)))

(defn delete!
  [client id]
  (let [path (format "/customers/%s" id)]
    (client/call client :delete path)))
