;;; clojure.core {{{1

clojure.core/*1
clojure.core/*2
clojure.core/*3
clojure.core/*agent*
clojure.core/*allow-unresolved-vars*
clojure.core/*assert*
clojure.core/*clojure-version*
clojure.core/*command-line-args*
clojure.core/*compile-files*
clojure.core/*compile-path*
clojure.core/*compiler-options*
clojure.core/*data-readers*
clojure.core/*default-data-reader-fn*
clojure.core/*e
clojure.core/*err*
clojure.core/*file*
clojure.core/*flush-on-newline*
clojure.core/*fn-loader*
clojure.core/*in*
clojure.core/*math-context*
clojure.core/*ns*
clojure.core/*out*
clojure.core/*print-dup*
clojure.core/*print-length*
clojure.core/*print-level*
clojure.core/*print-meta*
clojure.core/*print-readably*
clojure.core/*read-eval*
clojure.core/*source-path*
clojure.core/*unchecked-math*
clojure.core/*use-context-classloader*
clojure.core/*verbose-defrecords*
clojure.core/*warn-on-reflection*
clojure.core/EMPTY-NODE
clojure.core/char-escape-string
clojure.core/char-name-string
clojure.core/default-data-readers
clojure.core/primitives-classnames
clojure.core/print-dup
clojure.core/print-method
clojure.core/unquote
clojure.core/unquote-splicing
clojure.core/*                            [] [x] [x y] [x y & more]
clojure.core/*'                           [] [x] [x y] [x y & more]
clojure.core/+                            [] [x] [x y] [x y & more]
clojure.core/+'                           [] [x] [x y] [x y & more]
clojure.core/-                            [x] [x y] [x y & more]
clojure.core/-'                           [x] [x y] [x y & more]
clojure.core/->                           [x] [x form] [x form & more]
clojure.core/->>                          [x form] [x form & more]
clojure.core/->ArrayChunk                 [am arr off end]
clojure.core/->Vec                        [am cnt shift root tail _meta]
clojure.core/->VecNode                    [edit arr]
clojure.core/->VecSeq                     [am vec anode i offset]
clojure.core/-cache-protocol-fn           [pf x c interf]
clojure.core/-reset-methods               [protocol]
clojure.core/..                           [x form] [x form & more]
clojure.core//                            [x] [x y] [x y & more]
clojure.core/<                            [x] [x y] [x y & more]
clojure.core/<=                           [x] [x y] [x y & more]
clojure.core/=                            [x] [x y] [x y & more]
clojure.core/==                           [x] [x y] [x y & more]
clojure.core/>                            [x] [x y] [x y & more]
clojure.core/>=                           [x] [x y] [x y & more]
clojure.core/accessor                     [s key]
clojure.core/aclone                       [array]
clojure.core/add-classpath                [url]
clojure.core/add-watch                    [reference key fn]
clojure.core/agent                        [state & options]
clojure.core/agent-error                  [a]
clojure.core/agent-errors                 [a]
clojure.core/aget                         [array idx] [array idx & idxs]
clojure.core/alength                      [array]
clojure.core/alias                        [alias namespace-sym]
clojure.core/all-ns                       []
clojure.core/alter                        [ref fun & args]
clojure.core/alter-meta!                  [iref f & args]
clojure.core/alter-var-root               [v f & args]
clojure.core/amap                         [a idx ret expr]
clojure.core/ancestors                    [tag] [h tag]
clojure.core/and                          [] [x] [x & next]
clojure.core/apply                        [f args] [f x args] [f x y args] [f x y z args] [f a b c d & args]
clojure.core/areduce                      [a idx ret init expr]
clojure.core/array-map                    [] [& keyvals]
clojure.core/as->                         [expr name & forms]
clojure.core/aset                         [array idx val] [array idx idx2 & idxv]
clojure.core/aset-boolean                 [array idx val] [array idx idx2 & idxv]
clojure.core/aset-byte                    [array idx val] [array idx idx2 & idxv]
clojure.core/aset-char                    [array idx val] [array idx idx2 & idxv]
clojure.core/aset-double                  [array idx val] [array idx idx2 & idxv]
clojure.core/aset-float                   [array idx val] [array idx idx2 & idxv]
clojure.core/aset-int                     [array idx val] [array idx idx2 & idxv]
clojure.core/aset-long                    [array idx val] [array idx idx2 & idxv]
clojure.core/aset-short                   [array idx val] [array idx idx2 & idxv]
clojure.core/assert                       [x] [x message]
clojure.core/assoc                        [map key val] [map key val & kvs]
clojure.core/assoc!                       [coll key val] [coll key val & kvs]
clojure.core/assoc-in                     [m [k & ks] v]
clojure.core/associative?                 [coll]
clojure.core/atom                         [x] [x & options]
clojure.core/await                        [& agents]
clojure.core/await-for                    [timeout-ms & agents]
clojure.core/await1                       [a]
clojure.core/bases                        [c]
clojure.core/bean                         [x]
clojure.core/bigdec                       [x]
clojure.core/bigint                       [x]
clojure.core/biginteger                   [x]
clojure.core/binding                      [bindings & body]
clojure.core/bit-and                      [x y] [x y & more]
clojure.core/bit-and-not                  [x y] [x y & more]
clojure.core/bit-clear                    [x n]
clojure.core/bit-flip                     [x n]
clojure.core/bit-not                      [x]
clojure.core/bit-or                       [x y] [x y & more]
clojure.core/bit-set                      [x n]
clojure.core/bit-shift-left               [x n]
clojure.core/bit-shift-right              [x n]
clojure.core/bit-test                     [x n]
clojure.core/bit-xor                      [x y] [x y & more]
clojure.core/boolean                      [x]
clojure.core/boolean-array                [size-or-seq] [size init-val-or-seq]
clojure.core/booleans                     [xs]
clojure.core/bound-fn                     [& fntail]
clojure.core/bound-fn*                    [f]
clojure.core/bound?                       [& vars]
clojure.core/butlast                      [coll]
clojure.core/byte                         [x]
clojure.core/byte-array                   [size-or-seq] [size init-val-or-seq]
clojure.core/bytes                        [xs]
clojure.core/case                         [e & clauses]
clojure.core/cast                         [c x]
clojure.core/char                         [x]
clojure.core/char-array                   [size-or-seq] [size init-val-or-seq]
clojure.core/char?                        [x]
clojure.core/chars                        [xs]
clojure.core/chunk                        [b]
clojure.core/chunk-append                 [b x]
clojure.core/chunk-buffer                 [capacity]
clojure.core/chunk-cons                   [chunk rest]
clojure.core/chunk-first                  [s]
clojure.core/chunk-next                   [s]
clojure.core/chunk-rest                   [s]
clojure.core/chunked-seq?                 [s]
clojure.core/class                        [x]
clojure.core/class?                       [x]
clojure.core/clear-agent-errors           [a]
clojure.core/clojure-version              []
clojure.core/coll?                        [x]
clojure.core/comment                      [& body]
clojure.core/commute                      [ref fun & args]
clojure.core/comp                         [] [f] [f g] [f g h] [f1 f2 f3 & fs]
clojure.core/comparator                   [pred]
clojure.core/compare                      [x y]
clojure.core/compare-and-set!             [atom oldval newval]
clojure.core/compile                      [lib]
clojure.core/complement                   [f]
clojure.core/concat                       [] [x] [x y] [x y & zs]
clojure.core/cond                         [& clauses]
clojure.core/cond->                       [expr & clauses]
clojure.core/cond->>                      [expr & clauses]
clojure.core/condp                        [pred expr & clauses]
clojure.core/conj                         [coll x] [coll x & xs]
clojure.core/conj!                        [coll x]
clojure.core/cons                         [x seq]
clojure.core/constantly                   [x]
clojure.core/construct-proxy              [c & ctor-args]
clojure.core/contains?                    [coll key]
clojure.core/count                        [coll]
clojure.core/counted?                     [coll]
clojure.core/create-ns                    [sym]
clojure.core/create-struct                [& keys]
clojure.core/cycle                        [coll]
clojure.core/dec                          [x]
clojure.core/dec'                         [x]
clojure.core/decimal?                     [n]
clojure.core/declare                      [& names]
clojure.core/definline                    [name & decl]
clojure.core/definterface                 [name & sigs]
clojure.core/defmacro                     [name doc-string? attr-map? [params*] body] [name doc-string? attr-map? ([params*] body) + attr-map?]
clojure.core/defmethod                    [multifn dispatch-val & fn-tail]
clojure.core/defmulti                     [name docstring? attr-map? dispatch-fn & options]
clojure.core/defn                         [name doc-string? attr-map? [params*] prepost-map? body] [name doc-string? attr-map? ([params*] prepost-map? body) + attr-map?]
clojure.core/defn-                        [name & decls]
clojure.core/defonce                      [name expr]
clojure.core/defprotocol                  [name & opts+sigs]
clojure.core/defrecord                    [name [& fields] & opts+specs]
clojure.core/defstruct                    [name & keys]
clojure.core/deftype                      [name [& fields] & opts+specs]
clojure.core/delay                        [& body]
clojure.core/delay?                       [x]
clojure.core/deliver                      [promise val]
clojure.core/denominator                  [r]
clojure.core/deref                        [ref] [ref timeout-ms timeout-val]
clojure.core/derive                       [tag parent] [h tag parent]
clojure.core/descendants                  [tag] [h tag]
clojure.core/destructure                  [bindings]
clojure.core/disj                         [set] [set key] [set key & ks]
clojure.core/disj!                        [set] [set key] [set key & ks]
clojure.core/dissoc                       [map] [map key] [map key & ks]
clojure.core/dissoc!                      [map key] [map key & ks]
clojure.core/distinct                     [coll]
clojure.core/distinct?                    [x] [x y] [x y & more]
clojure.core/doall                        [coll] [n coll]
clojure.core/dorun                        [coll] [n coll]
clojure.core/doseq                        [seq-exprs & body]
clojure.core/dosync                       [& exprs]
clojure.core/dotimes                      [bindings & body]
clojure.core/doto                         [x & forms]
clojure.core/double                       [x]
clojure.core/double-array                 [size-or-seq] [size init-val-or-seq]
clojure.core/doubles                      [xs]
clojure.core/drop                         [n coll]
clojure.core/drop-last                    [s] [n s]
clojure.core/drop-while                   [pred coll]
clojure.core/empty                        [coll]
clojure.core/empty?                       [coll]
clojure.core/ensure                       [ref]
clojure.core/enumeration-seq              [e]
clojure.core/error-handler                [a]
clojure.core/error-mode                   [a]
clojure.core/eval                         [form]
clojure.core/even?                        [n]
clojure.core/every-pred                   [p] [p1 p2] [p1 p2 p3] [p1 p2 p3 & ps]
clojure.core/every?                       [pred coll]
clojure.core/ex-data                      [ex]
clojure.core/ex-info                      [msg map] [msg map cause]
clojure.core/extend                       [atype & proto+mmaps]
clojure.core/extend-protocol              [p & specs]
clojure.core/extend-type                  [t & specs]
clojure.core/extenders                    [protocol]
clojure.core/extends?                     [protocol atype]
clojure.core/false?                       [x]
clojure.core/ffirst                       [x]
clojure.core/file-seq                     [dir]
clojure.core/filter                       [pred coll]
clojure.core/filterv                      [pred coll]
clojure.core/find                         [map key]
clojure.core/find-keyword                 [name] [ns name]
clojure.core/find-ns                      [sym]
clojure.core/find-protocol-impl           [protocol x]
clojure.core/find-protocol-method         [protocol methodk x]
clojure.core/find-var                     [sym]
clojure.core/first                        [coll]
clojure.core/flatten                      [x]
clojure.core/float                        [x]
clojure.core/float-array                  [size-or-seq] [size init-val-or-seq]
clojure.core/float?                       [n]
clojure.core/floats                       [xs]
clojure.core/flush                        []
clojure.core/fn                           [& sigs]
clojure.core/fn?                          [x]
clojure.core/fnext                        [x]
clojure.core/fnil                         [f x] [f x y] [f x y z]
clojure.core/for                          [seq-exprs body-expr]
clojure.core/force                        [x]
clojure.core/format                       [fmt & args]
clojure.core/frequencies                  [coll]
clojure.core/future                       [& body]
clojure.core/future-call                  [f]
clojure.core/future-cancel                [f]
clojure.core/future-cancelled?            [f]
clojure.core/future-done?                 [f]
clojure.core/future?                      [x]
clojure.core/gen-class                    [& options]
clojure.core/gen-interface                [& options]
clojure.core/gensym                       [] [prefix-string]
clojure.core/get                          [map key] [map key not-found]
clojure.core/get-in                       [m ks] [m ks not-found]
clojure.core/get-method                   [multifn dispatch-val]
clojure.core/get-proxy-class              [& bases]
clojure.core/get-thread-bindings          []
clojure.core/get-validator                [iref]
clojure.core/group-by                     [f coll]
clojure.core/hash                         [x]
clojure.core/hash-combine                 [x y]
clojure.core/hash-map                     [] [& keyvals]
clojure.core/hash-set                     [] [& keys]
clojure.core/identical?                   [x y]
clojure.core/identity                     [x]
clojure.core/if-let                       [bindings then] [bindings then else & oldform]
clojure.core/if-not                       [test then] [test then else]
clojure.core/ifn?                         [x]
clojure.core/import                       [& import-symbols-or-lists]
clojure.core/in-ns                        [name]
clojure.core/inc                          [x]
clojure.core/inc'                         [x]
clojure.core/init-proxy                   [proxy mappings]
clojure.core/instance?                    [c x]
clojure.core/int                          [x]
clojure.core/int-array                    [size-or-seq] [size init-val-or-seq]
clojure.core/integer?                     [n]
clojure.core/interleave                   [c1 c2] [c1 c2 & colls]
clojure.core/intern                       [ns name] [ns name val]
clojure.core/interpose                    [sep coll]
clojure.core/into                         [to from]
clojure.core/into-array                   [aseq] [type aseq]
clojure.core/ints                         [xs]
clojure.core/io!                          [& body]
clojure.core/isa?                         [child parent] [h child parent]
clojure.core/iterate                      [f x]
clojure.core/iterator-seq                 [iter]
clojure.core/juxt                         [f] [f g] [f g h] [f g h & fs]
clojure.core/keep                         [f coll]
clojure.core/keep-indexed                 [f coll]
clojure.core/key                          [e]
clojure.core/keys                         [map]
clojure.core/keyword                      [name] [ns name]
clojure.core/keyword?                     [x]
clojure.core/last                         [coll]
clojure.core/lazy-cat                     [& colls]
clojure.core/lazy-seq                     [& body]
clojure.core/let                          [bindings & body]
clojure.core/letfn                        [fnspecs & body]
clojure.core/line-seq                     [rdr]
clojure.core/list                         [& items]
clojure.core/list*                        [args] [a args] [a b args] [a b c args] [a b c d & more]
clojure.core/list?                        [x]
clojure.core/load                         [& paths]
clojure.core/load-file                    [name]
clojure.core/load-reader                  [rdr]
clojure.core/load-string                  [s]
clojure.core/loaded-libs                  []
clojure.core/locking                      [x & body]
clojure.core/long                         [x]
clojure.core/long-array                   [size-or-seq] [size init-val-or-seq]
clojure.core/longs                        [xs]
clojure.core/loop                         [bindings & body]
clojure.core/macroexpand                  [form]
clojure.core/macroexpand-1                [form]
clojure.core/make-array                   [type len] [type dim & more-dims]
clojure.core/make-hierarchy               []
clojure.core/map                          [f coll] [f c1 c2] [f c1 c2 c3] [f c1 c2 c3 & colls]
clojure.core/map-indexed                  [f coll]
clojure.core/map?                         [x]
clojure.core/mapcat                       [f & colls]
clojure.core/mapv                         [f coll] [f c1 c2] [f c1 c2 c3] [f c1 c2 c3 & colls]
clojure.core/max                          [x] [x y] [x y & more]
clojure.core/max-key                      [k x] [k x y] [k x y & more]
clojure.core/memfn                        [name & args]
clojure.core/memoize                      [f]
clojure.core/merge                        [& maps]
clojure.core/merge-with                   [f & maps]
clojure.core/meta                         [obj]
clojure.core/method-sig                   [meth]
clojure.core/methods                      [multifn]
clojure.core/min                          [x] [x y] [x y & more]
clojure.core/min-key                      [k x] [k x y] [k x y & more]
clojure.core/mod                          [num div]
clojure.core/munge                        [s]
clojure.core/name                         [x]
clojure.core/namespace                    [x]
clojure.core/namespace-munge              [ns]
clojure.core/neg?                         [x]
clojure.core/newline                      []
clojure.core/next                         [coll]
clojure.core/nfirst                       [x]
clojure.core/nil?                         [x]
clojure.core/nnext                        [x]
clojure.core/not                          [x]
clojure.core/not-any?                     [pred coll]
clojure.core/not-empty                    [coll]
clojure.core/not-every?                   [pred coll]
clojure.core/not=                         [x] [x y] [x y & more]
clojure.core/ns                           [name docstring? attr-map? references*]
clojure.core/ns-aliases                   [ns]
clojure.core/ns-imports                   [ns]
clojure.core/ns-interns                   [ns]
clojure.core/ns-map                       [ns]
clojure.core/ns-name                      [ns]
clojure.core/ns-publics                   [ns]
clojure.core/ns-refers                    [ns]
clojure.core/ns-resolve                   [ns sym] [ns env sym]
clojure.core/ns-unalias                   [ns sym]
clojure.core/ns-unmap                     [ns sym]
clojure.core/nth                          [coll index] [coll index not-found]
clojure.core/nthnext                      [coll n]
clojure.core/nthrest                      [coll n]
clojure.core/num                          [x]
clojure.core/number?                      [x]
clojure.core/numerator                    [r]
clojure.core/object-array                 [size-or-seq]
clojure.core/odd?                         [n]
clojure.core/or                           [] [x] [x & next]
clojure.core/parents                      [tag] [h tag]
clojure.core/partial                      [f] [f arg1] [f arg1 arg2] [f arg1 arg2 arg3] [f arg1 arg2 arg3 & more]
clojure.core/partition                    [n coll] [n step coll] [n step pad coll]
clojure.core/partition-all                [n coll] [n step coll]
clojure.core/partition-by                 [f coll]
clojure.core/pcalls                       [& fns]
clojure.core/peek                         [coll]
clojure.core/persistent!                  [coll]
clojure.core/pmap                         [f coll] [f coll & colls]
clojure.core/pop                          [coll]
clojure.core/pop!                         [coll]
clojure.core/pop-thread-bindings          []
clojure.core/pos?                         [x]
clojure.core/pr                           [] [x] [x & more]
clojure.core/pr-str                       [& xs]
clojure.core/prefer-method                [multifn dispatch-val-x dispatch-val-y]
clojure.core/prefers                      [multifn]
clojure.core/print                        [& more]
clojure.core/print-ctor                   [o print-args w]
clojure.core/print-simple                 [o w]
clojure.core/print-str                    [& xs]
clojure.core/printf                       [fmt & args]
clojure.core/println                      [& more]
clojure.core/println-str                  [& xs]
clojure.core/prn                          [& more]
clojure.core/prn-str                      [& xs]
clojure.core/promise                      []
clojure.core/proxy                        [class-and-interfaces args & fs]
clojure.core/proxy-call-with-super        [call this meth]
clojure.core/proxy-mappings               [proxy]
clojure.core/proxy-name                   [super interfaces]
clojure.core/proxy-super                  [meth & args]
clojure.core/push-thread-bindings         [bindings]
clojure.core/pvalues                      [& exprs]
clojure.core/quot                         [num div]
clojure.core/rand                         [] [n]
clojure.core/rand-int                     [n]
clojure.core/rand-nth                     [coll]
clojure.core/range                        [] [end] [start end] [start end step]
clojure.core/ratio?                       [n]
clojure.core/rational?                    [n]
clojure.core/rationalize                  [num]
clojure.core/re-find                      [m] [re s]
clojure.core/re-groups                    [m]
clojure.core/re-matcher                   [re s]
clojure.core/re-matches                   [re s]
clojure.core/re-pattern                   [s]
clojure.core/re-seq                       [re s]
clojure.core/read                         [] [stream] [stream eof-error? eof-value] [stream eof-error? eof-value recursive?]
clojure.core/read-line                    []
clojure.core/read-string                  [s]
clojure.core/realized?                    [x]
clojure.core/reduce                       [f coll] [f val coll]
clojure.core/reduce-kv                    [f init coll]
clojure.core/reduced                      [x]
clojure.core/reduced?                     [x]
clojure.core/reductions                   [f coll] [f init coll]
clojure.core/ref                          [x] [x & options]
clojure.core/ref-history-count            [ref]
clojure.core/ref-max-history              [ref] [ref n]
clojure.core/ref-min-history              [ref] [ref n]
clojure.core/ref-set                      [ref val]
clojure.core/refer                        [ns-sym & filters]
clojure.core/refer-clojure                [& filters]
clojure.core/reify                        [& opts+specs]
clojure.core/release-pending-sends        []
clojure.core/rem                          [num div]
clojure.core/remove                       [pred coll]
clojure.core/remove-all-methods           [multifn]
clojure.core/remove-method                [multifn dispatch-val]
clojure.core/remove-ns                    [sym]
clojure.core/remove-watch                 [reference key]
clojure.core/repeat                       [x] [n x]
clojure.core/repeatedly                   [f] [n f]
clojure.core/replace                      [smap coll]
clojure.core/replicate                    [n x]
clojure.core/require                      [& args]
clojure.core/reset!                       [atom newval]
clojure.core/reset-meta!                  [iref metadata-map]
clojure.core/resolve                      [sym] [env sym]
clojure.core/rest                         [coll]
clojure.core/restart-agent                [a new-state & options]
clojure.core/resultset-seq                [rs]
clojure.core/reverse                      [coll]
clojure.core/reversible?                  [coll]
clojure.core/rseq                         [rev]
clojure.core/rsubseq                      [sc test key] [sc start-test start-key end-test end-key]
clojure.core/satisfies?                   [protocol x]
clojure.core/second                       [x]
clojure.core/select-keys                  [map keyseq]
clojure.core/send                         [a f & args]
clojure.core/send-off                     [a f & args]
clojure.core/send-via                     [executor a f & args]
clojure.core/seq                          [coll]
clojure.core/seq?                         [x]
clojure.core/seque                        [s] [n-or-q s]
clojure.core/sequence                     [coll]
clojure.core/sequential?                  [coll]
clojure.core/set                          [coll]
clojure.core/set-agent-send-executor!     [executor]
clojure.core/set-agent-send-off-executor! [executor]
clojure.core/set-error-handler!           [a handler-fn]
clojure.core/set-error-mode!              [a mode-keyword]
clojure.core/set-validator!               [iref validator-fn]
clojure.core/set?                         [x]
clojure.core/short                        [x]
clojure.core/short-array                  [size-or-seq] [size init-val-or-seq]
clojure.core/shorts                       [xs]
clojure.core/shuffle                      [coll]
clojure.core/shutdown-agents              []
clojure.core/slurp                        [f & opts]
clojure.core/some                         [pred coll]
clojure.core/some->                       [expr & forms]
clojure.core/some->>                      [expr & forms]
clojure.core/some-fn                      [p] [p1 p2] [p1 p2 p3] [p1 p2 p3 & ps]
clojure.core/sort                         [coll] [comp coll]
clojure.core/sort-by                      [keyfn coll] [keyfn comp coll]
clojure.core/sorted-map                   [& keyvals]
clojure.core/sorted-map-by                [comparator & keyvals]
clojure.core/sorted-set                   [& keys]
clojure.core/sorted-set-by                [comparator & keys]
clojure.core/sorted?                      [coll]
clojure.core/special-symbol?              [s]
clojure.core/spit                         [f content & options]
clojure.core/split-at                     [n coll]
clojure.core/split-with                   [pred coll]
clojure.core/str                          [] [x] [x & ys]
clojure.core/string?                      [x]
clojure.core/struct                       [s & vals]
clojure.core/struct-map                   [s & inits]
clojure.core/subs                         [s start] [s start end]
clojure.core/subseq                       [sc test key] [sc start-test start-key end-test end-key]
clojure.core/subvec                       [v start] [v start end]
clojure.core/supers                       [class]
clojure.core/swap!                        [atom f] [atom f x] [atom f x y] [atom f x y & args]
clojure.core/symbol                       [name] [ns name]
clojure.core/symbol?                      [x]
clojure.core/sync                         [flags-ignored-for-now & body]
clojure.core/take                         [n coll]
clojure.core/take-last                    [n coll]
clojure.core/take-nth                     [n coll]
clojure.core/take-while                   [pred coll]
clojure.core/test                         [v]
clojure.core/the-ns                       [x]
clojure.core/thread-bound?                [& vars]
clojure.core/time                         [expr]
clojure.core/to-array                     [coll]
clojure.core/to-array-2d                  [coll]
clojure.core/trampoline                   [f] [f & args]
clojure.core/transient                    [coll]
clojure.core/tree-seq                     [branch? children root]
clojure.core/true?                        [x]
clojure.core/type                         [x]
clojure.core/unchecked-add                [x y]
clojure.core/unchecked-add-int            [x y]
clojure.core/unchecked-byte               [x]
clojure.core/unchecked-char               [x]
clojure.core/unchecked-dec                [x]
clojure.core/unchecked-dec-int            [x]
clojure.core/unchecked-divide-int         [x y]
clojure.core/unchecked-double             [x]
clojure.core/unchecked-float              [x]
clojure.core/unchecked-inc                [x]
clojure.core/unchecked-inc-int            [x]
clojure.core/unchecked-int                [x]
clojure.core/unchecked-long               [x]
clojure.core/unchecked-multiply           [x y]
clojure.core/unchecked-multiply-int       [x y]
clojure.core/unchecked-negate             [x]
clojure.core/unchecked-negate-int         [x]
clojure.core/unchecked-remainder-int      [x y]
clojure.core/unchecked-short              [x]
clojure.core/unchecked-subtract           [x y]
clojure.core/unchecked-subtract-int       [x y]
clojure.core/underive                     [tag parent] [h tag parent]
clojure.core/update-in                    [m [k & ks] f & args]
clojure.core/update-proxy                 [proxy mappings]
clojure.core/use                          [& args]
clojure.core/val                          [e]
clojure.core/vals                         [map]
clojure.core/var-get                      [x]
clojure.core/var-set                      [x val]
clojure.core/var?                         [v]
clojure.core/vary-meta                    [obj f & args]
clojure.core/vec                          [coll]
clojure.core/vector                       [] [a] [a b] [a b c] [a b c d] [a b c d & args]
clojure.core/vector-of                    [t] [t & elements]
clojure.core/vector?                      [x]
clojure.core/when                         [test & body]
clojure.core/when-first                   [bindings & body]
clojure.core/when-let                     [bindings & body]
clojure.core/when-not                     [test & body]
clojure.core/while                        [test & body]
clojure.core/with-bindings                [binding-map & body]
clojure.core/with-bindings*               [binding-map f & args]
clojure.core/with-in-str                  [s & body]
clojure.core/with-loading-context         [& body]
clojure.core/with-local-vars              [name-vals-vec & body]
clojure.core/with-meta                    [obj m]
clojure.core/with-open                    [bindings & body]
clojure.core/with-out-str                 [& body]
clojure.core/with-precision               [precision & exprs]
clojure.core/with-redefs                  [bindings & body]
clojure.core/with-redefs-fn               [binding-map func]
clojure.core/xml-seq                      [root]
clojure.core/zero?                        [x]
clojure.core/zipmap                       [keys vals]

;;; clojure.core.protocols {{{1

clojure.core.protocols/CollReduce
clojure.core.protocols/IKVReduce
clojure.core.protocols/InternalReduce
clojure.core.protocols/arr-impl
clojure.core.protocols/coll-reduce      [coll f] [coll f val]
clojure.core.protocols/emit-array-impls [& syms]
clojure.core.protocols/internal-reduce  [seq f start]
clojure.core.protocols/kv-reduce        [amap f init]

;;; clojure.instant {{{1

clojure.instant/parse-timestamp
clojure.instant/read-instant-calendar
clojure.instant/read-instant-date
clojure.instant/read-instant-timestamp
clojure.instant/validated [new-instance]

;;; clojure.java.browse {{{1

clojure.java.browse/*open-url-script*
clojure.java.browse/browse-url [url]

;;; clojure.java.io {{{1

clojure.java.io/Coercions
clojure.java.io/IOFactory
clojure.java.io/default-streams-impl
clojure.java.io/as-file            [x]
clojure.java.io/as-relative-path   [x]
clojure.java.io/as-url             [x]
clojure.java.io/copy               [input output & opts]
clojure.java.io/delete-file        [f & [silently]]
clojure.java.io/file               [arg] [parent child] [parent child & more]
clojure.java.io/input-stream       [x & opts]
clojure.java.io/make-input-stream  [x opts]
clojure.java.io/make-output-stream [x opts]
clojure.java.io/make-parents       [f & more]
clojure.java.io/make-reader        [x opts]
clojure.java.io/make-writer        [x opts]
clojure.java.io/output-stream      [x & opts]
clojure.java.io/reader             [x & opts]
clojure.java.io/resource           [n] [n loader]
clojure.java.io/writer             [x & opts]

;;; clojure.java.javadoc {{{1

clojure.java.javadoc/*core-java-api*
clojure.java.javadoc/*feeling-lucky*
clojure.java.javadoc/*feeling-lucky-url*
clojure.java.javadoc/*local-javadocs*
clojure.java.javadoc/*remote-javadocs*
clojure.java.javadoc/add-local-javadoc  [path]
clojure.java.javadoc/add-remote-javadoc [package-prefix url]
clojure.java.javadoc/javadoc            [class-or-object]

;;; clojure.java.shell {{{1

clojure.java.shell/*sh-dir*
clojure.java.shell/*sh-env*
clojure.java.shell/sh          [& args]
clojure.java.shell/with-sh-dir [dir & forms]
clojure.java.shell/with-sh-env [env & forms]

;;; clojure.main {{{1

clojure.main/repl-requires
clojure.main/demunge           [fn-name]
clojure.main/load-script       [path]
clojure.main/main              [& args]
clojure.main/repl              [& options]
clojure.main/repl-caught       [e]
clojure.main/repl-exception    [throwable]
clojure.main/repl-prompt       []
clojure.main/repl-read         [request-prompt request-exit]
clojure.main/root-cause        [t]
clojure.main/skip-if-eol       [s]
clojure.main/skip-whitespace   [s]
clojure.main/stack-element-str [el]
clojure.main/with-bindings     [& body]
clojure.main/with-read-known   [& body]

;;; clojure.pprint {{{1

clojure.pprint/*print-base*
clojure.pprint/*print-miser-width*
clojure.pprint/*print-pprint-dispatch*
clojure.pprint/*print-pretty*
clojure.pprint/*print-radix*
clojure.pprint/*print-right-margin*
clojure.pprint/*print-suppress-namespaces*
clojure.pprint/cl-format            [writer format-in & args]
clojure.pprint/code-dispatch        [object]
clojure.pprint/formatter            [format-in]
clojure.pprint/formatter-out        [format-in]
clojure.pprint/fresh-line           []
clojure.pprint/get-pretty-writer    [writer]
clojure.pprint/pp                   []
clojure.pprint/pprint               [object] [object writer]
clojure.pprint/pprint-indent        [relative-to n]
clojure.pprint/pprint-logical-block [options* body]
clojure.pprint/pprint-newline       [kind]
clojure.pprint/pprint-tab           [kind colnum colinc]
clojure.pprint/print-length-loop    [bindings & body]
clojure.pprint/print-table          [ks rows] [rows]
clojure.pprint/set-pprint-dispatch  [function]
clojure.pprint/simple-dispatch      [object]
clojure.pprint/with-pprint-dispatch [function & body]
clojure.pprint/write                [object & kw-args]
clojure.pprint/write-out            [object]

;;; clojure.repl {{{1

clojure.repl/apropos            [str-or-pattern]
clojure.repl/demunge            [fn-name]
clojure.repl/dir                [nsname]
clojure.repl/dir-fn             [ns]
clojure.repl/doc                [name]
clojure.repl/find-doc           [re-string-or-pattern]
clojure.repl/pst                [] [e-or-depth] [e depth]
clojure.repl/root-cause         [t]
clojure.repl/set-break-handler! [] [f]
clojure.repl/source             [n]
clojure.repl/source-fn          [x]
clojure.repl/stack-element-str  [el]
clojure.repl/thread-stopper     [] [thread]

;;; clojure.set {{{1

clojure.set/difference   [s1] [s1 s2] [s1 s2 & sets]
clojure.set/index        [xrel ks]
clojure.set/intersection [s1] [s1 s2] [s1 s2 & sets]
clojure.set/join         [xrel yrel] [xrel yrel km]
clojure.set/map-invert   [m]
clojure.set/project      [xrel ks]
clojure.set/rename       [xrel kmap]
clojure.set/rename-keys  [map kmap]
clojure.set/select       [pred xset]
clojure.set/subset?      [set1 set2]
clojure.set/superset?    [set1 set2]
clojure.set/union        [] [s1] [s1 s2] [s1 s2 & sets]

;;; clojure.stacktrace {{{1

clojure.stacktrace/e                   []
clojure.stacktrace/print-cause-trace   [tr] [tr n]
clojure.stacktrace/print-stack-trace   [tr] [tr n]
clojure.stacktrace/print-throwable     [tr]
clojure.stacktrace/print-trace-element [e]
clojure.stacktrace/root-cause          [tr]

;;; clojure.string {{{1

clojure.string/blank?               [s]
clojure.string/capitalize           [s]
clojure.string/escape               [s cmap]
clojure.string/join                 [coll] [separator coll]
clojure.string/lower-case           [s]
clojure.string/re-quote-replacement [replacement]
clojure.string/replace              [s match replacement]
clojure.string/replace-first        [s match replacement]
clojure.string/reverse              [s]
clojure.string/split                [s re] [s re limit]
clojure.string/split-lines          [s]
clojure.string/trim                 [s]
clojure.string/trim-newline         [s]
clojure.string/triml                [s]
clojure.string/trimr                [s]
clojure.string/upper-case           [s]

;;; clojure.template {{{1

clojure.template/apply-template [argv expr values]
clojure.template/do-template    [argv expr & values]

;;; clojure.test {{{1

clojure.test/*initial-report-counters*
clojure.test/*load-tests*
clojure.test/*report-counters*
clojure.test/*stack-trace-depth*
clojure.test/*test-out*
clojure.test/*testing-contexts*
clojure.test/*testing-vars*
clojure.test/assert-expr
clojure.test/report
clojure.test/use-fixtures
clojure.test/are                      [argv expr & args]
clojure.test/assert-any               [msg form]
clojure.test/assert-predicate         [msg form]
clojure.test/compose-fixtures         [f1 f2]
clojure.test/deftest                  [name & body]
clojure.test/deftest-                 [name & body]
clojure.test/do-report                [m]
clojure.test/file-position            [n]
clojure.test/function?                [x]
clojure.test/get-possibly-unbound-var [v]
clojure.test/inc-report-counter       [name]
clojure.test/is                       [form] [form msg]
clojure.test/join-fixtures            [fixtures]
clojure.test/run-all-tests            [] [re]
clojure.test/run-tests                [] [& namespaces]
clojure.test/set-test                 [name & body]
clojure.test/successful?              [summary]
clojure.test/test-all-vars            [ns]
clojure.test/test-ns                  [ns]
clojure.test/test-var                 [v]
clojure.test/testing                  [string & body]
clojure.test/testing-contexts-str     []
clojure.test/testing-vars-str         [m]
clojure.test/try-expr                 [msg form]
clojure.test/with-test                [definition & body]
clojure.test/with-test-out            [& body]

;;; clojure.tools.nrepl {{{1

clojure.tools.nrepl/uri-scheme
clojure.tools.nrepl/url-connect
clojure.tools.nrepl/version
clojure.tools.nrepl/client              [transport response-timeout]
clojure.tools.nrepl/client-session      [client & {:keys [session clone]}]
clojure.tools.nrepl/code                [& body]
clojure.tools.nrepl/code*               [& expressions]
clojure.tools.nrepl/combine-responses   [responses]
clojure.tools.nrepl/connect             [& {:keys [port host transport-fn], :or {transport-fn transport/bencode, host "localhost"}}]
clojure.tools.nrepl/message             [client {:keys [id], :as msg, :or {id (uuid)}}]
clojure.tools.nrepl/new-session         [client & {:keys [clone]}]
clojure.tools.nrepl/read-response-value [{:keys [value], :as msg}]
clojure.tools.nrepl/response-seq        [transport] [transport timeout]
clojure.tools.nrepl/response-values     [responses]

;;; clojure.tools.nrepl.ack {{{1

clojure.tools.nrepl.ack/handle-ack      [h]
clojure.tools.nrepl.ack/reset-ack-port! []
clojure.tools.nrepl.ack/send-ack        [my-port ack-port]
clojure.tools.nrepl.ack/wait-for-ack    [timeout]

;;; clojure.tools.nrepl.bencode {{{1

clojure.tools.nrepl.bencode/colon
clojure.tools.nrepl.bencode/comma
clojure.tools.nrepl.bencode/d
clojure.tools.nrepl.bencode/e
clojure.tools.nrepl.bencode/i
clojure.tools.nrepl.bencode/l
clojure.tools.nrepl.bencode/minus
clojure.tools.nrepl.bencode/write-bencode
clojure.tools.nrepl.bencode/read-bencode    [input]
clojure.tools.nrepl.bencode/read-netstring  [input]
clojure.tools.nrepl.bencode/write-netstring [output content]

;;; clojure.tools.nrepl.middleware {{{1

clojure.tools.nrepl.middleware/linearize-middleware-stack [middlewares]
clojure.tools.nrepl.middleware/set-descriptor!            [middleware-var descriptor]
clojure.tools.nrepl.middleware/wrap-describe              [h]

;;; clojure.tools.nrepl.middleware.interruptible-eval {{{1

clojure.tools.nrepl.middleware.interruptible-eval/*msg*
clojure.tools.nrepl.middleware.interruptible-eval/evaluate           [bindings {:keys [code ns transport], :as msg}]
clojure.tools.nrepl.middleware.interruptible-eval/interruptible-eval [h & {:keys [executor], :or {executor (configure-executor)}}]

;;; clojure.tools.nrepl.middleware.load-file {{{1

clojure.tools.nrepl.middleware.load-file/load-file-code [file file-path file-name]
clojure.tools.nrepl.middleware.load-file/wrap-load-file [h]

;;; clojure.tools.nrepl.middleware.pr-values {{{1

clojure.tools.nrepl.middleware.pr-values/pr-values [h]

;;; clojure.tools.nrepl.middleware.session {{{1

clojure.tools.nrepl.middleware.session/clojure.tools.nrepl.middleware.session.proxy$java.io.Reader$0
clojure.tools.nrepl.middleware.session/clojure.tools.nrepl.middleware.session.proxy$java.io.Writer$0
clojure.tools.nrepl.middleware.session/add-stdin [h]
clojure.tools.nrepl.middleware.session/session   [h]

;;; clojure.tools.nrepl.misc {{{1

clojure.tools.nrepl.misc/log          [ex & msgs]
clojure.tools.nrepl.misc/response-for [{:keys [session id]} & response-data]
clojure.tools.nrepl.misc/returning    [x & body]
clojure.tools.nrepl.misc/uuid         []

;;; clojure.tools.nrepl.server {{{1

clojure.tools.nrepl.server/default-middlewares
clojure.tools.nrepl.server/->Server        [server-socket port open-transports transport greeting handler]
clojure.tools.nrepl.server/default-handler [& additional-middlewares]
clojure.tools.nrepl.server/handle          [handler transport]
clojure.tools.nrepl.server/handle*         [msg handler transport]
clojure.tools.nrepl.server/map->Server     [m__5818__auto__]
clojure.tools.nrepl.server/start-server    [& {:keys [port bind transport-fn handler ack-port greeting-fn], :or {port 0}}]
clojure.tools.nrepl.server/stop-server     [{:keys [open-transports server-socket], :as server}]
clojure.tools.nrepl.server/unknown-op      [{:keys [op transport], :as msg}]

;;; clojure.tools.nrepl.transport {{{1

clojure.tools.nrepl.transport/Transport
clojure.tools.nrepl.transport/->FnTransport    [recv-fn send-fn close]
clojure.tools.nrepl.transport/->QueueTransport [in out]
clojure.tools.nrepl.transport/bencode          [s] [in out & [s]]
clojure.tools.nrepl.transport/fn-transport     [read write] [read write close]
clojure.tools.nrepl.transport/piped-transports []
clojure.tools.nrepl.transport/recv             [this] [this timeout]
clojure.tools.nrepl.transport/send             [this msg]
clojure.tools.nrepl.transport/tty              [s] [in out & [s]]
clojure.tools.nrepl.transport/tty-greeting     [transport]

;;; clojure.tools.trace {{{1

clojure.tools.trace/trace-special-form
clojure.tools.trace/deftrace                [name & definition]
clojure.tools.trace/dotrace                 [fnames & exprs]
clojure.tools.trace/trace                   [value] [name value]
clojure.tools.trace/trace-compose-exception [exception message]
clojure.tools.trace/trace-fn-call           [name f args]
clojure.tools.trace/trace-form              [form]
clojure.tools.trace/trace-forms             [& body]
clojure.tools.trace/trace-ns                [ns]
clojure.tools.trace/trace-ns*               [ns]
clojure.tools.trace/trace-var*              [ns s] [v]
clojure.tools.trace/trace-vars              [& vs]
clojure.tools.trace/traceable?              [v]
clojure.tools.trace/traced?                 [v]
clojure.tools.trace/untrace-ns              [ns]
clojure.tools.trace/untrace-ns*             [ns]
clojure.tools.trace/untrace-var*            [ns s] [v]
clojure.tools.trace/untrace-vars            [& vs]

;;; clojure.uuid {{{1



;;; clojure.walk {{{1

clojure.walk/keywordize-keys  [m]
clojure.walk/macroexpand-all  [form]
clojure.walk/postwalk         [f form]
clojure.walk/postwalk-demo    [form]
clojure.walk/postwalk-replace [smap form]
clojure.walk/prewalk          [f form]
clojure.walk/prewalk-demo     [form]
clojure.walk/prewalk-replace  [smap form]
clojure.walk/stringify-keys   [m]
clojure.walk/walk             [inner outer form]

;;; complete.core {{{1

complete.core/classfiles
complete.core/nested-classes
complete.core/potential-completions
complete.core/special-forms
complete.core/top-level-classes
complete.core/completions     [prefix] [prefix ns]
complete.core/namespaces      [ns]
complete.core/ns-classes      [ns]
complete.core/ns-java-methods [ns]
complete.core/ns-public-vars  [ns]
complete.core/ns-vars         [ns]
complete.core/path-files      [path]
complete.core/resolve-class   [sym]
complete.core/static-members  [class]

;;; example {{{1

example/global-options
example/global-usage
example/server-options
example/server-usage
example/version
example/-main      [& argv]
example/exit       [status msg]
example/server-cmd [argv]
example/unindent   [s]

;;; guns.cli.optparse {{{1

guns.cli.optparse/compile-option-specs  [options]
guns.cli.optparse/parse                 [argv [& options] & opts]
guns.cli.optparse/process-option-tokens [specs opt-tokens]
guns.cli.optparse/required-arguments    [specs]
guns.cli.optparse/summarize             [specs]
guns.cli.optparse/tokenize-arguments    [required argv & opts]

;;; user {{{1

user/benchmark   [expr] [n expr]
user/debug       [x] [x & xs]
user/dump-locals []
user/trace       [expr] [nspace expr]

;; vim:ft=clojure:fdm=marker: