/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.Join;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.BackendsXml;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class BackendsYamlReader {
    private static final String FILENAME = "backends.yaml";
    private String appDir;

    public BackendsYamlReader(String appDir) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            appDir = appDir + File.separatorChar;
        }
        this.appDir = appDir;
    }

    public String getFilename() {
        return this.appDir + FILENAME;
    }

    public BackendsXml parse() {
        if (new File(this.getFilename()).exists()) {
            try {
                return BackendsYamlReader.parse(new FileReader(this.getFilename()));
            }
            catch (FileNotFoundException ex) {
                throw new AppEngineConfigException("Cannot find file " + this.getFilename(), ex);
            }
        }
        return null;
    }

    public static BackendsXml parse(Reader yaml) {
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setPropertyElementType(BackendsYaml.class, "backends", BackendsYaml.Entry.class);
        try {
            BackendsYaml backendsYaml = reader.read(BackendsYaml.class);
            if (backendsYaml == null) {
                throw new AppEngineConfigException("Empty backends configuration.");
            }
            return backendsYaml.toXml();
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    public static BackendsXml parse(String yaml) {
        return BackendsYamlReader.parse(new StringReader(yaml));
    }

    public static class BackendsYaml {
        private List<Entry> backends;

        public List<Entry> getBackends() {
            return this.backends;
        }

        public void setBackends(List<Entry> backends) {
            this.backends = backends;
        }

        public BackendsXml toXml() {
            BackendsXml xml = new BackendsXml();
            for (Entry backend : this.backends) {
                xml.addBackend(backend.toXml());
            }
            return xml;
        }

        public static class EntryBeanInfo
        extends SimpleBeanInfo {
            @Override
            public PropertyDescriptor[] getPropertyDescriptors() {
                try {
                    return new PropertyDescriptor[]{new PropertyDescriptor("name", Entry.class), new PropertyDescriptor("instances", Entry.class), new PropertyDescriptor("class", Entry.class, "getInstanceClass", "setInstanceClass"), new PropertyDescriptor("state", Entry.class), new PropertyDescriptor("max_concurrent_requests", Entry.class), new PropertyDescriptor("options", Entry.class)};
                }
                catch (IntrospectionException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        public static class Entry {
            private String name;
            private Integer instances;
            private String instanceClass;
            private BackendsXml.State state;
            private Integer maxConcurrentRequests;
            private Set<BackendsXml.Option> options = EnumSet.noneOf(BackendsXml.Option.class);

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public Integer getInstances() {
                return this.instances;
            }

            public void setInstances(Integer instances) {
                this.instances = instances;
            }

            public String getInstanceClass() {
                return this.instanceClass;
            }

            public void setInstanceClass(String instanceClass) {
                this.instanceClass = instanceClass;
            }

            public Integer getMax_concurrent_requests() {
                return this.maxConcurrentRequests;
            }

            public void setMax_concurrent_requests(Integer maxConcurrentRequests) {
                this.maxConcurrentRequests = maxConcurrentRequests;
            }

            public String getOptions() {
                ArrayList<String> optionNames = new ArrayList<String>();
                for (BackendsXml.Option option : this.options) {
                    optionNames.add(option.getYamlValue());
                }
                return Join.join(", ", optionNames);
            }

            public void setOptions(String optionString) {
                this.options.clear();
                for (String optionName : optionString.split(" *, *")) {
                    this.options.add(BackendsXml.Option.fromYamlValue(optionName));
                }
            }

            public String getState() {
                return this.state != null ? this.state.getYamlValue() : null;
            }

            public void setState(String state) {
                this.state = state != null ? BackendsXml.State.fromYamlValue(state) : null;
            }

            public BackendsXml.Entry toXml() {
                return new BackendsXml.Entry(this.name, this.instances, this.instanceClass, this.maxConcurrentRequests, this.options, this.state);
            }
        }
    }
}

