/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.AppContext;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerClassLoader;
import com.google.appengine.tools.development.agent.AppEngineDevAgent;
import com.google.apphosting.utils.security.SecurityManagerInstaller;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.Permission;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyPermission;

public class DevAppServerFactory {
    static final String DEV_APP_SERVER_CLASS = "com.google.appengine.tools.development.DevAppServerImpl";
    private static final Class[] DEV_APPSERVER_CTOR_ARG_TYPES = new Class[]{File.class, File.class, File.class, File.class, String.class, Integer.TYPE, Boolean.TYPE, Map.class};
    private static final String USER_CODE_CLASSPATH_MANAGER_PROP = "devappserver.userCodeClasspathManager";
    private static final String USER_CODE_CLASSPATH = "devappserver.userCodeClasspathManager.classpath";
    private static final String USER_CODE_REQUIRES_WEB_INF = "devappserver.userCodeClasspathManager.requiresWebInf";

    public DevAppServer createDevAppServer(File appDir, String address, int port) {
        return this.createDevAppServer(appDir, null, address, port);
    }

    public DevAppServer createDevAppServer(File appDir, File externalResourceDir, String address, int port) {
        return this.createDevAppServer(appDir, externalResourceDir, null, null, address, port, true, true, new HashMap<String, Object>());
    }

    public DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Collection<URL> classpath) {
        Map<String, Object> containerConfigProps = this.newContainerConfigPropertiesForTest(classpath);
        return this.createDevAppServer(appDir, null, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProps);
    }

    private DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler) {
        return this.createDevAppServer(appDir, null, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, true, new HashMap<String, Object>());
    }

    private DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Map<String, Object> containerConfigProperties) {
        return this.createDevAppServer(appDir, null, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProperties);
    }

    private DevAppServer createDevAppServer(File appDir, File externalResourceDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Map<String, Object> containerConfigProperties) {
        DevAppServer devAppServer;
        if (installSecurityManager) {
            SecurityManagerInstaller.install(new URL[0]);
        }
        DevAppServerClassLoader loader = DevAppServerClassLoader.newClassLoader(DevAppServerFactory.class.getClassLoader());
        this.testAgentIsInstalled();
        try {
            Class<?> devAppServerClass = Class.forName(DEV_APP_SERVER_CLASS, true, loader);
            Constructor<?> cons = devAppServerClass.getConstructor(DEV_APPSERVER_CTOR_ARG_TYPES);
            cons.setAccessible(true);
            devAppServer = (DevAppServer)cons.newInstance(appDir, externalResourceDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, containerConfigProperties);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException) {
                t = e.getCause();
            }
            throw new RuntimeException("Unable to create a DevAppServer", t);
        }
        if (installSecurityManager) {
            System.setSecurityManager(new CustomSecurityManager(devAppServer));
        }
        return devAppServer;
    }

    private Map<String, Object> newContainerConfigPropertiesForTest(Collection<URL> classpath) {
        HashMap<String, Object> containerConfigProps = new HashMap<String, Object>();
        HashMap<String, Object> userCodeClasspathManagerProps = new HashMap<String, Object>();
        userCodeClasspathManagerProps.put(USER_CODE_CLASSPATH, classpath);
        userCodeClasspathManagerProps.put(USER_CODE_REQUIRES_WEB_INF, false);
        containerConfigProps.put(USER_CODE_CLASSPATH_MANAGER_PROP, userCodeClasspathManagerProps);
        return containerConfigProps;
    }

    private void testAgentIsInstalled() {
        try {
            AppEngineDevAgent.getAgent();
        }
        catch (Throwable t) {
            String msg = "Unable to locate the App Engine agent. Please use dev_appserver, KickStart,  or set the jvm flag: \"-javaagent:<sdk_root>/lib/agent/appengine-agent.jar\"";
            throw new RuntimeException(msg, t);
        }
    }

    private static class CustomSecurityManager
    extends SecurityManager {
        private static final RuntimePermission PERMISSION_MODIFY_THREAD_GROUP = new RuntimePermission("modifyThreadGroup");
        private static final RuntimePermission PERMISSION_MODIFY_THREAD = new RuntimePermission("modifyThread");
        private static final String KEYCHAIN_JNILIB = "/libkeychain.jnilib";
        private static final Object PERMISSION_LOCK = new Object();
        private final DevAppServer devAppServer;

        public CustomSecurityManager(DevAppServer devAppServer) {
            this.devAppServer = devAppServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean appHasPermission(Permission perm) {
            StackTraceElement frame;
            Object object = PERMISSION_LOCK;
            synchronized (object) {
                AppContext context = this.devAppServer.getAppContext();
                if (context.getUserPermissions().implies(perm) || context.getApplicationPermissions().implies(perm)) {
                    return true;
                }
            }
            if (PERMISSION_MODIFY_THREAD.equals(perm) && ("java.util.concurrent.ThreadPoolExecutor".equals((frame = this.getCallerFrame()).getClassName()) || "java.lang.Thread".equals(frame.getClassName()) && "interrupt".equals(frame.getMethodName()) || "java.lang.Thread".equals(frame.getClassName()) && "setUncaughtExceptionHandler".equals(frame.getMethodName()))) {
                return true;
            }
            return "read".equals(perm.getActions()) && perm.getName().endsWith(KEYCHAIN_JNILIB);
        }

        @Override
        public void checkPermission(Permission perm) {
            if (perm instanceof PropertyPermission) {
                return;
            }
            if (this.isDevAppServerThread()) {
                if (this.appHasPermission(perm)) {
                    return;
                }
                super.checkPermission(perm);
            }
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
            if (this.isDevAppServerThread()) {
                if (this.appHasPermission(perm)) {
                    return;
                }
                super.checkPermission(perm, context);
            }
        }

        @Override
        public void checkAccess(ThreadGroup g) {
            if (g == null) {
                throw new NullPointerException("thread group can't be null");
            }
            this.checkPermission(PERMISSION_MODIFY_THREAD_GROUP);
        }

        @Override
        public void checkAccess(Thread t) {
            if (t == null) {
                throw new NullPointerException("thread can't be null");
            }
            this.checkPermission(PERMISSION_MODIFY_THREAD);
        }

        public boolean isDevAppServerThread() {
            return Boolean.getBoolean("devappserver-thread-" + Thread.currentThread().getName());
        }

        private StackTraceElement getCallerFrame() {
            StackTraceElement[] frames = Thread.currentThread().getStackTrace();
            for (int i = 1; i < frames.length; ++i) {
                if ("checkAccess".equals(frames[i].getMethodName()) || this.getClass().getName().equals(frames[i].getClassName())) continue;
                return frames[i];
            }
            throw new IllegalStateException("Unable to determine calling frame.");
        }
    }
}

