/*
 * Decompiled with CFR 0.152.
 */
package guitplugin;

import com.guit.client.apt.GwtController;
import com.guit.client.apt.GwtDisplay;
import guitplugin.Generated;
import guitplugin.guitview.GuitViewHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.xml.sax.SAXParseException;

@SupportedAnnotationTypes(value={"com.guit.client.apt.GwtPresenter", "com.guit.client.apt.GwtController"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class GuitPresenterProcessor
extends AbstractProcessor {
    String domPackage = "com.google.gwt.event.dom.client.";
    String sharedPackage = "com.google.gwt.event.logical.shared.";
    String aptPackage = "com.guit.client.apt.";
    private static final String containerError = "A gwt container method can only have 1 parameter of a type IsWidget";
    private Elements elementsUtil;
    private Filer filer;
    private Types typeUtils;
    private ProcessingEnvironment env;
    static HashMap<String, String> element2dom = new HashMap();

    private void collectGetters(HashMap<String, ExecutableElement> validFields, TypeElement eventType) {
        TypeMirror superclass;
        if (eventType == null) {
            return;
        }
        List<ExecutableElement> classMethods = ElementFilter.methodsIn(this.elementsUtil.getAllMembers(eventType));
        for (ExecutableElement methodDeclaration : classMethods) {
            String string = methodDeclaration.getSimpleName().toString();
            TypeMirror returnType = methodDeclaration.getReturnType();
            if (returnType.getKind().equals((Object)TypeKind.VOID)) continue;
            if (string.startsWith("get")) {
                String string3 = string.substring(3);
                string3 = string3.substring(0, 1).toLowerCase() + string3.substring(1);
                validFields.put(string3, methodDeclaration);
                continue;
            }
            if (!string.startsWith("is") || !this.typeUtils.getPrimitiveType(TypeKind.BOOLEAN).equals(returnType)) continue;
            String string5 = string.substring(2);
            string5 = string5.substring(0, 1).toLowerCase() + string5.substring(1);
            validFields.put(string5, methodDeclaration);
        }
        List<? extends TypeMirror> superinterfaces = eventType.getInterfaces();
        for (TypeMirror typeMirror : superinterfaces) {
            this.collectGetters(validFields, (TypeElement)this.typeUtils.asElement(typeMirror));
        }
        if (eventType.getKind().equals((Object)ElementKind.CLASS) && (superclass = eventType.getSuperclass()) != null) {
            this.collectGetters(validFields, (TypeElement)this.typeUtils.asElement(superclass));
        }
    }

    protected String eventClassNameToEventName(String simpleName) {
        String eventName = simpleName.substring(0, simpleName.length() - 5);
        eventName = eventName.substring(0, 1).toLowerCase() + eventName.substring(1);
        return eventName;
    }

    protected String eventNameToEventClassName(String eventName) {
        eventName = eventName.substring(0, 1).toUpperCase() + eventName.substring(1) + "Event";
        return eventName;
    }

    private String fieldsToString(Set<String> names) {
        StringBuilder sb = new StringBuilder();
        for (String f : names) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(f);
        }
        return sb.toString();
    }

    private HashMap<String, ExecutableElement> getValidFields(TypeElement eventType) {
        HashMap<String, ExecutableElement> validFields = new HashMap<String, ExecutableElement>();
        this.collectGetters(validFields, eventType);
        return validFields;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.env = this.processingEnv;
        if (roundEnv.processingOver()) {
            return false;
        }
        this.elementsUtil = this.env.getElementUtils();
        this.filer = this.env.getFiler();
        this.typeUtils = this.env.getTypeUtils();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!element.getKind().equals((Object)ElementKind.CLASS)) continue;
                TypeElement d = (TypeElement)element;
                try {
                    this.generateBinder(d);
                    String annName = typeElement.getQualifiedName().toString();
                    if (annName.equals(GwtController.class.getCanonicalName())) {
                        this.generateControllerSuper(d);
                        this.processController(d);
                    } else if (annName.equals(this.aptPackage + "GwtPresenter")) {
                        HashMap<String, HashMap<String, String>> fieldsMap = null;
                        try {
                            fieldsMap = GuitViewHelper.findUiFields(this.filer, d);
                        }
                        catch (SAXParseException ex) {
                            this.printMessage(Diagnostic.Kind.NOTE, String.format("Error parsing XML (line " + ex.getLineNumber() + "): " + ex.getMessage(), new Object[0]), d);
                            this.printMessage(Diagnostic.Kind.ERROR, String.format("Error parsing XML (line " + ex.getLineNumber() + "): " + ex.getMessage(), new Object[0]), d);
                            continue;
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                        this.generatePresenterSuper(d, fieldsMap);
                        this.processController(d);
                        for (Map.Entry<String, HashMap<String, String>> entry : fieldsMap.entrySet()) {
                            this.processPresenterWithOneXml(d, entry.getKey(), entry.getValue());
                        }
                    }
                    for (ExecutableElement m : ElementFilter.methodsIn(this.elementsUtil.getAllMembers(d))) {
                        VariableElement parameter;
                        if (m.getAnnotation(GwtDisplay.class) == null) continue;
                        List<? extends VariableElement> parameters = m.getParameters();
                        if (parameters.size() != 1) {
                            this.printMessage(Diagnostic.Kind.ERROR, containerError, m);
                        }
                        if (!((Object)(parameter = (VariableElement)parameters.iterator().next()).asType()).toString().equals("com.google.gwt.user.client.ui.IsWidget")) {
                            this.printMessage(Diagnostic.Kind.ERROR, containerError, parameter);
                        }
                        this.processContainerMethod(d, m);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    private void printMessage(Diagnostic.Kind kind, String msg, Element e) {
        if (this.isEclipse()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, msg, e);
        }
        this.env.getMessager().printMessage(kind, msg, e);
    }

    private boolean isEclipse() {
        try {
            this.filer.getResource(StandardLocation.SOURCE_PATH, "", "");
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private void generateBinder(TypeElement classDeclaration) {
        String packageName = this.elementsUtil.getPackageOf(classDeclaration).getQualifiedName().toString();
        String simpleName = classDeclaration.getSimpleName().toString();
        String name = simpleName + "Binder";
        String qualifiedName = packageName + "." + name;
        PrintWriter writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + packageName + ";");
        writer.println();
        Generated.printGeneratedImport(writer);
        writer.println("import com.guit.client.binder.GuitBinder;");
        writer.println();
        List<? extends TypeParameterElement> parameters = classDeclaration.getTypeParameters();
        if (parameters != null && parameters.size() > 0) {
            writer.println("@SuppressWarnings(\"rawtypes\")");
        }
        Generated.printGenerated(writer, simpleName);
        writer.println("public interface " + name + " extends GuitBinder<" + simpleName + "> {");
        writer.println("}");
        writer.close();
    }

    private void generatePresenterSuper(TypeElement classDeclaration, HashMap<String, HashMap<String, String>> fieldsMap) {
        String qualifiedName;
        Boolean elemental = false;
        List<? extends AnnotationMirror> annotations = classDeclaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            Element decl = annotationMirror.getAnnotationType().asElement();
            if (decl == null || !(qualifiedName = ((TypeElement)decl).getQualifiedName().toString()).equals("com.guit.client.apt.GwtPresenter")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                String name = e.getKey().getSimpleName().toString();
                if (!name.equals("elemental")) continue;
                elemental = (Boolean)e.getValue().getValue();
            }
        }
        String packageName = this.elementsUtil.getPackageOf(classDeclaration).getQualifiedName().toString();
        String string = classDeclaration.getSimpleName().toString();
        String name = string + "Presenter";
        qualifiedName = packageName + "." + name;
        PrintWriter writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + packageName + ";");
        writer.println();
        Generated.printGenerated(writer, string);
        String extendsPresenter = this.getExtendsPresenter(classDeclaration);
        TypeElement extendsPresenterElement = this.elementsUtil.getTypeElement(extendsPresenter);
        Set<String> allFields = this.getAllField(extendsPresenterElement);
        allFields.addAll(this.getAllField(classDeclaration));
        writer.println("public abstract class " + name + " extends " + extendsPresenter + "<" + string + "Binder> {");
        this.printDriver(classDeclaration, writer);
        this.printDependencies(classDeclaration, writer);
        for (Map.Entry<String, String> entry : fieldsMap.entrySet().iterator().next().getValue().entrySet()) {
            if (allFields.contains(entry.getKey())) continue;
            if (entry.getValue().startsWith("com.guit.client.dom")) {
                writer.println();
                writer.println("  @com.guit.client.apt.Generated");
                writer.println("  @com.guit.client.binder.ViewField");
                writer.println("  " + (elemental != false ? this.getElementalElementFor(entry.getValue()) : entry.getValue()) + " " + entry.getKey() + ";");
                continue;
            }
            if (this.isCssResource(this.elementsUtil.getTypeElement(entry.getValue()))) {
                writer.println();
                writer.println("  @com.guit.client.apt.Generated");
                writer.println("  @com.guit.client.binder.ViewField");
                writer.println("  " + entry.getValue() + " " + entry.getKey() + ";");
                continue;
            }
            if (this.isPresenter(this.elementsUtil.getTypeElement(entry.getValue()))) {
                writer.println();
                writer.println("  @com.guit.client.apt.Generated");
                writer.println("  @com.google.inject.Inject");
                writer.println("  @com.guit.client.binder.ViewField(provided = true)");
                writer.println("  " + entry.getValue() + " " + entry.getKey() + ";");
                continue;
            }
            if (!entry.getValue().startsWith("com.google.gwt")) {
                writer.println();
                writer.println("  @com.guit.client.apt.Generated");
                writer.println("  @com.google.inject.Inject");
                writer.println("  @com.guit.client.binder.ViewField(provided = true)");
                writer.println("  " + entry.getValue() + " " + entry.getKey() + ";");
                continue;
            }
            writer.println();
            writer.println("  @com.guit.client.apt.Generated");
            writer.println("  @com.guit.client.binder.ViewField");
            writer.println("  " + entry.getValue() + " " + entry.getKey() + ";");
        }
        writer.println("}");
        writer.close();
    }

    private String getElementalElementFor(String name) {
        try {
            String tagname = name.toLowerCase().substring(name.lastIndexOf(".") + 1);
            String gwtnode = element2dom.get(tagname);
            return "elemental.js.html.Js" + gwtnode.substring(gwtnode.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            return "elemental.js.dom.JsElement";
        }
    }

    private boolean isPresenter(TypeElement type) {
        List<? extends AnnotationMirror> annotations = type.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            Element asElement = annotationMirror.getAnnotationType().asElement();
            String qualifiedName = ((TypeElement)asElement).getQualifiedName().toString();
            if (!qualifiedName.equals(this.aptPackage + "GwtPresenter")) continue;
            return true;
        }
        for (TypeMirror typeMirror : type.getInterfaces()) {
            if (!((Object)typeMirror).toString().equals("com.guit.client.Presenter")) continue;
            return true;
        }
        Element superclass = this.typeUtils.asElement(type.getSuperclass());
        if (superclass != null) {
            return this.isPresenter((TypeElement)superclass);
        }
        return false;
    }

    private boolean isCssResource(TypeElement type) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            if (!((Object)typeMirror).toString().equals("com.google.gwt.resources.client.CssResource")) continue;
            return true;
        }
        Element superclass = this.typeUtils.asElement(type.getSuperclass());
        if (superclass != null) {
            return this.isCssResource((TypeElement)superclass);
        }
        return false;
    }

    private Set<String> getAllField(TypeElement clazz) {
        HashSet<String> allFields = new HashSet<String>();
        for (VariableElement f : ElementFilter.fieldsIn(this.elementsUtil.getAllMembers(clazz))) {
            allFields.add(f.getSimpleName().toString());
        }
        return allFields;
    }

    private void printDependencies(TypeElement classDeclaration, PrintWriter writer) {
        try {
            this.printDependenciesMaven(classDeclaration, writer, ((Object)this.filer.getResource(StandardLocation.SOURCE_PATH, this.elementsUtil.getPackageOf(classDeclaration).getQualifiedName().toString(), classDeclaration.getSimpleName() + ".java").getCharContent(true)).toString());
        }
        catch (Exception e) {
            this.printDependenciesEclipse(classDeclaration, writer);
        }
    }

    private void printDependenciesMaven(TypeElement classDeclaration, PrintWriter writer, String source) {
        HashMap<String, String> imports = new HashMap<String, String>();
        String[] lines = source.split("\\r?\\n");
        String injections = null;
        for (String l : lines) {
            if ((l = l.trim()).isEmpty()) continue;
            if (l.startsWith("import ")) {
                l = l.substring(7, l.length() - 1);
                imports.put(l.substring(l.lastIndexOf(".") + 1), l);
                continue;
            }
            if (!l.startsWith("@Injections")) continue;
            injections = l;
            String substring = injections.substring(13, injections.length() - 2);
            for (String clazz : substring.split(",")) {
                clazz = clazz.trim();
                clazz = clazz.substring(0, clazz.length() - 6);
                writer.println();
                if (imports.containsKey(clazz)) {
                    clazz = (String)imports.get(clazz);
                }
                String name = clazz.substring(clazz.lastIndexOf(".") + 1);
                writer.println("  @com.google.inject.Inject");
                writer.println("  " + clazz + " " + name.substring(0, 1).toLowerCase() + name.substring(1) + ";");
            }
            return;
        }
    }

    private void printDependenciesEclipse(TypeElement classDeclaration, PrintWriter writer) {
        List<? extends AnnotationMirror> annotations = classDeclaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String annName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (!annName.equals("com.guit.client.apt.Injections")) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> v : values.entrySet()) {
                if (!v.getKey().getSimpleName().toString().equals("value")) continue;
                List classes = (List)v.getValue().getValue();
                for (Object inject : classes) {
                    String clazz = inject.toString();
                    if (clazz.equals("<error>")) {
                        return;
                    }
                    writer.println();
                    if (clazz.endsWith(".class")) {
                        clazz = clazz.substring(0, clazz.length() - 6);
                    }
                    String name = clazz.substring(clazz.lastIndexOf(".") + 1);
                    writer.println("  @com.google.inject.Inject");
                    writer.println("  " + clazz + " " + name.substring(0, 1).toLowerCase() + name.substring(1) + ";");
                }
                return;
            }
        }
    }

    private void printDriver(TypeElement classDeclaration, PrintWriter writer) {
        List<? extends AnnotationMirror> annotations = classDeclaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String qualifiedName;
            Element decl = annotationMirror.getAnnotationType().asElement();
            if (decl == null || !(qualifiedName = ((TypeElement)decl).getQualifiedName().toString()).equals("com.guit.client.binder.GwtEditor")) continue;
            String pojo = null;
            String base = "com.google.gwt.editor.client.SimpleBeanEditorDriver";
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                String name = entry.getKey().getSimpleName().toString();
                if (name.equals("pojo")) {
                    pojo = entry.getValue().getValue().toString();
                    continue;
                }
                if (!name.equals("base")) continue;
                base = entry.getValue().getValue().toString();
            }
            if (pojo != null) {
                writer.println();
                writer.println("  " + base + "<" + pojo + ", ?> driver;");
            }
            return;
        }
    }

    private void generateControllerSuper(TypeElement classDeclaration) {
        String packageName = this.elementsUtil.getPackageOf(classDeclaration).getQualifiedName().toString();
        String simpleName = classDeclaration.getSimpleName().toString();
        String name = simpleName + "Controller";
        String qualifiedName = packageName + "." + name;
        PrintWriter writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + packageName + ";");
        writer.println();
        writer.println("import com.guit.client.GuitController;");
        Generated.printGeneratedImport(writer);
        writer.println();
        String binderName = simpleName + "Binder";
        Generated.printGenerated(writer, simpleName);
        writer.println("public abstract class " + name + " extends GuitController<" + binderName + "> {");
        writer.println("}");
        writer.close();
    }

    private String getExtendsPresenter(TypeElement classDeclaration) {
        List<? extends AnnotationMirror> annotations = classDeclaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String qualifiedName;
            Element decl = annotationMirror.getAnnotationType().asElement();
            if (decl == null || !(qualifiedName = ((TypeElement)decl).getQualifiedName().toString()).equals("com.guit.client.apt.GwtPresenter")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("extendsPresenter")) continue;
                return entry.getValue().getValue().toString();
            }
        }
        return "com.guit.client.GuitPresenter";
    }

    /*
     * WARNING - void declaration
     */
    private void processPresenterWithOneXml(TypeElement classDeclaration, String viewName, HashMap<String, String> hashMap) {
        List<? extends AnnotationMirror> annotations = classDeclaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String qualifiedName;
            Element decl = annotationMirror.getAnnotationType().asElement();
            if (decl == null || !(qualifiedName = ((TypeElement)decl).getQualifiedName().toString()).equals("com.guit.client.apt.GwtPresenter")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                String field;
                String string = e.getKey().getSimpleName().toString();
                if (!string.equals("autofocus") || hashMap.containsKey(field = (String)e.getValue().getValue())) continue;
                this.printMessage(Diagnostic.Kind.ERROR, viewName + ". " + "The field '" + field + "' is not declared in the view. Valid fields: " + this.fieldsToString(hashMap.keySet()), e.getKey());
            }
        }
        for (VariableElement variableElement : ElementFilter.fieldsIn(this.elementsUtil.getAllMembers(classDeclaration))) {
            void var11_21;
            List<? extends AnnotationMirror> annotationsMirror = variableElement.getAnnotationMirrors();
            AnnotationMirror viewField = null;
            boolean isGenerated = false;
            for (AnnotationMirror annotationMirror : annotationsMirror) {
                Element declaration = annotationMirror.getAnnotationType().asElement();
                if (declaration.toString().equals("com.guit.client.binder.ViewField")) {
                    viewField = annotationMirror;
                    continue;
                }
                if (!declaration.toString().equals("com.guit.client.apt.Generated")) continue;
                isGenerated = true;
            }
            if (viewField == null || isGenerated) continue;
            String fieldName = null;
            Boolean bl = false;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = viewField.getElementValues();
            for (Map.Entry entry : map.entrySet()) {
                String string = ((ExecutableElement)entry.getKey()).getSimpleName().toString();
                if (string.equals("name")) {
                    fieldName = (String)((AnnotationValue)entry.getValue()).getValue();
                }
                if (!((Object)((ExecutableElement)entry.getKey()).getSimpleName()).equals("provided")) continue;
                Boolean bl2 = (Boolean)((AnnotationValue)entry.getValue()).getValue();
            }
            ElementKind kind = variableElement.getKind();
            if (!var11_21.booleanValue() && kind.isClass()) {
                this.printMessage(Diagnostic.Kind.ERROR, viewName + ". " + "The type of a @ViewField must be an interface", variableElement);
            }
            if (fieldName == null) {
                fieldName = variableElement.getSimpleName().toString();
            }
            if (hashMap.containsKey(fieldName)) continue;
            this.printMessage(Diagnostic.Kind.ERROR, viewName + ". " + "The field '" + fieldName + "' is not declared in the view. Valid fields: " + this.fieldsToString(hashMap.keySet()), variableElement);
        }
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.elementsUtil.getAllMembers(classDeclaration));
        for (ExecutableElement m : methods) {
            void var11_25;
            List<? extends AnnotationMirror> annotationsMirror = m.getAnnotationMirrors();
            boolean isViewHandler = false;
            boolean hasViewFields = false;
            Object var11_24 = null;
            ExecutableElement eventTypeDeclaration = null;
            for (AnnotationMirror annotationMirror : annotationsMirror) {
                Element element = annotationMirror.getAnnotationType().asElement();
                if (!((TypeElement)element).getQualifiedName().toString().equals("com.guit.client.binder.ViewHandler")) continue;
                isViewHandler = true;
                Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                    String string = entry.getKey().getSimpleName().toString();
                    if (string.equals("event")) {
                        eventTypeDeclaration = entry.getKey();
                        Object value = entry.getValue().getValue();
                        TypeElement typeElement = (TypeElement)this.typeUtils.asElement((TypeMirror)value);
                        continue;
                    }
                    if (!string.equals("fields")) continue;
                    hasViewFields = true;
                    List viewFields = (List)entry.getValue().getValue();
                    for (AnnotationValue value : viewFields) {
                        String field = (String)value.getValue();
                        if (hashMap.containsKey(field)) continue;
                        this.printMessage(Diagnostic.Kind.ERROR, viewName + ". " + "The field '" + field + "' is not declared in the view. Valid fields: " + this.fieldsToString(hashMap.keySet()), m);
                    }
                }
            }
            if (!isViewHandler) continue;
            if (!hasViewFields) {
                ArrayList<String> fields = new ArrayList<String>(Arrays.asList(m.getSimpleName().toString().split("[$]")));
                int n = fields.size() - 1;
                String string = (String)fields.get(n);
                if (var11_25 != null && !"com.google.gwt.event.shared.GwtEvent".equals(var11_25.getQualifiedName())) {
                    String currentEventName;
                    String simpleName = var11_25.getSimpleName().toString();
                    if (!simpleName.endsWith("Event")) {
                        this.printMessage(Diagnostic.Kind.ERROR, viewName + ". " + "The event type does not match with the convention, it must end with 'Event'", eventTypeDeclaration);
                    }
                    if (!string.equals(currentEventName = this.eventClassNameToEventName(simpleName))) {
                        this.printMessage(Diagnostic.Kind.ERROR, viewName + ". " + "The method name must end with '" + currentEventName + "'", m);
                    }
                } else {
                    void var11_31;
                    void var11_29;
                    String currentPackage = this.elementsUtil.getPackageOf(classDeclaration).getQualifiedName().toString() + ".event.";
                    String eventClassName = this.eventNameToEventClassName(string);
                    TypeElement typeElement = this.elementsUtil.getTypeElement(this.domPackage + eventClassName);
                    if (typeElement == null) {
                        TypeElement typeElement2 = this.elementsUtil.getTypeElement(this.sharedPackage + eventClassName);
                    }
                    if (var11_29 == null) {
                        TypeElement typeElement3 = this.elementsUtil.getTypeElement(currentPackage + eventClassName);
                    }
                    if (var11_31 == null) {
                        this.printMessage(Diagnostic.Kind.WARNING, "The event cannot be found. Do you see any typo in the name? '" + string + "'. i.e: ClickEvent -> click", m);
                    }
                }
                fields.remove(n);
                for (String part : fields) {
                    if (hashMap.containsKey(part)) continue;
                    this.printMessage(Diagnostic.Kind.ERROR, viewName + ". " + "The field '" + part + "' is not declared in the view. Valid fields: " + this.fieldsToString(hashMap.keySet()), m);
                    break;
                }
            } else if (var11_25 == null) {
                this.printMessage(Diagnostic.Kind.ERROR, viewName + ". " + "When using the @ViewFields annotation you need to specify the event type on the @ViewHandler annotation", m);
            }
            List<? extends VariableElement> parameters = m.getParameters();
            for (VariableElement variableElement : parameters) {
                boolean isAttribute = false;
                List<? extends AnnotationMirror> parameterAnnotations = variableElement.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : parameterAnnotations) {
                    if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals("com.guit.client.binder.Attribute")) continue;
                    isAttribute = true;
                    break;
                }
                if (!isAttribute || !variableElement.asType().getKind().isPrimitive()) continue;
                this.printMessage(Diagnostic.Kind.ERROR, viewName + ". " + "@Attribute parameters cannot be of a primitive type. The type must implement valueOf(String value)", variableElement);
            }
        }
    }

    private void processController(TypeElement classDeclaration) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.elementsUtil.getAllMembers(classDeclaration));
        for (ExecutableElement m : methods) {
            String currentEventName;
            List<? extends AnnotationMirror> annotationsMirror = m.getAnnotationMirrors();
            TypeElement eventType = null;
            ExecutableElement eventTypeDeclaration = null;
            boolean isEventBusHandler = false;
            for (AnnotationMirror annotationMirror : annotationsMirror) {
                Element declaration = annotationMirror.getAnnotationType().asElement();
                if (declaration == null || !((TypeElement)declaration).getQualifiedName().toString().equals("com.guit.client.binder.EventBusHandler")) continue;
                isEventBusHandler = true;
                Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                    eventTypeDeclaration = entry.getKey();
                    try {
                        Object value = entry.getValue().getValue();
                        eventType = (TypeElement)this.typeUtils.asElement((TypeMirror)value);
                    }
                    catch (ClassCastException e) {}
                }
            }
            if (!isEventBusHandler) continue;
            ArrayList<String> fields = new ArrayList<String>(Arrays.asList(m.getSimpleName().toString().split("[$]")));
            if (fields.size() != 2 || !((String)fields.get(0)).equals("eventBus") && !((String)fields.get(0)).isEmpty()) {
                this.printMessage(Diagnostic.Kind.ERROR, "The method name must be 'eventBus${eventname}' or '${eventname}'", m);
                continue;
            }
            String string = (String)fields.get(1);
            if (eventType == null || "com.google.gwt.event.shared.GwtEvent".equals(eventType.getQualifiedName())) continue;
            String simpleName = eventType.getSimpleName().toString();
            if (!simpleName.endsWith("Event")) {
                this.printMessage(Diagnostic.Kind.ERROR, "The event type does not match with the convention, it must end with 'Event'", eventTypeDeclaration);
            }
            if (!string.equals(currentEventName = this.eventClassNameToEventName(simpleName))) {
                this.printMessage(Diagnostic.Kind.ERROR, "The method name must end with '" + currentEventName + "'", m);
            }
            List<? extends VariableElement> parameters = m.getParameters();
            for (VariableElement variableElement : parameters) {
                List<? extends AnnotationMirror> parameterAnnotations = variableElement.getAnnotationMirrors();
                boolean hasAttribute = false;
                for (AnnotationMirror annotationMirror : parameterAnnotations) {
                    if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals("com.guit.client.binder.Attribute")) continue;
                    hasAttribute = true;
                    break;
                }
                if (hasAttribute) {
                    this.printMessage(Diagnostic.Kind.ERROR, "@Attribute parameters are not allowed in EventBusHandler methods", variableElement);
                    continue;
                }
                String name = variableElement.getSimpleName().toString();
                String[] stringArray = name.split("[$]");
                HashMap<String, ExecutableElement> validFields = this.getValidFields(eventType);
                StringBuilder sb = new StringBuilder();
                for (String part : stringArray) {
                    if (sb.length() > 0) {
                        sb.append(".");
                    }
                    if (!validFields.keySet().contains(part)) {
                        this.printMessage(Diagnostic.Kind.ERROR, "The event '" + eventType.getQualifiedName() + "' does not have a getter method for '" + sb.toString() + part + "'. Valid fields: " + validFields.keySet().toString(), variableElement);
                        continue;
                    }
                    TypeMirror retType = validFields.get(part).getReturnType();
                    validFields = this.getValidFields((TypeElement)this.typeUtils.asElement(retType));
                    sb.append(part);
                }
            }
        }
    }

    private void processContainerMethod(TypeElement d, ExecutableElement m) {
        String containerName = null;
        List<? extends AnnotationMirror> mirrors = m.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(GwtDisplay.class.getCanonicalName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                containerName = (String)entry.getValue().getValue();
            }
        }
        if (containerName == null) {
            return;
        }
        String name = containerName;
        String string = this.elementsUtil.getPackageOf(d).getQualifiedName().toString();
        String qualifiedName = string + "." + name;
        PrintWriter writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + string + ";");
        writer.println();
        writer.println("import java.lang.annotation.Documented;");
        writer.println("import java.lang.annotation.Retention;");
        writer.println("import java.lang.annotation.RetentionPolicy;");
        writer.println();
        writer.println("import com.google.inject.BindingAnnotation;");
        Generated.printGeneratedImport(writer);
        writer.println();
        writer.println("@BindingAnnotation");
        writer.println("@Retention(RetentionPolicy.RUNTIME)");
        writer.println("@Documented");
        writer.println();
        Generated.printGenerated(writer, d.getSimpleName().toString());
        writer.println("public @interface " + name + "{");
        writer.println("}");
        writer.close();
        name = containerName + "Provider";
        qualifiedName = string + "." + name;
        writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + string + ";");
        writer.println();
        writer.println("import com.google.gwt.user.client.ui.AcceptsOneWidget;");
        writer.println("import com.google.gwt.user.client.ui.IsWidget;");
        writer.println("import com.google.inject.Inject;");
        writer.println("import com.google.inject.Provider;");
        writer.println("import com.google.inject.Singleton;");
        Generated.printGeneratedImport(writer);
        writer.println();
        writer.println("@Singleton");
        Generated.printGenerated(writer, d.getSimpleName().toString());
        writer.println("public class " + name + " implements Provider<AcceptsOneWidget>, AcceptsOneWidget {");
        writer.println();
        writer.println("  @Inject");
        writer.println("  " + d.getQualifiedName() + " owner;");
        writer.println();
        writer.println("  @Override");
        writer.println("  public void setWidget(IsWidget w) {");
        writer.println("    owner." + m.getSimpleName() + "(w);");
        writer.println("  }");
        writer.println();
        writer.println("  @Override");
        writer.println("  public AcceptsOneWidget get() {");
        writer.println("    return this;");
        writer.println("  }");
        writer.println("}");
        writer.close();
        name = containerName + "Module";
        qualifiedName = string + "." + name;
        writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + string + ";");
        writer.println();
        writer.println("import com.google.gwt.inject.client.AbstractGinModule;");
        writer.println("import com.google.gwt.user.client.ui.AcceptsOneWidget;");
        Generated.printGeneratedImport(writer);
        writer.println();
        Generated.printGenerated(writer, d.getSimpleName().toString());
        writer.println("public class " + name + " extends AbstractGinModule {");
        writer.println();
        writer.println("  @Override");
        writer.println("  protected void configure() {");
        writer.println("    bind(AcceptsOneWidget.class).annotatedWith(" + containerName + ".class).toProvider(" + containerName + "Provider.class);");
        writer.println("  }");
        writer.println("}");
        writer.close();
    }

    public PrintWriter getPrintWriter(String qualifiedName) {
        try {
            JavaFileObject createSourceFile = this.filer.createSourceFile(qualifiedName, new Element[0]);
            return new PrintWriter(createSourceFile.openWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        element2dom.put("frameset", "com.google.gwt.dom.client.FrameSetElement");
        element2dom.put("canvas", "com.google.gwt.dom.client.CanvasElement");
        element2dom.put("tr", "com.google.gwt.dom.client.TableRowElement");
        element2dom.put("textarea", "com.google.gwt.dom.client.TextAreaElement");
        element2dom.put("area", "com.google.gwt.dom.client.AreaElement");
        element2dom.put("select", "com.google.gwt.dom.client.SelectElement");
        element2dom.put("td", "com.google.gwt.dom.client.TableCellElement");
        element2dom.put("th", "com.google.gwt.dom.client.TableCellElement");
        element2dom.put("source", "com.google.gwt.dom.client.SourceElement");
        element2dom.put("label", "com.google.gwt.dom.client.LabelElement");
        element2dom.put("param", "com.google.gwt.dom.client.ParamElement");
        element2dom.put("ol", "com.google.gwt.dom.client.OListElement");
        element2dom.put("optgroup", "com.google.gwt.dom.client.OptGroupElement");
        element2dom.put("title", "com.google.gwt.dom.client.TitleElement");
        element2dom.put("span", "com.google.gwt.dom.client.SpanElement");
        element2dom.put("script", "com.google.gwt.dom.client.ScriptElement");
        element2dom.put("video", "com.google.gwt.dom.client.VideoElement");
        element2dom.put("audio", "com.google.gwt.dom.client.AudioElement");
        element2dom.put("form", "com.google.gwt.dom.client.FormElement");
        element2dom.put("ins", "com.google.gwt.dom.client.ModElement");
        element2dom.put("del", "com.google.gwt.dom.client.ModElement");
        element2dom.put("dl", "com.google.gwt.dom.client.DListElement");
        element2dom.put("map", "com.google.gwt.dom.client.MapElement");
        element2dom.put("base", "com.google.gwt.dom.client.BaseElement");
        element2dom.put("tbody", "com.google.gwt.dom.client.TableSectionElement");
        element2dom.put("tfoot", "com.google.gwt.dom.client.TableSectionElement");
        element2dom.put("thead", "com.google.gwt.dom.client.TableSectionElement");
        element2dom.put("pre", "com.google.gwt.dom.client.PreElement");
        element2dom.put("ul", "com.google.gwt.dom.client.UListElement");
        element2dom.put("img", "com.google.gwt.dom.client.ImageElement");
        element2dom.put("a", "com.google.gwt.dom.client.AnchorElement");
        element2dom.put("option", "com.google.gwt.dom.client.OptionElement");
        element2dom.put("button", "com.google.gwt.dom.client.ButtonElement");
        element2dom.put("object", "com.google.gwt.dom.client.ObjectElement");
        element2dom.put("legend", "com.google.gwt.dom.client.LegendElement");
        element2dom.put("body", "com.google.gwt.dom.client.BodyElement");
        element2dom.put("br", "com.google.gwt.dom.client.BRElement");
        element2dom.put("li", "com.google.gwt.dom.client.LIElement");
        element2dom.put("link", "com.google.gwt.dom.client.LinkElement");
        element2dom.put("iframe", "com.google.gwt.dom.client.IFrameElement");
        element2dom.put("table", "com.google.gwt.dom.client.TableElement");
        element2dom.put("frame", "com.google.gwt.dom.client.FrameElement");
        element2dom.put("p", "com.google.gwt.dom.client.ParagraphElement");
        element2dom.put("head", "com.google.gwt.dom.client.HeadElement");
        element2dom.put("col", "com.google.gwt.dom.client.TableColElement");
        element2dom.put("colgroup", "com.google.gwt.dom.client.TableColElement");
        element2dom.put("blockquote", "com.google.gwt.dom.client.QuoteElement");
        element2dom.put("q", "com.google.gwt.dom.client.QuoteElement");
        element2dom.put("caption", "com.google.gwt.dom.client.TableCaptionElement");
        element2dom.put("style", "com.google.gwt.dom.client.StyleElement");
        element2dom.put("input", "com.google.gwt.dom.client.InputElement");
        element2dom.put("h1", "com.google.gwt.dom.client.HeadingElement");
        element2dom.put("h2", "com.google.gwt.dom.client.HeadingElement");
        element2dom.put("h3", "com.google.gwt.dom.client.HeadingElement");
        element2dom.put("h4", "com.google.gwt.dom.client.HeadingElement");
        element2dom.put("h5", "com.google.gwt.dom.client.HeadingElement");
        element2dom.put("h6", "com.google.gwt.dom.client.HeadingElement");
        element2dom.put("div", "com.google.gwt.dom.client.DivElement");
        element2dom.put("meta", "com.google.gwt.dom.client.MetaElement");
        element2dom.put("fieldset", "com.google.gwt.dom.client.FieldSetElement");
        element2dom.put("hr", "com.google.gwt.dom.client.HRElement");
    }
}

