/*
 * Decompiled with CFR 0.152.
 */
package guitplugin.guitview;

import guitplugin.guitview.GwtResourceEntityResolver;
import guitplugin.guitview.LazyDocument;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.StandardLocation;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class W3cDomHelper {
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public W3cDomHelper() {
        this.factory.setNamespaceAware(true);
        this.factory.setExpandEntityReferences(true);
    }

    DocumentBuilder getBuilder() {
        DocumentBuilder builder;
        try {
            builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        builder.setEntityResolver(new GwtResourceEntityResolver());
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }
        });
        return builder;
    }

    public ArrayList<LazyDocument> documentFor(Filer filer, TypeElement classDeclaration) throws SAXParseException {
        String viewName = classDeclaration.getSimpleName() + ".ui.xml";
        List<? extends AnnotationMirror> mirrors = classDeclaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals("com.guit.client.ViewTemplate")) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            Iterator<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> i$ = values.entrySet().iterator();
            if (!i$.hasNext()) break;
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry = i$.next();
            viewName = (String)entry.getValue().getValue();
            break;
        }
        String basePackage = classDeclaration.getQualifiedName().toString();
        basePackage = basePackage.substring(0, basePackage.lastIndexOf("."));
        ArrayList<LazyDocument> arrayList = new ArrayList<LazyDocument>();
        this.locateFile(filer, basePackage, viewName, arrayList);
        if (arrayList.size() == 0) {
            throw new RuntimeException("The view '" + classDeclaration.getQualifiedName() + ".ui.xml' was not found");
        }
        return arrayList;
    }

    public void locateFile(Filer filer, String pkg, final String file, ArrayList<LazyDocument> documents) {
        try {
            InputStream openInputStream = null;
            try {
                openInputStream = filer.getResource(StandardLocation.CLASS_OUTPUT, pkg + ".view", file).openInputStream();
            }
            catch (Exception e) {
                openInputStream = filer.getResource(StandardLocation.SOURCE_PATH, pkg + ".view", file).openInputStream();
            }
            final Document document = this.getBuilder().parse(openInputStream);
            documents.add(new LazyDocument(){

                @Override
                public Document get() {
                    return document;
                }

                @Override
                public String getFileName() {
                    return file;
                }
            });
            return;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("View file not found for " + pkg + ".view." + file, e);
        }
        catch (SAXException e) {
            throw new RuntimeException("XML error found in " + pkg + ".view." + file, e);
        }
        catch (Exception e) {
            throw new RuntimeException(pkg + ".view." + file, e);
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }
}

