/*
 * Decompiled with CFR 0.152.
 */
package guitplugin.guitview;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

class GwtResourceEntityResolver
implements EntityResolver {
    private static final Set<String> EXTERNAL_PREFIXES = new HashSet<String>();
    private static final String RESOURCES = "guitplugin/guitview/resources/";
    HashMap<String, InputSource> cache = new HashMap();

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        String matchingPrefix = this.findMatchingPrefix(systemId);
        if (matchingPrefix == null) {
            return null;
        }
        systemId = systemId.substring(matchingPrefix.length());
        String path = RESOURCES + systemId;
        return this.find(publicId, path);
    }

    private InputSource find(String publicId, String path) {
        String key = publicId + "_" + path;
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(path);
        if (stream != null) {
            InputSource inputSource = new InputSource(new InputStreamReader(stream));
            inputSource.setPublicId(publicId);
            inputSource.setSystemId(path);
            this.cache.put(key, inputSource);
            return inputSource;
        }
        this.cache.put(key, null);
        return null;
    }

    private String findMatchingPrefix(String systemId) {
        for (String prefix : EXTERNAL_PREFIXES) {
            if (!systemId.startsWith(prefix)) continue;
            return prefix;
        }
        return null;
    }

    static {
        EXTERNAL_PREFIXES.add("http://google-web-toolkit.googlecode.com/files/");
        EXTERNAL_PREFIXES.add("http://dl.google.com/gwt/DTD/");
        EXTERNAL_PREFIXES.add("https://dl-ssl.google.com/gwt/DTD/");
    }
}

