(ns leiningen.serverless
  (:require leiningen.core.main))

(defmulti serverless
  "Perform a Serverless (sls) action."
  {:arglists '([project subtask & args])}
  (fn [_ subtask & _] subtask))

(defmethod serverless "deploy"
  [{:keys [version]} _ & args]
  (let [[_ [_ & sls-args]] (split-with (partial not= "--") args)
        _ (println (format "args: %s sls-args: %s" args (into [] sls-args)))
        pb (.inheritIO (ProcessBuilder. (concat ["sls" "deploy"] sls-args)))
        _ (.putIfAbsent (.environment pb) "LEIN_SERVERLESS_VERSION" version)
        exit-code (-> pb .start .waitFor)]
    (when-not (zero? exit-code)
      (->> exit-code
           (format "Serverless process exited with status %s.")
           leiningen.core.main/abort))))

(def sls serverless)
(alter-meta! #'sls merge (-> #'serverless meta (select-keys [:arglists])))
