(ns genesis.providers.aws.s3
  (:require [amazonica.aws.s3 :as s3]
            [clojure.core.strint :refer [<<]]
            [clojure.java.shell :as sh]
            [clojure.spec.alpha :as s]
            [genesis.core :as g :refer [defresource]]
            [genesis.specs :as gs]
            [genesis.util :refer [validate!]]))

(defn list-buckets [context]
  (->> (s3/list-buckets (-> context :aws :creds))
       (map (fn [b]
              {:resource :s3/bucket
               :identity (:name b)
               :properties b}))))

(defn get-bucket [creds identity]
  (->> (list-buckets creds)
       (filter (fn [b]
                 (= identity (:identity b))))
       first))

(s/def ::name string?)
(s/def ::bucket (s/keys :req-un [::bucket-name]))

(defn create-bucket [context bucket]
  (validate! ::bucket bucket)
  (let [created (s3/create-bucket (-> context :aws :creds) (:bucket-name bucket))]
    {:identity (:name created)
     :properties {:bucket-name (:name bucket)}}))

(s/fdef delete-bucket :args (s/cat :c ::gs/context :identity ::gs/identity))
(defn delete-bucket [context identity]
  (validate! ::gs/identity identity)
  (println "cowardly refusing to delete s3 bucket" identity)
  nil
  ;; (s3/delete-bucket (-> context :aws :creds) identity)
  )

(defresource :s3/bucket
  {:list list-buckets
   :get get-bucket
   :create create-bucket
   :delete delete-bucket})
