(ns genesis.providers.aws
  (:require [clojure.spec.alpha :as s]
            [cognitect.aws.client.api :as aws]
            [cognitect.aws.credentials :as credentials]
            [genesis.specs :as gs]
            [genesis.util :refer [instrument-ns]]))

(defn assert-success! [response]
  (if (-> response :cognitect.anomalies/category)
    (throw (ex-info "aws api request failed" response))
    response))

(defn invoke!
  [& args]
  (-> (apply aws/invoke args)
      (assert-success!)))

(s/fdef client :args (s/cat :cc ::gs/context :api keyword?))
(defn client [context api]
  (aws/client {:api api
               :credentials-provider (credentials/basic-credentials-provider (-> context :aws :creds))
               :region (-> context :aws :region)}))

(instrument-ns)
