(ns genesis.exercise
  (:require [clojure.spec.alpha :as s]
            [clojure.spec.gen.alpha :as gen]
            [genesis.core :as g]
            [genesis.resource :as resource]
            [genesis.util :refer [validate!]]))

(defn test-resource
  "Test that a resource obeys the contract. Will create,list,get,delete a dummy instance of resource"
  [context resource]
  (let [r (g/get-resource resource)]
    (assert r)
    (assert (:create-spec r) "can't test resource w/out :create-spec")
    (let [spec (s/spec (:create-spec r))
          properties (first (gen/sample (s/gen spec) 1))
          identity (str (gensym "exercise-test"))
          i (resource/create creds identity properties)]
      (let [is ((:list r) creds)]
        (validate! ::g/instances is)
        (assert (some (fn [x]
                        (= identity
                           (:identity x))) is)))
      (let [x ((:get r) creds (:identity i))]
        (assert x))
      ((:delete r) creds identity nil)
      (let [is ((:list r) creds)]
        (validate! ::g/instances is)
        (assert (not (some (fn [x]
                             (= identity
                                (:identity x))) is))))
      (let [x ((:get r) creds (:identity i))]
        (assert (not x))))))
