/*
 * Decompiled with CFR 0.152.
 */
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Flows.ToTokenize;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.In;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Vector;

public class wordInd
extends SystemOption {
    private static final String NO_OUTPUT_STR = "-No Output-";
    private static boolean runFlag_ = true;
    private static boolean noOutputFlag_ = false;
    private static boolean promptFlag_ = false;
    private static boolean reserveCaseFlag_ = false;
    private static String separator_ = GlobalBehavior.GetFieldSeparator();
    private static BufferedReader inReader_ = null;
    private static BufferedWriter outWriter_ = null;
    private static boolean fileOutput_ = false;
    private static int termFieldNum_ = 1;
    private static Vector<Integer> outputFieldList_ = new Vector();
    private static String outputTerm_ = new String();
    private static String promptStr_ = null;

    public static void main(String[] args) {
        wordInd wordInd2;
        String optionStr = "";
        Option io = new Option(optionStr);
        if (args.length > 0) {
            optionStr = "";
            for (int i = 0; i < args.length; ++i) {
                optionStr = i == 0 ? args[i] : optionStr + " " + args[i];
            }
            io = new Option(optionStr);
        }
        if (SystemOption.CheckSyntax(io, (wordInd2 = new wordInd()).GetOption(), false, true)) {
            wordInd2.ExecuteCommands(io, wordInd2.GetOption());
            if (runFlag_) {
                wordInd2.GetVariants();
            }
        } else {
            WordIndHelp.WordIndHelp(outWriter_, fileOutput_);
        }
        try {
            wordInd.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void GetVariants() {
        if (inReader_ == null) {
            try {
                inReader_ = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            catch (IOException e) {
                System.err.println("**Error: problem of reading std-in");
            }
        }
        try {
            do {
                if (!promptFlag_) continue;
                wordInd.GetPrompt();
            } while (wordInd.LineHandler(inReader_.readLine()));
            wordInd.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void ExecuteCommand(OptionItem optionItem, Option systemOption) {
        OptionItem nameItem = OptionUtility.GetItemByName(optionItem, systemOption, false);
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        if (wordInd.CheckOption(nameItem, "-c")) {
            reserveCaseFlag_ = true;
        } else if (wordInd.CheckOption(nameItem, "-F:INT")) {
            Integer fieldNum = new Integer(nameItem.GetOptionArgument());
            outputFieldList_.addElement(fieldNum);
        } else if (wordInd.CheckOption(nameItem, "-h")) {
            WordIndHelp.WordIndHelp(outWriter_, fileOutput_);
            runFlag_ = false;
        } else if (wordInd.CheckOption(nameItem, "-hs")) {
            systemOption.PrintOptionHierachy();
            runFlag_ = false;
        } else if (wordInd.CheckOption(nameItem, "-i:STR")) {
            String inFile = nameItem.GetOptionArgument();
            if (inFile != null) {
                try {
                    inReader_ = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                }
                catch (IOException e) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + inFile);
                }
            }
        } else if (wordInd.CheckOption(nameItem, "-n")) {
            noOutputFlag_ = true;
        } else if (wordInd.CheckOption(nameItem, "-o:STR")) {
            String outFile = nameItem.GetOptionArgument();
            if (outFile != null) {
                try {
                    outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    fileOutput_ = true;
                }
                catch (IOException e) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + outFile);
                }
            }
        } else if (wordInd.CheckOption(nameItem, "-p")) {
            promptFlag_ = true;
        } else if (wordInd.CheckOption(nameItem, "-s:STR")) {
            separator_ = nameItem.GetOptionArgument();
            if (separator_.equals("\\t")) {
                separator_ = new Character('\t').toString();
            }
        } else if (wordInd.CheckOption(nameItem, "-t:INT")) {
            termFieldNum_ = Integer.parseInt(nameItem.GetOptionArgument());
        } else if (wordInd.CheckOption(nameItem, "-v")) {
            try {
                String releaseStr = "wordInd.2013";
                Out.Println(outWriter_, releaseStr, fileOutput_, false);
            }
            catch (IOException e) {
                // empty catch block
            }
            runFlag_ = false;
        }
    }

    @Override
    protected void DefineFlag() {
        String flagStr = "-c -F:INT -h -hs -i:STR -n -o:STR -p -s:STR -t:INT -v";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-c", "Reserve_Cases");
        this.systemOption_.SetFlagFullName("-F", "Copy_Field_To_Outputs");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-n", "No_Output");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-s", "Field_Separator");
        this.systemOption_.SetFlagFullName("-t", "Term_Field");
        this.systemOption_.SetFlagFullName("-v", "Version");
    }

    private static void Close() throws IOException, SQLException {
        if (outWriter_ != null) {
            outWriter_.close();
        }
        if (inReader_ != null) {
            inReader_.close();
        }
    }

    private static void GetPrompt() throws IOException {
        Out.Println(outWriter_, promptStr_, fileOutput_, false);
    }

    private static boolean LineHandler(String line) throws SQLException, IOException {
        LexItem in;
        Vector<LexItem> result;
        if (line == null) {
            return false;
        }
        String inTerm = In.GetField(line, separator_, termFieldNum_);
        outputTerm_ = In.GetOutTerm(line, separator_, outputFieldList_);
        if (!reserveCaseFlag_) {
            inTerm = inTerm.toLowerCase();
        }
        if ((result = ToTokenize.Mutate(in = new LexItem(inTerm), false, false)).size() == 0) {
            if (noOutputFlag_) {
                Out.Println(outWriter_, outputTerm_ + NO_OUTPUT_STR, fileOutput_, false);
            }
        } else {
            for (int i = 0; i < result.size(); ++i) {
                LexItem temp = result.elementAt(i);
                Out.Println(outWriter_, outputTerm_ + temp.GetTargetTerm(), fileOutput_, false);
            }
        }
        return true;
    }

    static {
        promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
        try {
            outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (IOException e) {
            System.err.println("**Error: problem of opening Std-out.");
        }
    }
}

