/*
 * Decompiled with CFR 0.152.
 */
import gov.nih.nlm.nls.lvg.Api.ToAsciiApi;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class toAscii
extends SystemOption {
    private static ToAsciiApi toAsciiApi_ = null;
    private static final String NO_OUTPUT_STR = "-No Output-";
    private static String noOutputStr_ = "-No Output-";
    private static boolean detailsFlag_ = false;
    private static boolean runFlag_ = true;
    private static boolean noOutputFlag_ = false;
    private static boolean promptFlag_ = false;
    private static boolean preserveIoFlag_ = false;
    private static BufferedReader inReader_ = null;
    private static BufferedWriter outWriter_ = null;
    private static boolean fileOutput_ = false;
    private static String configFile_ = null;
    private static String promptStr_ = null;
    private static Configuration conf_ = null;

    public static void main(String[] args) {
        toAscii toAscii2;
        String optionStr = "";
        Option io = new Option(optionStr);
        if (args.length > 0) {
            optionStr = "";
            for (int i = 0; i < args.length; ++i) {
                optionStr = i == 0 ? args[i] : optionStr + " " + args[i];
            }
            io = new Option(optionStr);
        }
        if (SystemOption.CheckSyntax(io, (toAscii2 = new toAscii()).GetOption(), false, true)) {
            toAscii2.ExecuteCommands(io, toAscii2.GetOption());
            boolean useClassPath = false;
            if (configFile_ == null) {
                useClassPath = true;
                configFile_ = "data.config.lvg";
            }
            if (conf_ == null) {
                conf_ = new Configuration(configFile_, useClassPath);
            }
            promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
            if (conf_.GetSize() <= 0) {
                runFlag_ = false;
            } else {
                toAsciiApi_ = new ToAsciiApi(conf_);
                if (conf_.GetConfiguration("NO_OUTPUT") != null) {
                    noOutputStr_ = conf_.GetConfiguration("NO_OUTPUT");
                }
                if (!conf_.GetConfiguration("LVG_PROMPT").equals("DEFAULT")) {
                    promptStr_ = conf_.GetConfiguration("LVG_PROMPT");
                }
                if (runFlag_) {
                    toAscii2.GetVariants();
                }
            }
        } else {
            ToAsciiHelp.ToAsciiHelp(outWriter_, fileOutput_);
        }
        try {
            toAscii.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void GetVariants() {
        if (inReader_ == null) {
            try {
                inReader_ = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            catch (IOException e) {
                System.err.println("**Error: problem of reading std-in");
            }
        }
        try {
            do {
                if (!promptFlag_) continue;
                toAscii.GetPrompt();
            } while (toAscii.LineHandler(inReader_.readLine()));
            toAscii.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void ExecuteCommand(OptionItem optionItem, Option systemOption) {
        OptionItem nameItem = OptionUtility.GetItemByName(optionItem, systemOption, false);
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        if (toAscii.CheckOption(nameItem, "-ci")) {
            try {
                Configuration conf;
                boolean useClassPath = false;
                String configFile = configFile_;
                if (configFile == null) {
                    useClassPath = true;
                    configFile = "data.config.lvg";
                }
                if ((conf = conf_) == null) {
                    conf = new Configuration(configFile, useClassPath);
                }
                Out.Println(outWriter_, conf.GetInformation(), fileOutput_, false);
            }
            catch (IOException e) {
                // empty catch block
            }
            runFlag_ = false;
        } else if (toAscii.CheckOption(nameItem, "-d")) {
            detailsFlag_ = true;
        } else if (toAscii.CheckOption(nameItem, "-h")) {
            ToAsciiHelp.ToAsciiHelp(outWriter_, fileOutput_);
            runFlag_ = false;
        } else if (toAscii.CheckOption(nameItem, "-hs")) {
            systemOption.PrintOptionHierachy();
            runFlag_ = false;
        } else if (toAscii.CheckOption(nameItem, "-i:STR")) {
            String inFile = nameItem.GetOptionArgument();
            if (inFile != null) {
                try {
                    inReader_ = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                }
                catch (IOException e) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + inFile);
                }
            }
        } else if (toAscii.CheckOption(nameItem, "-n")) {
            noOutputFlag_ = true;
        } else if (toAscii.CheckOption(nameItem, "-o:STR")) {
            String outFile = nameItem.GetOptionArgument();
            if (outFile != null) {
                try {
                    outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    fileOutput_ = true;
                }
                catch (IOException e) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + outFile);
                }
            }
        } else if (toAscii.CheckOption(nameItem, "-p")) {
            promptFlag_ = true;
        } else if (toAscii.CheckOption(nameItem, "-pio")) {
            preserveIoFlag_ = true;
        } else if (toAscii.CheckOption(nameItem, "-v")) {
            try {
                String releaseStr = "toAscii.2013";
                Out.Println(outWriter_, releaseStr, fileOutput_, false);
            }
            catch (IOException e) {
                // empty catch block
            }
            runFlag_ = false;
        } else if (toAscii.CheckOption(nameItem, "-x:STR")) {
            configFile_ = nameItem.GetOptionArgument();
        }
    }

    @Override
    protected void DefineFlag() {
        String flagStr = "-ci -d -h -hs -i:STR -n -o:STR -p -pio -v -x:STR";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-ci", "Print_Config_Info");
        this.systemOption_.SetFlagFullName("-d", "Print_Operation_Details");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-n", "No_Output");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-pio", "Preserve_IO");
        this.systemOption_.SetFlagFullName("-v", "Version");
        this.systemOption_.SetFlagFullName("-x", "Load_Configuration_file");
    }

    private static void Close() throws IOException {
        if (outWriter_ != null) {
            outWriter_.close();
        }
        if (inReader_ != null) {
            inReader_.close();
        }
    }

    private static void GetPrompt() throws IOException {
        Out.Println(outWriter_, promptStr_, fileOutput_, false);
    }

    private static boolean LineHandler(String line) throws IOException {
        if (line == null) {
            return false;
        }
        LexItem in = new LexItem(line);
        LexItem out = toAsciiApi_.Mutate(in, detailsFlag_);
        if (noOutputFlag_ && out.GetTargetTerm().length() == 0) {
            if (preserveIoFlag_) {
                Out.Println(outWriter_, "Input: " + line, fileOutput_, false);
                Out.Println(outWriter_, "Ascii: " + noOutputStr_, fileOutput_, false);
            } else {
                Out.Println(outWriter_, noOutputStr_, fileOutput_, false);
            }
        } else {
            if (preserveIoFlag_) {
                Out.Println(outWriter_, "Input: " + line, fileOutput_, false);
                Out.Println(outWriter_, "Ascii: " + out.GetTargetTerm(), fileOutput_, false);
            } else {
                Out.Println(outWriter_, out.GetTargetTerm(), fileOutput_, false);
            }
            if (detailsFlag_) {
                Out.Println(outWriter_, out.GetDetailInformation(), fileOutput_, false);
            }
        }
        return true;
    }

    static {
        try {
            outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (IOException e) {
            System.err.println("**Error: problem of opening Std-out.");
        }
    }
}

