/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.server.HsqlSocketFactory;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.TimestampData;

public class ClientConnection
implements SessionInterface {
    public static final String NETWORK_COMPATIBILITY_VERSION = "2.1.0.0";
    public static final int NETWORK_COMPATIBILITY_VERSION_INT = -2010000;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    private boolean isClosed;
    private Socket socket;
    protected DataOutputStream dataOutput;
    protected DataInputStream dataInput;
    protected RowOutputInterface rowOut;
    protected RowInputBinary rowIn;
    private Result resultOut;
    private long sessionID;
    private long lobIDSequence = -1L;
    private boolean isReadOnlyDefault = false;
    private boolean isAutoCommit = true;
    private int zoneSeconds;
    private Scanner scanner;
    private String zoneString;
    private Calendar calendar;
    JDBCConnection connection;
    String host;
    int port;
    String path;
    String database;
    boolean isTLS;
    int databaseID;
    String clientPropertiesString;
    HsqlProperties clientProperties;
    String databaseUniqueName;

    public ClientConnection(String string, int n, String string2, String string3, boolean bl, String string4, String string5, int n2) {
        this.host = string;
        this.port = n;
        this.path = string2;
        this.database = string3;
        this.isTLS = bl;
        this.zoneSeconds = n2;
        this.zoneString = TimeZone.getDefault().getID();
        this.initStructures();
        Result result = Result.newConnectionAttemptRequest(string4, string5, string3, this.zoneString, n2);
        this.initConnection(string, n, bl);
        Result result2 = this.execute(result);
        if (result2.isError()) {
            throw Error.error(result2);
        }
        this.sessionID = result2.getSessionId();
        this.databaseID = result2.getDatabaseId();
        this.databaseUniqueName = result2.getDatabaseName();
        this.clientPropertiesString = result2.getMainString();
    }

    private void initStructures() {
        RowOutputBinary rowOutputBinary = new RowOutputBinary(this.mainBuffer);
        this.rowOut = rowOutputBinary;
        this.rowIn = new RowInputBinary(rowOutputBinary);
        this.resultOut = Result.newSessionAttributesResult();
    }

    protected void initConnection(String string, int n, boolean bl) {
        this.openConnection(string, n, bl);
    }

    protected void openConnection(String string, int n, boolean bl) {
        try {
            this.socket = HsqlSocketFactory.getInstance(bl).createSocket(string, n);
            this.socket.setTcpNoDelay(true);
            this.dataOutput = new DataOutputStream(this.socket.getOutputStream());
            this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.handshake();
        }
        catch (Exception exception) {
            throw new HsqlException(exception, Error.getStateString(1301), -1301);
        }
    }

    protected void closeConnection() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    public synchronized Result execute(Result result) {
        try {
            result.setSessionId(this.sessionID);
            result.setDatabaseId(this.databaseID);
            this.write(result);
            return this.read();
        }
        catch (Throwable throwable) {
            throw Error.error(1305, throwable.toString());
        }
    }

    @Override
    public synchronized RowSetNavigatorClient getRows(long l, int n, int n2) {
        try {
            this.resultOut.setResultType(13);
            this.resultOut.setResultId(l);
            this.resultOut.setUpdateCount(n);
            this.resultOut.setFetchSize(n2);
            Result result = this.execute(this.resultOut);
            return (RowSetNavigatorClient)result.getNavigator();
        }
        catch (Throwable throwable) {
            throw Error.error(1305, throwable.toString());
        }
    }

    @Override
    public synchronized void closeNavigator(long l) {
        try {
            this.resultOut.setResultType(40);
            this.resultOut.setResultId(l);
            this.execute(this.resultOut);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.resultOut.setResultType(32);
            this.execute(this.resultOut);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized Object getAttribute(int n) {
        this.resultOut.setResultType(7);
        this.resultOut.setStatementType(n);
        Result result = this.execute(this.resultOut);
        if (result.isError()) {
            throw Error.error(result);
        }
        Object[] objectArray = result.getSingleRowData();
        switch (n) {
            case 1: {
                return objectArray[2];
            }
            case 2: {
                return objectArray[2];
            }
            case 0: {
                return objectArray[1];
            }
            case 3: {
                return objectArray[3];
            }
        }
        return null;
    }

    @Override
    public synchronized void setAttribute(int n, Object object) {
        this.resultOut.setResultType(6);
        Object[] objectArray = this.resultOut.getSingleRowData();
        objectArray[0] = ValuePool.getInt(n);
        switch (n) {
            case 1: 
            case 2: {
                objectArray[2] = object;
                break;
            }
            case 0: {
                objectArray[1] = object;
                break;
            }
            case 3: {
                objectArray[3] = object;
            }
        }
        Result result = this.execute(this.resultOut);
        if (result.isError()) {
            throw Error.error(result);
        }
    }

    @Override
    public synchronized boolean isReadOnlyDefault() {
        Object object = this.getAttribute(2);
        this.isReadOnlyDefault = (Boolean)object;
        return this.isReadOnlyDefault;
    }

    @Override
    public synchronized void setReadOnlyDefault(boolean bl) {
        if (bl != this.isReadOnlyDefault) {
            this.setAttribute(2, bl ? Boolean.TRUE : Boolean.FALSE);
            this.isReadOnlyDefault = bl;
        }
    }

    @Override
    public synchronized boolean isAutoCommit() {
        Object object = this.getAttribute(1);
        this.isAutoCommit = (Boolean)object;
        return this.isAutoCommit;
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) {
        if (bl != this.isAutoCommit) {
            this.setAttribute(1, bl ? Boolean.TRUE : Boolean.FALSE);
            this.isAutoCommit = bl;
        }
    }

    @Override
    public synchronized void setIsolationDefault(int n) {
        this.setAttribute(0, ValuePool.getInt(n));
    }

    @Override
    public synchronized int getIsolation() {
        Object object = this.getAttribute(0);
        return (Integer)object;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public Session getSession() {
        return null;
    }

    @Override
    public synchronized void startPhasedTransaction() {
    }

    @Override
    public synchronized void prepareCommit() {
        this.resultOut.setAsTransactionEndRequest(12, null);
        Result result = this.execute(this.resultOut);
        if (result.isError()) {
            throw Error.error(result);
        }
    }

    @Override
    public synchronized void commit(boolean bl) {
        this.resultOut.setAsTransactionEndRequest(0, null);
        Result result = this.execute(this.resultOut);
        if (result.isError()) {
            throw Error.error(result);
        }
    }

    @Override
    public synchronized void rollback(boolean bl) {
        this.resultOut.setAsTransactionEndRequest(1, null);
        Result result = this.execute(this.resultOut);
        if (result.isError()) {
            throw Error.error(result);
        }
    }

    @Override
    public synchronized void rollbackToSavepoint(String string) {
        this.resultOut.setAsTransactionEndRequest(2, string);
        Result result = this.execute(this.resultOut);
        if (result.isError()) {
            throw Error.error(result);
        }
    }

    @Override
    public synchronized void savepoint(String string) {
        Result result = Result.newSetSavepointRequest(string);
        Result result2 = this.execute(result);
        if (result2.isError()) {
            throw Error.error(result2);
        }
    }

    @Override
    public synchronized void releaseSavepoint(String string) {
        this.resultOut.setAsTransactionEndRequest(4, string);
        Result result = this.execute(this.resultOut);
        if (result.isError()) {
            throw Error.error(result);
        }
    }

    @Override
    public void addWarning(HsqlException hsqlException) {
    }

    @Override
    public synchronized long getId() {
        return this.sessionID;
    }

    @Override
    public synchronized void resetSession() {
        Result result = Result.newResetSessionRequest();
        Result result2 = this.execute(result);
        if (result2.isError()) {
            this.isClosed = true;
            this.closeConnection();
            throw Error.error(result2);
        }
        this.sessionID = result2.getSessionId();
        this.databaseID = result2.getDatabaseId();
    }

    protected void write(Result result) throws IOException, HsqlException {
        result.write(this, this.dataOutput, this.rowOut);
    }

    protected Result read() throws IOException, HsqlException {
        Result result = Result.newResult(this.dataInput, this.rowIn);
        result.readAdditionalResults(this, this.dataInput, this.rowIn);
        this.rowOut.setBuffer(this.mainBuffer);
        this.rowIn.resetRow(this.mainBuffer.length);
        return result;
    }

    @Override
    public synchronized String getInternalConnectionURL() {
        return null;
    }

    public synchronized long getLobId() {
        return this.lobIDSequence--;
    }

    @Override
    public BlobDataID createBlob(long l) {
        BlobDataID blobDataID = new BlobDataID(this.getLobId());
        return blobDataID;
    }

    @Override
    public ClobDataID createClob(long l) {
        ClobDataID clobDataID = new ClobDataID(this.getLobId());
        return clobDataID;
    }

    @Override
    public void allocateResultLob(ResultLob resultLob, InputStream inputStream) {
    }

    @Override
    public Scanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new Scanner();
        }
        return this.scanner;
    }

    @Override
    public Calendar getCalendar() {
        if (this.calendar == null) {
            TimeZone timeZone = TimeZone.getTimeZone(this.zoneString);
            this.calendar = new GregorianCalendar(timeZone);
        }
        return this.calendar;
    }

    @Override
    public TimestampData getCurrentDate() {
        long l = System.currentTimeMillis();
        long l2 = HsqlDateTime.getCurrentDateMillis(l) / 1000L;
        return new TimestampData(l2);
    }

    @Override
    public int getZoneSeconds() {
        return this.zoneSeconds;
    }

    @Override
    public int getStreamBlockSize() {
        return 524288;
    }

    @Override
    public HsqlProperties getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = this.clientPropertiesString.length() > 0 ? HsqlProperties.delimitedArgPairsToProps(this.clientPropertiesString, "=", ";", null) : new HsqlProperties();
        }
        return this.clientProperties;
    }

    @Override
    public JDBCConnection getJDBCConnection() {
        return this.connection;
    }

    @Override
    public void setJDBCConnection(JDBCConnection jDBCConnection) {
        this.connection = jDBCConnection;
    }

    @Override
    public String getDatabaseUniqueName() {
        return this.databaseUniqueName;
    }

    public static String toNetCompVersionString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((n *= -1) / 1000000);
        stringBuffer.append('.');
        stringBuffer.append((n %= 1000000) / 10000);
        stringBuffer.append('.');
        stringBuffer.append((n %= 10000) / 100);
        stringBuffer.append('.');
        stringBuffer.append(n %= 100);
        return stringBuffer.toString();
    }

    protected void handshake() throws IOException {
        this.dataOutput.writeInt(-2010000);
        this.dataOutput.flush();
    }
}

