/*
 * Decompiled with CFR 0.152.
 */
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToMapSymbolToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMapUnicodeToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveS;
import gov.nih.nlm.nls.lvg.Flows.ToSplitLigatures;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToStripMapUnicode;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RTrieTree;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Util.In;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class norm
extends SystemOption {
    private static final String NO_OUTPUT_STR = "-No Output-";
    private static String noOutputStr_ = "-No Output-";
    private static boolean detailsFlag_ = false;
    private static boolean runFlag_ = true;
    private static boolean noOutputFlag_ = false;
    private static boolean promptFlag_ = false;
    private static boolean filterInputFlag_ = false;
    private static Hashtable<Character, String> symbolMap_ = null;
    private static Hashtable<Character, String> unicodeMap_ = null;
    private static Hashtable<Character, Character> diacriticMap_ = null;
    private static Hashtable<Character, String> ligatureMap_ = null;
    private static Hashtable<Character, String> nonStripMap_ = null;
    private static RTrieTree removeSTree_ = null;
    private static String separator_ = GlobalBehavior.GetFieldSeparator();
    private static BufferedReader inReader_ = null;
    private static BufferedWriter outWriter_ = null;
    private static boolean fileOutput_ = false;
    private static int termFieldNum_ = 1;
    private static Connection conn_ = null;
    private static RamTrie trie_ = null;
    private static String configFile_ = null;
    private static String promptStr_ = null;
    private static Configuration conf_ = null;
    private static int maxTerm_ = -1;
    private static Vector<String> stopWords_ = null;

    public static void main(String[] args) {
        norm norm2;
        String optionStr = "";
        Option io = new Option(optionStr);
        if (args.length > 0) {
            optionStr = "";
            for (int i = 0; i < args.length; ++i) {
                optionStr = i == 0 ? args[i] : optionStr + " " + args[i];
            }
            io = new Option(optionStr);
        }
        if (SystemOption.CheckSyntax(io, (norm2 = new norm()).GetOption(), false, true)) {
            norm2.ExecuteCommands(io, norm2.GetOption());
            boolean useClassPath = false;
            if (configFile_ == null) {
                useClassPath = true;
                configFile_ = "data.config.lvg";
            }
            if (conf_ == null) {
                conf_ = new Configuration(configFile_, useClassPath);
            }
            promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
            if (conf_.GetSize() <= 0) {
                runFlag_ = false;
            } else {
                if (maxTerm_ == -1) {
                    maxTerm_ = Integer.parseInt(conf_.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
                }
                if (conf_.GetConfiguration("NO_OUTPUT") != null) {
                    noOutputStr_ = conf_.GetConfiguration("NO_OUTPUT");
                }
                if (stopWords_ == null) {
                    stopWords_ = ToStripStopWords.GetStopWordsFromFile(conf_);
                }
                if (symbolMap_ == null) {
                    symbolMap_ = ToMapSymbolToAscii.GetSymbolMapFromFile(conf_);
                }
                if (unicodeMap_ == null) {
                    unicodeMap_ = ToMapUnicodeToAscii.GetUnicodeMapFromFile(conf_);
                }
                if (diacriticMap_ == null) {
                    diacriticMap_ = ToStripDiacritics.GetDiacriticMapFromFile(conf_);
                }
                if (ligatureMap_ == null) {
                    ligatureMap_ = ToSplitLigatures.GetLigatureMapFromFile(conf_);
                }
                if (nonStripMap_ == null) {
                    nonStripMap_ = ToStripMapUnicode.GetNonStripMapFromFile(conf_);
                }
                if (removeSTree_ == null) {
                    removeSTree_ = ToRemoveS.GetRTrieTreeFromFile(conf_);
                }
                if (!conf_.GetConfiguration("LVG_PROMPT").equals("DEFAULT")) {
                    promptStr_ = conf_.GetConfiguration("LVG_PROMPT");
                }
                if (runFlag_) {
                    norm2.GetVariants();
                }
            }
        } else {
            NormHelp.NormHelp(outWriter_, fileOutput_);
        }
        try {
            norm.Close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void GetVariants() {
        if (inReader_ == null) {
            try {
                inReader_ = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            catch (IOException e) {
                System.err.println("**Error: problem of reading std-in");
            }
        }
        int minTermLen = Integer.parseInt(conf_.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf_.GetConfiguration("LVG_DIR");
        int minTrieStemLength = Integer.parseInt(conf_.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        try {
            conn_ = DbBase.OpenConnection(conf_);
            trie_ = new RamTrie(true, minTermLen, lvgDir, minTrieStemLength);
            do {
                if (!promptFlag_) continue;
                norm.GetPrompt();
            } while (norm.LineHandler(inReader_.readLine()));
            norm.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void ExecuteCommand(OptionItem optionItem, Option systemOption) {
        OptionItem nameItem = OptionUtility.GetItemByName(optionItem, systemOption, false);
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        if (norm.CheckOption(nameItem, "-ci")) {
            try {
                Configuration conf;
                boolean useClassPath = false;
                String configFile = configFile_;
                if (configFile == null) {
                    useClassPath = true;
                    configFile = "data.config.lvg";
                }
                if ((conf = conf_) == null) {
                    conf = new Configuration(configFile, useClassPath);
                }
                Out.Println(outWriter_, conf.GetInformation(), fileOutput_, false);
            }
            catch (IOException e) {
                // empty catch block
            }
            runFlag_ = false;
        } else if (norm.CheckOption(nameItem, "-d")) {
            detailsFlag_ = true;
        } else if (norm.CheckOption(nameItem, "-h")) {
            NormHelp.NormHelp(outWriter_, fileOutput_);
            runFlag_ = false;
        } else if (norm.CheckOption(nameItem, "-hs")) {
            systemOption.PrintOptionHierachy();
            runFlag_ = false;
        } else if (norm.CheckOption(nameItem, "-i:STR")) {
            String inFile = nameItem.GetOptionArgument();
            if (inFile != null) {
                try {
                    inReader_ = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                }
                catch (IOException e) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + inFile);
                }
            }
        } else if (norm.CheckOption(nameItem, "-n")) {
            noOutputFlag_ = true;
        } else if (norm.CheckOption(nameItem, "-o:STR")) {
            String outFile = nameItem.GetOptionArgument();
            if (outFile != null) {
                try {
                    outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    fileOutput_ = true;
                }
                catch (IOException e) {
                    runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + outFile);
                }
            }
        } else if (norm.CheckOption(nameItem, "-p")) {
            promptFlag_ = true;
        } else if (norm.CheckOption(nameItem, "-s:STR")) {
            separator_ = nameItem.GetOptionArgument();
            if (separator_.equals("\\t")) {
                separator_ = new Character('\t').toString();
            }
        } else if (norm.CheckOption(nameItem, "-t:INT")) {
            termFieldNum_ = Integer.parseInt(nameItem.GetOptionArgument());
        } else if (norm.CheckOption(nameItem, "-ti")) {
            filterInputFlag_ = true;
        } else if (norm.CheckOption(nameItem, "-v")) {
            try {
                String releaseStr = "norm.2013";
                Out.Println(outWriter_, releaseStr, fileOutput_, false);
            }
            catch (IOException e) {
                // empty catch block
            }
            runFlag_ = false;
        } else if (norm.CheckOption(nameItem, "-x:STR")) {
            configFile_ = nameItem.GetOptionArgument();
        }
    }

    @Override
    protected void DefineFlag() {
        String flagStr = "-ci -d -h -hs -i:STR -n -o:STR -p -s:STR -t:INT -ti -v -x:STR";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-ci", "Print_Config_Info");
        this.systemOption_.SetFlagFullName("-d", "Print_Operation_Details");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-n", "No_Output");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-s", "Field_Separator");
        this.systemOption_.SetFlagFullName("-t", "Term_Field");
        this.systemOption_.SetFlagFullName("-ti", "Display_Filtered_Input");
        this.systemOption_.SetFlagFullName("-v", "Version");
        this.systemOption_.SetFlagFullName("-x", "Load_Configuration_file");
    }

    private static void Close() throws IOException, SQLException {
        if (outWriter_ != null) {
            outWriter_.close();
        }
        if (inReader_ != null) {
            inReader_.close();
        }
        if (conn_ != null) {
            DbBase.CloseConnection(conn_, conf_);
        }
    }

    private static void GetPrompt() throws IOException {
        Out.Println(outWriter_, promptStr_, fileOutput_, false);
    }

    private static boolean LineHandler(String line) throws SQLException, IOException {
        if (line == null) {
            return false;
        }
        String inTerm = In.GetField(line, separator_, termFieldNum_);
        LexItem in = new LexItem(inTerm);
        Vector<LexItem> result = ToNormalize.Mutate(in, maxTerm_, stopWords_, conn_, trie_, symbolMap_, unicodeMap_, ligatureMap_, diacriticMap_, nonStripMap_, removeSTree_, detailsFlag_, false);
        if (noOutputFlag_ && (result.size() == 0 || result.size() == 1 && result.elementAt(0).GetTargetTerm().length() == 0)) {
            String out = line;
            if (filterInputFlag_) {
                out = in.GetOriginalTerm();
            }
            Out.Println(outWriter_, out + separator_ + noOutputStr_, fileOutput_, false);
        } else {
            for (int i = 0; i < result.size(); ++i) {
                LexItem temp = result.elementAt(i);
                String out = line;
                if (filterInputFlag_) {
                    out = temp.GetOriginalTerm();
                }
                Out.Println(outWriter_, out + separator_ + temp.GetTargetTerm(), fileOutput_, false);
                if (!detailsFlag_) continue;
                Out.Println(outWriter_, temp.GetDetailInformation(), fileOutput_, false);
            }
        }
        return true;
    }

    static {
        try {
            outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (IOException e) {
            System.err.println("**Error: problem of opening Std-out.");
        }
    }
}

