/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Trie.PersistentTreeNode;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PersistentTree {
    private RandomAccessFile raf_ = null;
    private long rootAddress_ = -1L;
    private static final int NEXT_OFFSET = 4;
    private static final int CHILD_OFFSET = 20;

    public PersistentTree(String path) {
        try {
            this.raf_ = new RandomAccessFile(path, "rw");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RandomAccessFile GetRaf() {
        return this.raf_;
    }

    public long GetRootAddress() {
        return this.rootAddress_;
    }

    public void Add(PersistentTreeNode node, long parentAddress) throws IOException {
        long address = this.raf_.length();
        int parentLevel = -1;
        if (parentAddress != -1L) {
            this.raf_.seek(parentAddress + 20L);
            long parentChild = this.raf_.readLong();
            if (parentChild == -1L) {
                this.raf_.seek(parentAddress + 20L);
                this.raf_.writeLong(address);
            } else {
                long target = parentChild;
                while (true) {
                    this.raf_.seek(target + 4L);
                    long next = this.raf_.readLong();
                    if (next == -1L) {
                        this.raf_.seek(target + 4L);
                        this.raf_.writeLong(address);
                        break;
                    }
                    target = next;
                }
            }
            this.raf_.seek(parentAddress);
            parentLevel = this.raf_.readInt();
        } else {
            this.rootAddress_ = address;
        }
        node.SetAddress(address);
        node.SetLevel(parentLevel + 1);
        this.raf_.seek(address);
        this.raf_.writeInt(node.GetLevel());
        this.raf_.writeLong(node.GetNext());
        this.raf_.writeLong(node.GetParent());
        this.raf_.writeLong(node.GetChild());
        node.WriteData(this.raf_);
    }

    public void Close() throws IOException {
        this.raf_.close();
    }
}

