/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Trie.RuleException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class InflectionRule {
    private String ruleStr_ = null;
    private String inSuffix_ = null;
    private String outSuffix_ = null;
    private long inCategory_ = 0L;
    private long outCategory_ = 0L;
    private long inInflection_ = 0L;
    private long outInflection_ = 0L;
    private Hashtable<String, String> exceptions_ = null;

    public InflectionRule(String ruleStr) {
        this.ruleStr_ = ruleStr;
        this.DecomposeRuleStr();
    }

    public void Reverse() {
        String tempinSuffix = this.inSuffix_;
        long tempCategory = this.inCategory_;
        long tempInflection = this.inInflection_;
        this.inSuffix_ = this.outSuffix_;
        this.inCategory_ = this.outCategory_;
        this.inInflection_ = this.outInflection_;
        this.outSuffix_ = tempinSuffix;
        this.outCategory_ = tempCategory;
        this.outInflection_ = tempInflection;
        String fs = new Character('|').toString();
        this.ruleStr_ = this.inSuffix_ + fs + Category.ToName(this.inCategory_) + fs + Inflection.ToName(this.inInflection_) + fs + this.outSuffix_ + fs + Category.ToName(this.outCategory_) + fs + Inflection.ToName(this.outInflection_);
    }

    public boolean equals(InflectionRule rule) {
        return this.ruleStr_.equals(rule.GetRuleStr());
    }

    public String GetInSuffix() {
        return this.inSuffix_;
    }

    public String GetOutSuffix() {
        return this.outSuffix_;
    }

    public Hashtable<String, String> GetExceptions() {
        return this.exceptions_;
    }

    public String GetRuleStr() {
        return this.ruleStr_;
    }

    public long GetInCategory() {
        return this.inCategory_;
    }

    public String GetInCategoryStr() {
        return Category.ToName(this.inCategory_);
    }

    public long GetInInflection() {
        return this.inInflection_;
    }

    public String GetInInflectionStr() {
        return Inflection.ToName(this.inInflection_);
    }

    public long GetOutCategory() {
        return this.outCategory_;
    }

    public String GetOutCategoryStr() {
        return Category.ToName(this.outCategory_);
    }

    public long GetOutInflection() {
        return this.outInflection_;
    }

    public String GetOutInflectionStr() {
        return Inflection.ToName(this.outInflection_);
    }

    public void AddException(String line) {
        RuleException exception = new RuleException(line);
        if (!exception.IsLegalFormat()) {
            return;
        }
        if (this.exceptions_ == null) {
            this.exceptions_ = new Hashtable();
        }
        String key = exception.GetKey();
        String value = exception.GetValue();
        Enumeration<String> keyEn = this.exceptions_.keys();
        Enumeration<String> valueEn = this.exceptions_.elements();
        boolean duplicate = false;
        while (keyEn.hasMoreElements()) {
            if (!key.equals(keyEn.nextElement()) || !value.equals(valueEn.nextElement())) continue;
            duplicate = true;
            break;
        }
        if (!duplicate) {
            this.exceptions_.put(key, value);
        }
    }

    public static void main(String[] args) {
        InflectionRule rule = new InflectionRule("Cy$|adv|positive|Cier$|adv|comparative");
        rule.AddException("|er;");
        rule.AddException("inhal|inhaler;");
        rule.PrintRule();
        rule.Reverse();
        rule.PrintRule();
    }

    private void DecomposeRuleStr() {
        StringTokenizer buf = new StringTokenizer(this.ruleStr_, "|");
        this.inSuffix_ = buf.nextToken();
        this.inCategory_ = Category.ToValue(buf.nextToken());
        this.inInflection_ = Inflection.ToValue(buf.nextToken());
        this.outSuffix_ = buf.nextToken();
        this.outCategory_ = Category.ToValue(buf.nextToken());
        this.outInflection_ = Inflection.ToValue(buf.nextToken());
    }

    private void PrintRule() {
        System.out.println("------ Inflection Rule ------");
        System.out.println("ruleStr_: " + this.ruleStr_);
        System.out.println("inSuffix_: " + this.inSuffix_);
        System.out.println("inCategory_: " + this.inCategory_);
        System.out.println("inInflection_: " + this.inInflection_);
        System.out.println("outSuffix_: " + this.outSuffix_);
        System.out.println("outCategory_: " + this.outCategory_);
        System.out.println("outInflection_: " + this.outInflection_);
        System.out.println("exceptions_: " + (this.exceptions_ == null ? 0 : this.exceptions_.size()));
    }
}

