/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.BitMaskBase;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import java.util.ArrayList;
import java.util.Vector;

public class Gender
extends BitMaskBase {
    public static final int MALE_BIT = 0;
    public static final int FEMALE_BIT = 1;
    public static final int NEUTER_BIT = 2;
    public static final int NOT_KNOWABLE_BIT = 3;
    public static final long ALL_BIT_VALUE = 15L;
    private static ArrayList<Vector<String>> bitStr_ = new ArrayList(63);

    public Gender() {
        super(15L, bitStr_);
    }

    public Gender(long value) {
        super(value, 15L, bitStr_);
    }

    public static long ToValue(String valueStr) {
        return Gender.ToValue(valueStr, bitStr_);
    }

    public static String ToName(long value) {
        return Gender.ToName(value, 15L, bitStr_);
    }

    public static String GetBitName(int bitValue) {
        return Gender.GetBitName(bitValue, 0);
    }

    public static String GetBitName(int bitValue, int index) {
        return Gender.GetBitName(bitValue, index, bitStr_);
    }

    public static long Enumerate(String valueStr) {
        return Gender.Enumerate(valueStr, bitStr_);
    }

    public static void main(String[] args) {
        System.out.println("------ static methods ----------");
        System.out.println(" - ToValue(female+F+male+girl): " + Gender.ToValue("female+F+male+girl"));
        System.out.println(" - ToValue(female+neuter): " + Gender.ToValue("female+neuter"));
        System.out.println(" - ToValue(Man+girl): " + Gender.ToValue("Man+girl"));
        System.out.println("---------");
        System.out.println(" - ToName(4): " + Gender.ToName(4L));
        System.out.println(" - ToName(6): " + Gender.ToName(6L));
        System.out.println(" - ToName(32): " + Gender.ToName(32L));
        System.out.println("---------");
        System.out.println(" - GetBitValue(Gender.MALE_BIT): " + Gender.GetBitValue(0));
        System.out.println(" - GetBitValue(Gender.FEMALE_BIT): " + Gender.GetBitValue(1));
        System.out.println(" - GetBitValue(Gender.NEUTER_BIT): " + Gender.GetBitValue(2));
        System.out.println(" - GetBitValue(Gender.NOT_KNOWABLE_BIT): " + Gender.GetBitValue(3));
        System.out.println("---------");
        System.out.println(" - GetBitIndex(4): " + Gender.GetBitIndex(4L));
        System.out.println(" - GetBitIndex(6): " + Gender.GetBitIndex(6L));
        System.out.println("---------");
        System.out.println(" - Contains(6, 4): " + Gender.Contains(6L, 4L));
        System.out.println(" - Contains(6, 1): " + Gender.Contains(6L, 1L));
        System.out.println("---------");
        System.out.println(" - Enumerate(m): " + Gender.Enumerate("m"));
        System.out.println(" - Enumerate(female): " + Gender.Enumerate("female"));
        System.out.println(" - Enumerate(f): " + Gender.Enumerate("f"));
        System.out.println(" - Enumerate(F): " + Gender.Enumerate("F"));
        System.out.println("---------");
        System.out.println(" - GetBitName(1): " + Gender.GetBitName(1));
        System.out.println(" - GetBitName(1, 0): " + Gender.GetBitName(1, 0));
        System.out.println(" - GetBitName(1, 1): " + Gender.GetBitName(1, 1));
        System.out.println(" - GetBitName(1, 2): " + Gender.GetBitName(1, 2));
        System.out.println(" - GetBitName(4): " + Gender.GetBitName(4));
        System.out.println(" - GetBitName(MAX_BIT): " + Gender.GetBitName(63));
        System.out.println(" - GetBitName(100): " + Gender.GetBitName(100));
        System.out.println(GlobalBehavior.LS_STR + "------ object methods ----------");
        Gender g = new Gender();
        System.out.println("---------");
        g.SetValue(6L);
        System.out.println(" - g.SetValue(6)");
        System.out.println(" - g.GetBitFlag(MALE_BIT): " + g.GetBitFlag(0));
        System.out.println(" - g.GetBitFlag(FEMALE_BIT): " + g.GetBitFlag(1));
        System.out.println(" - g.GetBitFlag(NEUTER_BIT): " + g.GetBitFlag(2));
        System.out.println(" - g.GetBitFlag(NOT_KNOWABLE_BIT): " + g.GetBitFlag(3));
        System.out.println("---------");
        System.out.println(" - g.GetValue(): " + g.GetValue());
        g.SetBitFlag(0, true);
        System.out.println(" - g.SetBitFlag(0, true);");
        System.out.println(" - g.GetValue(): " + g.GetValue());
        g.SetBitFlag(0, false);
        System.out.println(" - g.SetBitFlag(0, false);");
        System.out.println(" - g.GetValue(): " + g.GetValue());
        System.out.println("---------");
        System.out.println(" - g.SetBitFlag(1, false);");
        g.SetBitFlag(1, false);
        System.out.println(" - g.GetValue(): " + g.GetValue());
        System.out.println(" - g.GetName(): " + g.GetName());
        System.out.println(" - g.SetBitFlag(1, true);");
        g.SetBitFlag(1, true);
        System.out.println(" - g.GetValue(): " + g.GetValue());
        System.out.println(" - g.GetName(): " + g.GetName());
        System.out.println("---------");
        System.out.println(" - g.Contains(2): " + g.Contains(2L));
        System.out.println(" - g.Contains(1): " + g.Contains(1L));
    }

    static {
        for (int i = 0; i < 63; ++i) {
            bitStr_.add(i, new Vector());
        }
        bitStr_.get(0).addElement("male");
        bitStr_.get(0).addElement("m");
        bitStr_.get(1).addElement("female");
        bitStr_.get(1).addElement("f");
        bitStr_.get(2).addElement("neuter");
        bitStr_.get(3).addElement("notKnowable");
        bitStr_.get(3).addElement("_");
    }
}

