/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Configuration {
    public static final String LVG_DIR = "LVG_DIR";
    public static final String AUTO_MODE = "AUTO_MODE";
    public static final String STOP_WORD_FILE = "LVG_STOP_WORD_FILE";
    public static final String NONINFO_WORD_FILE = "LVG_NONINFO_WORD_FILE";
    public static final String CONJ_WORD_FILE = "LVG_CONJ_WORD_FILE";
    public static final String DIACRITICS_FILE = "LVG_DIACRITICS_FILE";
    public static final String LIGATURES_FILE = "LVG_LIGATURES_FILE";
    public static final String UNICODE_SYNONYM_FILE = "LVG_UNICODE_SYNONYM_FILE";
    public static final String UNICODE_SYMBOL_FILE = "LVG_UNICODE_SYMBOL_FILE";
    public static final String UNICODE_FILE = "LVG_UNICODE_FILE";
    public static final String NON_STRIP_MAP_UNICODE_FILE = "LVG_NON_STRIP_MAP_UNICODE_FILE";
    public static final String REMOVE_S_FILE = "LVG_REMOVE_S_FILE";
    public static final String MIN_TERM_LENGTH = "MIN_TERM_LENGTH";
    public static final String MAX_METAPHONE = "MAX_METAPHONE";
    public static final String MAX_UNINFLS = "MAX_RULE_UNINFLECTED_TERMS";
    public static final String CCGI = "CGI_EOP";
    public static final String NO_OUTPUT = "NO_OUTPUT";
    public static final String MAX_RESULT = "TRUNCATED_RESULTS";
    public static final String LVG_PROMPT = "LVG_PROMPT";
    public static final String DIR_TRIE_STEM_LENGTH = "DIR_TRIE_STEM_LENGTH";
    public static final String START_TAG = "START_TAG";
    public static final String END_TAG = "END_TAG";
    public static final String DB_TYPE = "DB_TYPE";
    public static final String DB_DRIVER = "DB_DRIVER";
    public static final String JDBC_URL = "JDBC_URL";
    public static final String DB_HOST = "DB_HOST";
    public static final String DB_NAME = "DB_NAME";
    public static final String DB_USERNAME = "DB_USERNAME";
    public static final String DB_PASSWORD = "DB_PASSWORD";
    private PropertyResourceBundle configSrc_ = null;
    private Hashtable<String, String> config_ = new Hashtable();

    public Configuration(String fName, boolean useClassPath) {
        this.SetConfiguration(fName, useClassPath);
    }

    public int GetSize() {
        int size = 0;
        if (this.config_ != null) {
            size = this.config_.size();
        }
        return size;
    }

    public String GetConfiguration(String key) {
        String out = this.config_.get(key);
        return out;
    }

    public void OverwriteProperties(Hashtable<String, String> properties) {
        Enumeration<String> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = properties.get(key);
            this.config_.put(key, value);
        }
    }

    public String GetInformation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("LVG_DIR: [" + this.GetConfiguration(LVG_DIR) + "]");
        buffer.append(GlobalBehavior.LS_STR);
        buffer.append("DB_TYPE: [" + this.GetConfiguration(DB_TYPE) + "]");
        buffer.append(GlobalBehavior.LS_STR);
        buffer.append("DB_NAME: [" + this.GetConfiguration(DB_NAME) + "]");
        return buffer.toString();
    }

    private void SetConfiguration(String fName, boolean useClassPath) {
        String lvgDir;
        try {
            if (useClassPath) {
                this.configSrc_ = (PropertyResourceBundle)ResourceBundle.getBundle(fName);
            } else {
                FileInputStream file = new FileInputStream(fName);
                this.configSrc_ = new PropertyResourceBundle(file);
                file.close();
            }
        }
        catch (Exception e) {
            System.err.println("** Configuration Error: " + e.getMessage());
            System.err.println("** Error: problem of opening/reading config file: '" + fName + "'. Use -x option to specify the config file path.");
        }
        if (this.configSrc_ != null) {
            Enumeration<String> e = this.configSrc_.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = this.configSrc_.getString(key);
                this.config_.put(key, value);
            }
        }
        if ((lvgDir = this.GetConfiguration(LVG_DIR)) != null && lvgDir.equals(AUTO_MODE)) {
            File file = new File(System.getProperty("user.dir"));
            String curDir = file.getAbsolutePath() + System.getProperty("file.separator");
            this.config_.put(LVG_DIR, curDir);
        }
    }
}

