/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Char;
import java.util.Vector;

public class ToStripPunctuation
extends Transformation
implements Cloneable {
    private static final String INFO = "Strip Punctuation";

    public static Vector<LexItem> Mutate(LexItem in, boolean detailsFlag, boolean mutateFlag) {
        String term = ToStripPunctuation.StripPunctuation(in.GetSourceTerm());
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToStripPunctuation.UpdateLexItem(in, term, 5, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToStripPunctuation.GetTestStr(args, "Left's 12.34.56");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToStripPunctuation.Mutate(in, true, true);
        ToStripPunctuation.PrintResults(in, outs);
    }

    static String StripPunctuation(String inStr) {
        int length = inStr.length();
        char[] temp = new char[length];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            char tempChar = inStr.charAt(i);
            if (Char.IsPunctuation(tempChar)) continue;
            temp[index] = tempChar;
            ++index;
        }
        String out = new String(temp);
        return out.trim();
    }
}

