/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.util.Vector;

public class ToStripAmbiguityTags
extends Transformation
implements Cloneable {
    private static final String INFO = "Strip Ambiguity Tags";

    public static Vector<LexItem> Mutate(LexItem in, boolean detailsFlag, boolean mutateFlag) {
        String term = ToStripAmbiguityTags.StripAmbiguityTag(in.GetSourceTerm());
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToStripAmbiguityTags.UpdateLexItem(in, term, 32, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToStripAmbiguityTags.GetTestStr(args, "Cold <1>");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToStripAmbiguityTags.Mutate(in, true, true);
        ToStripAmbiguityTags.PrintResults(in, outs);
    }

    private static String StripAmbiguityTag(String inStr) {
        int beginIndex = inStr.indexOf(60);
        int endIndex = inStr.indexOf(62, beginIndex);
        if (beginIndex < 0) {
            return inStr;
        }
        if (endIndex < 0 || endIndex <= beginIndex) {
            return inStr;
        }
        String token = inStr.substring(beginIndex + 1, endIndex);
        if (!ToStripAmbiguityTags.IsInteger(token)) {
            return inStr;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(inStr.substring(0, beginIndex));
        buffer.append(inStr.substring(endIndex, inStr.length() - 1));
        String returnStr = buffer.toString();
        return returnStr.trim();
    }

    private static boolean IsInteger(String inStr) {
        boolean isInteger = false;
        try {
            Integer.parseInt(inStr);
            isInteger = true;
        }
        catch (NumberFormatException e) {
            isInteger = false;
        }
        return isInteger;
    }
}

