/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbEui;
import gov.nih.nlm.nls.lvg.Db.EuiRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToRetrieveEui
extends Transformation
implements Cloneable {
    private static final String INFO = "Retrieve EUI";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<EuiRecord> termList = ToRetrieveEui.GetEui(in.GetSourceTerm(), conn);
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < termList.size(); ++i) {
            EuiRecord rec = termList.elementAt(i);
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                mutate = Transformation.NO_MUTATE_INFO;
            }
            LexItem temp = ToRetrieveEui.UpdateLexItem(in, rec.GetEui(), 24, rec.GetCategory(), rec.GetInflection(), details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToRetrieveEui.GetTestStr(args, "building");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToRetrieveEui.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToRetrieveEui.PrintResults(in, outs);
    }

    private static Vector<EuiRecord> GetEui(String inStr, Connection conn) throws SQLException {
        Vector<EuiRecord> out = DbEui.GetEuisByInflectedTerm(inStr, conn);
        return out;
    }
}

