/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbDerivation;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.DerivationRecord;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariants;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Lib.Tag;
import gov.nih.nlm.nls.lvg.Lib.TermCatCatKey;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class ToRecursiveDerivations
extends Transformation
implements Cloneable {
    private static final String INFO = "Recursive Derivation";
    private static Vector<LexItem> derivations_ = new Vector();
    private static Hashtable<TermCatCatKey, LexItem> derivationHt_ = new Hashtable();
    private static String orgInputTerm_ = new String();

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, int restrictFlag, int derivationType, int derivationNegation, boolean detailsFlag, boolean mutateFlag, boolean detailFlowFlag) {
        ToRecursiveDerivations.Init(in.GetSourceTerm());
        ToRecursiveDerivations.GetRecursiveDerivations(in, conn, trie, restrictFlag, derivationType, derivationNegation, INFO, true, detailsFlag, mutateFlag, null);
        ToRecursiveDerivations.UpdateFlowHistory(detailFlowFlag);
        return ToRecursiveDerivations.GetDerivationVector();
    }

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, int restrictFlag, boolean detailsFlag, boolean mutateFlag, boolean detailFlowFlag) {
        ToRecursiveDerivations.Init(in.GetSourceTerm());
        ToRecursiveDerivations.GetRecursiveDerivations(in, conn, trie, restrictFlag, 6, 0, INFO, true, detailsFlag, mutateFlag, null);
        ToRecursiveDerivations.UpdateFlowHistory(detailFlowFlag);
        return ToRecursiveDerivations.GetDerivationVector();
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToRecursiveDerivations.GetTestStr(args, "medicine");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int minTrieStemLength = Integer.parseInt(conf.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = false;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, minTrieStemLength);
            if (conn != null) {
                outs = ToRecursiveDerivations.Mutate(in, conn, trie, 1, true, true, false);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToRecursiveDerivations.PrintResults(in, outs);
    }

    private static Vector<LexItem> GetDerivations(LexItem in, Connection conn, RamTrie trie, int restrictFlag, int derivationType, int derivationNegation, String infoStr, boolean appendFlowHistory, boolean detailsFlag, boolean mutateFlag, String rFlowHistory) {
        String inStr = in.GetSourceTerm();
        Vector<LexItem> outs = new Vector<LexItem>();
        if (in.GetSourceTerm().length() == 0) {
            return outs;
        }
        String flowName = rFlowHistory;
        try {
            LexItem temp;
            String fs;
            String mutate;
            String details;
            long inCat = in.GetSourceCategory().GetValue();
            long inInfl = in.GetSourceInflection().GetValue();
            Vector<DerivationRecord> factList = DbDerivation.GetDerivations(inStr, conn, derivationType, derivationNegation);
            Vector<LexItem> facts = new Vector<LexItem>();
            for (int i = 0; i < factList.size(); ++i) {
                DerivationRecord record = factList.elementAt(i);
                String term = record.GetTarget();
                long curCat = record.GetSourceCat();
                if (!InputFilter.IsLegal(inCat, curCat)) continue;
                details = null;
                mutate = null;
                if (detailsFlag) {
                    details = infoStr + " (FACT)";
                }
                if (mutateFlag) {
                    fs = GlobalBehavior.GetFieldSeparator();
                    mutate = "FACT" + fs + record.GetPureString(fs) + rFlowHistory + fs;
                }
                temp = ToRecursiveDerivations.UpdateLexItem(in, term, flowName, record.GetTargetCat(), Inflection.GetBitValue(0), details, mutate, false);
                facts.addElement(temp);
            }
            Vector<LexItem> rules = new Vector<LexItem>();
            if (restrictFlag == 3 || restrictFlag == 2 && facts.size() == 0) {
                Vector<RuleResult> ruleList = trie.GetDerivationsByRules(inStr, inCat, inInfl, true);
                for (int i = 0; i < ruleList.size(); ++i) {
                    RuleResult record = ruleList.elementAt(i);
                    String term = record.GetOutTerm();
                    if (DbUninflection.IsExistUninflectedTerm(term, conn)) continue;
                    details = null;
                    mutate = null;
                    if (detailsFlag) {
                        details = infoStr + " (RULE" + GlobalBehavior.GetFieldSeparator() + record.GetRuleString() + ")";
                    }
                    if (mutateFlag) {
                        fs = GlobalBehavior.GetFieldSeparator();
                        mutate = "RULE" + fs + record.GetInTerm() + fs + record.GetOutTerm() + fs + record.GetRuleString() + fs + rFlowHistory + fs;
                    }
                    temp = ToRecursiveDerivations.UpdateLexItem(in, term, flowName, Category.ToValue(record.GetOutCategory()), Inflection.ToValue(record.GetOutInflection()), details, mutate, false);
                    rules.addElement(temp);
                }
            }
            outs = OutputFilter.RestrictOption(facts, rules, restrictFlag);
        }
        catch (SQLException e) {
            System.err.println("** Error: Sql Exception in ToRecursiveDerivation Flow.");
            System.err.println(e.toString());
        }
        long adjValue = Category.GetBitValue(0);
        long nounValue = Category.GetBitValue(7);
        for (int i = 0; i < outs.size(); ++i) {
            LexItem temp = outs.elementAt(i);
            boolean curTagFlag = temp.GetSourceCategory().Contains(adjValue) && temp.GetTargetCategory().Contains(nounValue) || temp.GetSourceCategory().Contains(nounValue) && temp.GetTargetCategory().Contains(adjValue);
            Tag tag = new Tag(temp.GetTag());
            boolean tagFlag = curTagFlag && tag.GetBitFlag(0);
            String tagStr = tagFlag ? "NounAdj" : "NotNounAdj";
            tag.SetBitFlag(0, tagFlag);
            temp.SetTag(tag.GetValue());
            String mutateInfo = temp.GetMutateInformation() + tagStr + GlobalBehavior.GetFieldSeparator();
            temp.SetMutateInformation(mutateInfo);
        }
        return outs;
    }

    private static void GetRecursiveDerivations(LexItem in, Connection conn, RamTrie trie, int restrictFlag, int derivationType, int derivationNegation, String infoStr, boolean topLevel, boolean detailsFlag, boolean mutateFlag, String rFlowHistory) {
        ToRecursiveDerivations.CalRecursiveDerivations(in, conn, trie, restrictFlag, derivationType, derivationNegation, infoStr, topLevel, detailsFlag, mutateFlag, rFlowHistory);
        derivations_ = new Vector<LexItem>(derivationHt_.values());
    }

    private static void CalRecursiveDerivations(LexItem in, Connection conn, RamTrie trie, int restrictFlag, int derivationType, int derivationNegation, String infoStr, boolean topLevel, boolean detailsFlag, boolean mutateFlag, String rFlowHistory) {
        StringBuffer buffer = new StringBuffer();
        if (rFlowHistory == null) {
            String prevHistory = in.GetFlowHistory();
            rFlowHistory = new String();
            if (prevHistory == null) {
                prevHistory = new String();
            } else {
                buffer.append(prevHistory);
                buffer.append("+");
            }
        }
        buffer.append(Flow.GetBitName(18, 1));
        rFlowHistory = rFlowHistory + buffer.toString();
        Vector<LexItem> temp = ToRecursiveDerivations.GetDerivations(in, conn, trie, restrictFlag, derivationType, derivationNegation, infoStr, topLevel, detailsFlag, mutateFlag, rFlowHistory);
        for (int i = 0; i < temp.size(); ++i) {
            LexItem tempRec = temp.elementAt(i);
            TermCatCatKey tempKey = new TermCatCatKey(tempRec.GetTargetTerm(), ToFruitfulVariants.GetFirstCategory(tempRec), (int)tempRec.GetTargetCategory().GetValue());
            if (derivationHt_.containsKey(tempKey)) {
                LexItem existRec = derivationHt_.get(tempKey);
                String existFh = existRec.GetFlowHistory();
                String tempFh = tempRec.GetFlowHistory();
                if (existFh.length() <= tempFh.length()) continue;
                derivationHt_.remove(tempKey);
                derivationHt_.put(tempKey, tempRec);
                LexItem newLexItem = LexItem.TargetToSource(tempRec);
                ToRecursiveDerivations.CalRecursiveDerivations(newLexItem, conn, trie, restrictFlag, derivationType, derivationNegation, infoStr, false, detailsFlag, mutateFlag, rFlowHistory);
                continue;
            }
            if (tempRec.GetTargetTerm().equals(orgInputTerm_)) continue;
            derivationHt_.put(tempKey, tempRec);
            LexItem newLexItem = LexItem.TargetToSource(tempRec);
            ToRecursiveDerivations.CalRecursiveDerivations(newLexItem, conn, trie, restrictFlag, derivationType, derivationNegation, infoStr, false, detailsFlag, mutateFlag, rFlowHistory);
        }
    }

    private static void Init(String inputTerm) {
        orgInputTerm_ = inputTerm;
        derivationHt_.clear();
        derivations_.removeAllElements();
    }

    private static void UpdateFlowHistory(boolean detailFlowFlag) {
        if (!detailFlowFlag) {
            String flowName = Flow.GetBitName(36, 1);
            for (int i = 0; i < derivations_.size(); ++i) {
                LexItem cur = derivations_.elementAt(i);
                cur.SetFlowHistory(flowName);
            }
        }
    }

    private static Vector<LexItem> GetDerivationVector() {
        return derivations_;
    }
}

