/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.UnicodeUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToMapSymbolToAscii
extends Transformation
implements Cloneable {
    private static final String INFO = "Map Symbol to ASCII";
    private static final String NO_OPERATION = "NO";
    private static final String MAPPING = "MP";

    public static Vector<LexItem> Mutate(LexItem in, Hashtable<Character, String> symbolMap, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToMapSymbolToAscii.MapSymbolToAscii(in, symbolMap, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static Hashtable<Character, String> GetSymbolMapFromFile(Configuration config) {
        String fName = config.GetConfiguration("LVG_DIR") + config.GetConfiguration("LVG_UNICODE_SYMBOL_FILE");
        String line = null;
        Hashtable<Character, String> unicodeSymbolMap = new Hashtable<Character, String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fName), "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                StringTokenizer buf = new StringTokenizer(line, "|", true);
                char inChar = (char)UnicodeUtil.UnicodeHexToNum(buf.nextToken());
                Character symbol = new Character(inChar);
                buf.nextToken();
                int nextTokenIndex = 0;
                String mapStr = new String();
                while (buf.hasMoreTokens()) {
                    String curToken = buf.nextToken();
                    if (!curToken.equals("|")) {
                        if (nextTokenIndex == 0) {
                            mapStr = curToken;
                            break;
                        }
                        for (int i = 0; i < nextTokenIndex - 1; ++i) {
                            mapStr = mapStr + "|";
                        }
                        break;
                    }
                    ++nextTokenIndex;
                }
                if (UnicodeUtil.IsAsciiChar(inChar) || !UnicodeUtil.IsAsciiStr(mapStr)) {
                    System.err.println("** Warning: Illegal format in symbol file: '" + fName + "'.");
                    System.err.println(line);
                    continue;
                }
                unicodeSymbolMap.put(symbol, mapStr);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("** Error: problem of opening/reading Unicode symbol file: '" + fName + "'.");
            System.err.println("Exception: " + e.toString());
        }
        return unicodeSymbolMap;
    }

    public static String MapUnicodeSymbolToAscii(char inChar, Hashtable<Character, String> unicodeSymbolMap) {
        String outStr = UnicodeUtil.CharToStr(inChar);
        if (unicodeSymbolMap.containsKey(Character.valueOf(inChar))) {
            outStr = unicodeSymbolMap.get(Character.valueOf(inChar));
        }
        return outStr;
    }

    public static void main(String[] args) {
        String testStr = ToMapSymbolToAscii.GetTestStr(args, "\u00a9 and \u00b5");
        Configuration conf = new Configuration("data.config.lvg", true);
        Hashtable<Character, String> symbolMap = ToMapSymbolToAscii.GetSymbolMapFromFile(conf);
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToMapSymbolToAscii.Mutate(in, symbolMap, true, true);
        ToMapSymbolToAscii.PrintResults(in, outs);
    }

    private static Vector<LexItem> MapSymbolToAscii(LexItem in, Hashtable<Character, String> unicodeSymbolMap, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = infoStr;
        }
        if (mutateFlag) {
            mutate = new String();
        }
        String inStr = in.GetSourceTerm();
        String fs = GlobalBehavior.GetFieldSeparator();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            char curChar = inStr.charAt(i);
            String opStr = NO_OPERATION + fs;
            Character key = new Character(curChar);
            if (unicodeSymbolMap.containsKey(key)) {
                buffer.append(unicodeSymbolMap.get(key));
                opStr = MAPPING + fs;
            } else {
                buffer.append(curChar);
            }
            if (!mutateFlag) continue;
            mutate = mutate + opStr;
        }
        String term = buffer.toString();
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToMapSymbolToAscii.UpdateLexItem(in, term, 59, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }
}

