/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbDerivation;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.DerivationRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToDerivation
extends Transformation
implements Cloneable {
    private static final String INFO = "Derivation";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, int restrictFlag, int derivationType, int derivationNegation, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToDerivation.GetDerivations(in, conn, trie, restrictFlag, derivationType, derivationNegation, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, int restrictFlag, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToDerivation.GetDerivations(in, conn, trie, restrictFlag, 6, 0, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToDerivation.GetTestStr(args, "help");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int minTrieStemLength = Integer.parseInt(conf.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = false;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, minTrieStemLength);
            if (conn != null) {
                outs = ToDerivation.Mutate(in, conn, trie, 1, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToDerivation.PrintResults(in, outs);
    }

    protected static Vector<LexItem> GetDerivations(LexItem in, Connection conn, RamTrie trie, int restrictFlag, int derivationType, int derivationNegation, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String inStr = in.GetSourceTerm();
        long inCat = in.GetSourceCategory().GetValue();
        long inInfl = in.GetSourceInflection().GetValue();
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            LexItem temp;
            String mutate;
            String details;
            Vector<DerivationRecord> factList = DbDerivation.GetDerivations(inStr, conn, derivationType, derivationNegation);
            Vector<LexItem> facts = new Vector<LexItem>();
            for (int i = 0; i < factList.size(); ++i) {
                DerivationRecord record = factList.elementAt(i);
                String term = record.GetTarget();
                long curCat = record.GetSourceCat();
                if (!InputFilter.IsLegal(inCat, curCat)) continue;
                details = null;
                mutate = null;
                if (detailsFlag) {
                    details = infoStr + " (FACT)";
                }
                if (mutateFlag) {
                    mutate = "FACT" + GlobalBehavior.GetFieldSeparator() + record.GetString(GlobalBehavior.GetFieldSeparator());
                }
                temp = ToDerivation.UpdateLexItem(in, term, 18, record.GetTargetCat(), Inflection.GetBitValue(0), details, mutate);
                facts.addElement(temp);
            }
            Vector<LexItem> rules = new Vector<LexItem>();
            if (restrictFlag == 3 || restrictFlag == 2 && facts.size() == 0) {
                Vector<RuleResult> ruleList = trie.GetDerivationsByRules(inStr, inCat, inInfl, true);
                for (int i = 0; i < ruleList.size(); ++i) {
                    RuleResult record = ruleList.elementAt(i);
                    String term = record.GetOutTerm();
                    if (DbUninflection.IsExistUninflectedTerm(term, conn)) continue;
                    details = null;
                    mutate = null;
                    if (detailsFlag) {
                        details = infoStr + " (RULE" + GlobalBehavior.GetFieldSeparator() + record.GetRuleString() + ")";
                    }
                    if (mutateFlag) {
                        String fs = GlobalBehavior.GetFieldSeparator();
                        mutate = "RULE" + fs + record.GetRuleString() + fs;
                    }
                    temp = ToDerivation.UpdateLexItem(in, term, 18, Category.ToValue(record.GetOutCategory()), Inflection.ToValue(record.GetOutInflection()), details, mutate);
                    rules.addElement(temp);
                }
            }
            outs = OutputFilter.RestrictOption(facts, rules, restrictFlag);
        }
        catch (SQLException e) {
            System.err.println("** Error: Sql Exception in ToDerivation Flow.");
        }
        return outs;
    }
}

