/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.XeroxParc;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToConvertOutput
extends Transformation
implements Cloneable {
    private static final String INFO = "Convert";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<LexItem> out = new Vector<LexItem>();
        XeroxParc xp = new XeroxParc(in.GetSourceTerm());
        String term = xp.GetTerm();
        long cat = 2047L;
        long infl = 0xFFFFFFL;
        if (xp.IsLegal()) {
            cat = xp.GetCategoryValue();
            infl = DbInflection.GetInflByCat(term, (int)cat, conn);
        }
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        LexItem temp = ToConvertOutput.UpdateLexItem(in, term, 34, cat, infl, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToConvertOutput.GetTestStr(args, "['elderly', 'adj']");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToConvertOutput.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToConvertOutput.PrintResults(in, outs);
    }
}

