/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DerivationRecord;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class DbDerivation {
    public static Vector<DerivationRecord> GetDerivations(String inStr, Connection conn, int typeFlag, int negationFlag) throws SQLException {
        Vector<DerivationRecord> derivations = new Vector<DerivationRecord>();
        String query = "SELECT term1, cat1, eui1, term2, cat2, eui2, type, negation, prefix FROM Derivation WHERE termLc1 = ?";
        String tagQuery = DbDerivation.AddTagToQuery(query, typeFlag, negationFlag);
        PreparedStatement ps = conn.prepareStatement(tagQuery);
        ps.setString(1, inStr.toLowerCase());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            DerivationRecord derivationRecord = new DerivationRecord(rs.getString(1), rs.getInt(2), rs.getString(3), rs.getString(4), rs.getInt(5), rs.getString(6), rs.getString(7), rs.getString(8), rs.getString(9));
            derivations.addElement(derivationRecord);
        }
        rs.close();
        ps.close();
        String query2 = "SELECT term2, cat2, eui2, term1, cat1, eui1, type, negation, prefix FROM Derivation WHERE termLc2 = ?";
        String tagQuery2 = DbDerivation.AddTagToQuery(query2, typeFlag, negationFlag);
        PreparedStatement ps2 = conn.prepareStatement(tagQuery2);
        ps2.setString(1, inStr.toLowerCase());
        ResultSet rs2 = ps2.executeQuery();
        while (rs2.next()) {
            DerivationRecord derivationRecord = new DerivationRecord(rs2.getString(1), rs2.getInt(2), rs2.getString(3), rs2.getString(4), rs2.getInt(5), rs2.getString(6), rs2.getString(7), rs2.getString(8), rs2.getString(9));
            derivations.addElement(derivationRecord);
        }
        rs.close();
        ps2.close();
        return derivations;
    }

    public static Vector<DerivationRecord> GetDerivations(String inStr, Connection conn) throws SQLException {
        Vector<DerivationRecord> derivations = DbDerivation.GetDerivations(inStr, conn, 6, 0);
        return derivations;
    }

    public static void main(String[] args) {
        String testStr = "multiple";
        if (args.length == 1) {
            testStr = args[0];
        }
        Configuration conf = new Configuration("data.config.lvg", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                Vector<DerivationRecord> derivationList = DbDerivation.GetDerivations(testStr, conn);
                System.out.println("----- Total Derivations found: " + derivationList.size());
                for (int i = 0; i < derivationList.size(); ++i) {
                    if (i == 0) {
                        System.out.println("=== Found Derivations ===");
                    }
                    DerivationRecord record = derivationList.elementAt(i);
                    System.out.println(record.GetSource() + "|" + record.GetSourceCat() + "|" + record.GetTarget() + "|" + record.GetTargetCat());
                }
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private static String AddTagToQuery(String query, int typeFlag, int negationFlag) {
        String tagQuery = query;
        switch (negationFlag) {
            case 1: {
                tagQuery = tagQuery + " and negation = 'N'";
                break;
            }
            case 2: {
                break;
            }
            default: {
                tagQuery = tagQuery + " and negation = 'O'";
            }
        }
        switch (typeFlag) {
            case 0: {
                tagQuery = tagQuery + " and type = 'Z'";
                break;
            }
            case 1: {
                tagQuery = tagQuery + " and type = 'P'";
                break;
            }
            case 2: {
                tagQuery = tagQuery + " and type = 'S'";
                break;
            }
            case 3: {
                tagQuery = tagQuery + " and type <> 'S'";
                break;
            }
            case 4: {
                tagQuery = tagQuery + " and type <> 'P'";
                break;
            }
            case 5: {
                tagQuery = tagQuery + " and type <> 'Z'";
                break;
            }
        }
        return tagQuery;
    }
}

