/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.CanonRecord;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class DbCanon {
    public static Vector<CanonRecord> GetCanons(String unTerm, Connection conn) throws SQLException {
        String query = "SELECT unTerm, canTerm, canonId FROM Canonical WHERE unTerm = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, unTerm);
        Vector<CanonRecord> canons = new Vector<CanonRecord>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            CanonRecord canonRecord = new CanonRecord();
            canonRecord.SetUnInflectedTerm(rs.getString(1));
            canonRecord.SetCanonicalizedTerm(rs.getString(2));
            canonRecord.SetCanonicalId(rs.getInt(3));
            canons.addElement(canonRecord);
        }
        rs.close();
        ps.close();
        return canons;
    }

    public static void main(String[] args) {
        String testStr = "left";
        if (args.length == 1) {
            testStr = args[0];
        }
        Configuration conf = new Configuration("data.config.lvg", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                Vector<CanonRecord> canonList = DbCanon.GetCanons(testStr, conn);
                System.out.println("----- Total canonicalized forms found: " + canonList.size());
                for (int i = 0; i < canonList.size(); ++i) {
                    CanonRecord canon = canonList.elementAt(i);
                    System.out.println("=== Found Canonicalized Term ===");
                    System.out.println(canon.GetUninflectedTerm() + "|" + canon.GetCanonicalizedTerm() + "|" + canon.GetCanonicalId());
                }
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

