/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Api;

import gov.nih.nlm.nls.lvg.Util.Out;
import java.io.BufferedWriter;
import java.io.IOException;

public class LvgHelp {
    private static BufferedWriter bw_ = null;
    private static boolean fileOutput_ = false;

    public static void LvgHelp(BufferedWriter bw, boolean fileOutput) {
        bw_ = bw;
        fileOutput_ = fileOutput;
        LvgHelp.MenuPrint("");
        LvgHelp.MenuPrint("Synopsis:");
        LvgHelp.MenuPrint("  lvg [options]");
        LvgHelp.MenuPrint("");
        LvgHelp.MenuPrint("Description:");
        LvgHelp.MenuPrint("  Lexical Variant Generator.");
        LvgHelp.MenuPrint("");
        LvgHelp.MenuPrint("Options:");
        LvgHelp.MenuPrint("  -ccgi    Mark the end of the set of variants returned.");
        LvgHelp.MenuPrint("  -cf:INT  Input category field.");
        LvgHelp.MenuPrint("  -ci      Show configuration information.");
        LvgHelp.MenuPrint("  -C:INT   Case setting.");
        LvgHelp.MenuPrint("  -CR:o    Combine records by output terms.");
        LvgHelp.MenuPrint("  -CR:oc   Combine records by categories.");
        LvgHelp.MenuPrint("  -CR:oe   Combine records by EUI (used in flow s with -m option on).");
        LvgHelp.MenuPrint("  -CR:oi   Combine records by inflections.");
        LvgHelp.MenuPrint("  -d       Displays details status for each transformation.");
        LvgHelp.MenuPrint("  -DC:LONG Display variants contain categories specified.");
        LvgHelp.MenuPrint("  -DI:LONG Display variants contain inflections specified.");
        LvgHelp.MenuPrint("  -EC:LONG Display variants exclude categories specified.");
        LvgHelp.MenuPrint("  -EI:LONG Display variants exclude inflections specified.");
        LvgHelp.MenuPrint("  -f:h     Help information for flow components.");
        LvgHelp.MenuPrint("  -F:INT   Specified the field for output to display.");
        LvgHelp.MenuPrint("  -F:h     Help information for specifying output fields.");
        LvgHelp.MenuPrint("  -h       Display program help information (this is it).");
        LvgHelp.MenuPrint("  -hs      Display option's hierarchy structure.");
        LvgHelp.MenuPrint("  -i:STR   Define input file name.  The default is screen input");
        LvgHelp.MenuPrint("  -if:INT  Input inflection field");
        LvgHelp.MenuPrint("  -kd:INT  Restricts the output generated from the derivation morphology (1,2,3).");
        LvgHelp.MenuPrint("  -kdn:STR  derivation negations (O|N|B).");
        LvgHelp.MenuPrint("  -kdt:STR  derivation types (Z|S|P|ZS|ZP|SP|ZSP).");
        LvgHelp.MenuPrint("  -ki:INT  Restricts the output generated from the inflection morphology (1,2,3).");
        LvgHelp.MenuPrint("  -m       Displays extra information for mutation.");
        LvgHelp.MenuPrint("  -n       Return a \"-No Output-\" message when an input produces no output.");
        LvgHelp.MenuPrint("  -o:STR   Define output file name.  The default is screen output");
        LvgHelp.MenuPrint("  -p       Show the prompt. The default is no prompt.");
        LvgHelp.MenuPrint("  -R:INT   Restrict the number of variants for one flow.");
        LvgHelp.MenuPrint("  -s:STR   Defines a field separator.");
        LvgHelp.MenuPrint("  -SC      Show category in name. The default is in number.");
        LvgHelp.MenuPrint("  -SI      Show inflection in name. The default is in number.");
        LvgHelp.MenuPrint("  -St:o    Sort outputs by output terms in an alphabetical order.");
        LvgHelp.MenuPrint("  -St:oc   Sort outputs by output terms and category.");
        LvgHelp.MenuPrint("  -St:oci  Sort outputs by output terms, category, and inflection.");
        LvgHelp.MenuPrint("  -t:INT   Define the field to use as the term field.  The default is 1.");
        LvgHelp.MenuPrint("  -ti      Display the filtered input term in the output");
        LvgHelp.MenuPrint("  -v       Returns the current version identification of lvg.");
        LvgHelp.MenuPrint("  -x:STR   Loading an alternative configuration file.");
    }

    public static void OutputFieldHelp(BufferedWriter bw, boolean fileOutput) {
        bw_ = bw;
        fileOutput_ = fileOutput;
        LvgHelp.MenuPrint("  -F:1     Print output field 1 - input term");
        LvgHelp.MenuPrint("  -F:2     Print output field 2 - output term");
        LvgHelp.MenuPrint("  -F:3     Print output field 3 - categories");
        LvgHelp.MenuPrint("  -F:4     Print output field 4 - inflections");
        LvgHelp.MenuPrint("  -F:5     Print output field 5 - flow history");
        LvgHelp.MenuPrint("  -F:6     Print output field 6 - flow number");
        LvgHelp.MenuPrint("  -F:7+    Print output field above 7 - mutate information");
        LvgHelp.MenuPrint("  -F:1:2:5 Print output fields 1, 2, and 5");
    }

    public static void FlowHelp(BufferedWriter bw, boolean fileOutput) {
        bw_ = bw;
        fileOutput_ = fileOutput;
        LvgHelp.MenuPrint("  -f:0       Strip NEC and NOS.");
        LvgHelp.MenuPrint("  -f:a       Generate known acronym expansions.");
        LvgHelp.MenuPrint("  -f:A       Generate known acronyms.");
        LvgHelp.MenuPrint("  -f:An      Generate antiNorm.");
        LvgHelp.MenuPrint("  -f:b       Uninflect the input term.");
        LvgHelp.MenuPrint("  -f:B       Uninflect words.");
        LvgHelp.MenuPrint("  -f:Bn      Normalized Uninflect words.");
        LvgHelp.MenuPrint("  -f:c       Tokenize.");
        LvgHelp.MenuPrint("  -f:ca      Tokenize keep all.");
        LvgHelp.MenuPrint("  -f:ch      Tokenize no hyphens.");
        LvgHelp.MenuPrint("  -f:C       Canonicalize.");
        LvgHelp.MenuPrint("  -f:Ct      Lexical name.");
        LvgHelp.MenuPrint("  -f:d       Generate derivational variants.");
        LvgHelp.MenuPrint("  -f:dc~LONG Generate derivational variants, specifying output categories");
        LvgHelp.MenuPrint("  -f:e       Retrieve uninflected spelling variants.");
        LvgHelp.MenuPrint("  -f:E       Retrieve Eui.");
        LvgHelp.MenuPrint("  -f:f       Filter output.");
        LvgHelp.MenuPrint("  -f:fa      Filter out acronyms and abbreviations.");
        LvgHelp.MenuPrint("  -f:fp      Filter out proper nouns.");
        LvgHelp.MenuPrint("  -f:g       Remove Genitive.");
        LvgHelp.MenuPrint("  -f:G       Generate fruitful variants.");
        LvgHelp.MenuPrint("  -f:Ge      Fruitful variants, enhanced.");
        LvgHelp.MenuPrint("  -f:Gn      Generate known fruitful variants.");
        LvgHelp.MenuPrint("  -f:h       Help menu for flow components (this is it).");
        LvgHelp.MenuPrint("  -f:i       Generate inflectional variants.");
        LvgHelp.MenuPrint("  -f:ici~LONG+LONG  Generate inflectional variants, specifying output categories and inflections");
        LvgHelp.MenuPrint("  -f:is      Generate inflectional variants (simple infl).");
        LvgHelp.MenuPrint("  -f:l       Lowercase the input.");
        LvgHelp.MenuPrint("  -f:L       Retrieve category and inflection.");
        LvgHelp.MenuPrint("  -f:Ln      Retrieve category and inflection from database.");
        LvgHelp.MenuPrint("  -f:Lp      Retrieve category and inflection for all terms begins with the given word.");
        LvgHelp.MenuPrint("  -f:m       Metaphone.");
        LvgHelp.MenuPrint("  -f:n       No operation.");
        LvgHelp.MenuPrint("  -f:nom     Retrieve nominalizations.");
        LvgHelp.MenuPrint("  -f:N       Normalize.");
        LvgHelp.MenuPrint("  -f:N3      LuiNormalize.");
        LvgHelp.MenuPrint("  -f:o       Replace punctuation with space.");
        LvgHelp.MenuPrint("  -f:p       Strip punctuation.");
        LvgHelp.MenuPrint("  -f:P       Strip punctuation, enhanced.");
        LvgHelp.MenuPrint("  -f:q       Strip diacritics.");
        LvgHelp.MenuPrint("  -f:q0      Map symbols to ASCII.");
        LvgHelp.MenuPrint("  -f:q1      Map Unicode to ASCII.");
        LvgHelp.MenuPrint("  -f:q2      Split ligatures.");
        LvgHelp.MenuPrint("  -f:q3      Get Unicode names.");
        LvgHelp.MenuPrint("  -f:q4      Get Unicode synonyms.");
        LvgHelp.MenuPrint("  -f:q5      Norm Unicode to ASCII.");
        LvgHelp.MenuPrint("  -f:q6      Norm Unicode to ASCII with synonym option.");
        LvgHelp.MenuPrint("  -f:q7      Unicode core norm.");
        LvgHelp.MenuPrint("  -f:q8      Strip or map Unicode.");
        LvgHelp.MenuPrint("  -f:r       Recursive synonyms.");
        LvgHelp.MenuPrint("  -f:rs      Remove (s), (es), (ies).");
        LvgHelp.MenuPrint("  -f:R       Recursive derivations.");
        LvgHelp.MenuPrint("  -f:s       Generate spelling variants.");
        LvgHelp.MenuPrint("  -f:S       Syntactic uninvert.");
        LvgHelp.MenuPrint("  -f:Si      Simple inflections.");
        LvgHelp.MenuPrint("  -f:t       Strip stop words.");
        LvgHelp.MenuPrint("  -f:T       Strip ambiguity tags.");
        LvgHelp.MenuPrint("  -f:u       Uninvert phrase around commas.");
        LvgHelp.MenuPrint("  -f:U       Convert output.");
        LvgHelp.MenuPrint("  -f:v       Generate fruitful variants from database.");
        LvgHelp.MenuPrint("  -f:w       Sort by word order.");
        LvgHelp.MenuPrint("  -f:ws~INT  Word size filter.");
        LvgHelp.MenuPrint("  -f:y       Generate synonyms.");
    }

    private static void MenuPrint(String text) {
        try {
            Out.Println(bw_, text, fileOutput_, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

