/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

import gov.nih.nlm.nls.lexCheck.Lib.InflVarsAndAgreements;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lvg.Util.UnicodeUtil;
import java.util.Vector;

public class CheckContent {
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private static Vector<String> glregEnds_ = new Vector();
    private static String errMsg_ = new String();
    private static int duplicateFlag_ = 0;
    private static LexRecord fixedLexRecord_ = null;

    public static int Check(LexRecord lexRecord) {
        int validFlag = CheckContent.Check(lexRecord, false);
        return validFlag;
    }

    public static int Check(LexRecord lexRecord, boolean fixFlag) {
        CheckContent.ResetErrMsg();
        int regFlag = CheckContent.CheckGlRefRegD(lexRecord);
        int duplicateFlag = CheckContent.CheckDuplicates(lexRecord, fixFlag);
        int doublePipeFlag = CheckContent.CheckDoublePipe(lexRecord);
        int nonAsciiCitationFlag = CheckContent.CheckNonAsciiCitation(lexRecord);
        int flag12 = CheckContent.CombineValidFlag(regFlag, duplicateFlag);
        int flag34 = CheckContent.CombineValidFlag(doublePipeFlag, nonAsciiCitationFlag);
        int validFlag = CheckContent.CombineValidFlag(flag12, flag34);
        return validFlag;
    }

    public static void ResetErrMsg() {
        errMsg_ = new String();
    }

    public static void SetErrMsg(String errMsg) {
        errMsg_ = errMsg;
    }

    public static void AppendErrMsg(String errMsg) {
        errMsg_ = errMsg_ + errMsg;
    }

    public static String GetErrMsg() {
        return errMsg_;
    }

    public static LexRecord GetFixedLexRecord() {
        return fixedLexRecord_;
    }

    private static int CheckDuplicates(LexRecord lexRecord, boolean fixFlag) {
        duplicateFlag_ = 0;
        fixedLexRecord_ = new LexRecord();
        fixedLexRecord_.SetLexRecord(lexRecord);
        String eui = lexRecord.GetEui();
        String cat = lexRecord.GetCategory();
        String base = lexRecord.GetBase();
        Vector<String> spellingVars = lexRecord.GetSpellingVars();
        Vector<String> newSpellingVars = CheckContent.CheckDuplicateBaseSpellingVars(spellingVars, eui, base, cat);
        Vector<String> acronyms = lexRecord.GetAcronyms();
        Vector<String> newAcronyms = CheckContent.CheckDuplicates(acronyms, eui, base, cat, "ACR");
        Vector<String> abbreviations = lexRecord.GetAbbreviations();
        Vector<String> newAbbreviations = CheckContent.CheckDuplicates(abbreviations, eui, base, cat, "ABB");
        Vector<String> nominalizations = lexRecord.GetNominalizations();
        Vector<String> newNominalizations = CheckContent.CheckDuplicates(nominalizations, eui, base, cat, "NOM");
        Vector<String> variants = lexRecord.GetVariants();
        Vector<String> newVariants = CheckContent.CheckDuplicates(variants, eui, base, cat, "VAR");
        if (fixFlag) {
            fixedLexRecord_.SetSpellingVars(newSpellingVars);
            fixedLexRecord_.SetAcronyms(newAcronyms);
            fixedLexRecord_.SetAbbreviations(newAbbreviations);
            fixedLexRecord_.SetNominalizations(newNominalizations);
            fixedLexRecord_.SetVariants(newVariants);
        }
        return duplicateFlag_;
    }

    private static Vector<String> CheckDuplicateBaseSpellingVars(Vector<String> spellingVars, String eui, String base, String cat) {
        Vector<String> newSpellingVars = new Vector<String>();
        for (int i = 0; i < spellingVars.size(); ++i) {
            String spellingVar = spellingVars.elementAt(i);
            if (spellingVar.equals(base) || newSpellingVars.contains(spellingVar)) {
                duplicateFlag_ = 2;
                CheckContent.AppendErrMsg("** Content Err (Dup-SP): " + spellingVar + " @ (" + eui + "|" + base + "|" + cat + ")\n");
                continue;
            }
            newSpellingVars.addElement(spellingVar);
        }
        return newSpellingVars;
    }

    private static Vector<String> CheckDuplicates(Vector<String> inItems, String eui, String base, String cat, String typeStr) {
        Vector<String> newItems = new Vector<String>();
        for (int i = 0; i < inItems.size(); ++i) {
            String item = inItems.elementAt(i);
            if (newItems.contains(item)) {
                duplicateFlag_ = 2;
                CheckContent.AppendErrMsg("** Content Err (Dup-" + typeStr + "): " + item + " @ (" + eui + "|" + base + "|" + cat + ")\n");
                continue;
            }
            newItems.addElement(item);
        }
        return newItems;
    }

    private static int CombineValidFlag(int flag1, int flag2) {
        return flag1 > flag2 ? flag1 : flag2;
    }

    private static int CheckNonAsciiCitation(LexRecord lexRecord) {
        int validFlag = 0;
        String base = lexRecord.GetBase();
        String eui = lexRecord.GetEui();
        Vector<String> sv = lexRecord.GetSpellingVars();
        if (!UnicodeUtil.IsAsciiStr(base) && CheckContent.ContainsAsciiTerm(sv)) {
            validFlag = 2;
            CheckContent.AppendErrMsg("** Content Err (non-ASCII citation with ASCII base): @ (" + eui + "|" + base + "|)\n");
        }
        return validFlag;
    }

    private static boolean ContainsAsciiTerm(Vector<String> inList) {
        boolean containFlag = false;
        for (String inItem : inList) {
            if (!UnicodeUtil.IsAsciiStr(inItem)) continue;
            containFlag = true;
            break;
        }
        return containFlag;
    }

    private static int CheckDoublePipe(LexRecord lexRecord) {
        int validFlag = 0;
        String eui = lexRecord.GetEui();
        String base = lexRecord.GetBase();
        Vector<String> acronyms = lexRecord.GetAcronyms();
        int acrFlag = CheckContent.CheckDoublePipe(acronyms, eui, base, "ACR");
        Vector<String> abbreviations = lexRecord.GetAbbreviations();
        int abbFlag = CheckContent.CheckDoublePipe(abbreviations, eui, base, "ABB");
        Vector<String> nominalizations = lexRecord.GetNominalizations();
        int nomFlag = CheckContent.CheckDoublePipe(nominalizations, eui, base, "NOM");
        validFlag = CheckContent.CombineValidFlag(acrFlag, abbFlag);
        validFlag = CheckContent.CombineValidFlag(validFlag, nomFlag);
        return validFlag;
    }

    private static int CheckDoublePipe(Vector<String> inItems, String eui, String base, String typeStr) {
        int validFlag = 0;
        for (String item : inItems) {
            if (item.indexOf("||") < 0) continue;
            CheckContent.AppendErrMsg("** Content Err (Double pipe || in " + typeStr + "): " + item + " @ (" + eui + "|" + base + "|\n");
            validFlag = 2;
        }
        return validFlag;
    }

    private static int CheckGlRefRegD(LexRecord lexRecord) {
        String base = lexRecord.GetBase();
        String eui = lexRecord.GetEui();
        String cat = lexRecord.GetCategory();
        int validFlag = CheckContent.CheckEnding(base, eui, cat, lexRecord);
        Vector<String> sv = lexRecord.GetSpellingVars();
        for (int i = 0; i < sv.size(); ++i) {
            String svBase = sv.elementAt(i);
            validFlag = CheckContent.CombineValidFlag(validFlag, CheckContent.CheckEnding(svBase, eui, cat, lexRecord));
        }
        return validFlag;
    }

    private static int CheckEnding(String base, String eui, String cat, LexRecord lexRecord) {
        String eui2;
        int validFlag = 0;
        String string = eui2 = eui == null ? new String() : eui + "|";
        if (cat.equals("verb")) {
            Vector<String> variants = lexRecord.GetCatEntry().GetVerbEntry().GetVariants();
            validFlag = CheckContent.CheckRegd(base, eui2, cat, variants);
        } else if (cat.equals("noun")) {
            Vector<String> variants = lexRecord.GetCatEntry().GetNounEntry().GetVariants();
            validFlag = CheckContent.CheckGlreg(base, eui2, cat, variants);
        } else if (cat.equals("adj")) {
            Vector<String> variants = lexRecord.GetCatEntry().GetAdjEntry().GetVariants();
            validFlag = CheckContent.CheckRegd(base, eui2, cat, variants);
        }
        return validFlag;
    }

    private static int CheckRegd(String base, String eui, String cat, Vector<String> variants) {
        int validFlag = 0;
        for (int i = 0; i < variants.size(); ++i) {
            String variant = variants.elementAt(i);
            if (!variant.equals("regd")) continue;
            char lastChar = InflVarsAndAgreements.GetLastChar(base);
            char last2Char = InflVarsAndAgreements.GetLast2Char(base);
            String lastCharStr = new Character(lastChar).toString();
            String last2CharStr = new Character(last2Char).toString();
            if (InflVarsAndAgreements.consonants_.contains(lastCharStr) && InflVarsAndAgreements.vowels_.contains(last2CharStr)) continue;
            validFlag = 2;
            CheckContent.AppendErrMsg("** Content Err (RegD): " + variant + " @ (" + eui + "|" + base + "|" + cat + ")\n");
        }
        return validFlag;
    }

    private static int CheckGlreg(String base, String eui, String cat, Vector<String> variants) {
        int validFlag = 0;
        for (int i = 0; i < variants.size(); ++i) {
            String variant = variants.elementAt(i);
            if (!variant.equals("glreg") && !variant.equals("group(glreg)")) continue;
            validFlag = 2;
            for (int j = 0; j < glregEnds_.size(); ++j) {
                String ending = glregEnds_.elementAt(j);
                if (!base.endsWith(ending)) continue;
                validFlag = 0;
                break;
            }
            if (validFlag != 2) continue;
            CheckContent.AppendErrMsg("** Content Err (GlReg): " + variant + " @ (" + eui + "|" + base + "|" + cat + ")\n");
        }
        return validFlag;
    }

    static {
        glregEnds_.addElement("us");
        glregEnds_.addElement("ma");
        glregEnds_.addElement("a");
        glregEnds_.addElement("um");
        glregEnds_.addElement("on");
        glregEnds_.addElement("sis");
        glregEnds_.addElement("is");
        glregEnds_.addElement("men");
        glregEnds_.addElement("ex");
        glregEnds_.addElement("x");
    }
}

