/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

import gov.nih.nlm.nls.lexCheck.Lib.TextLib;
import gov.nih.nlm.nls.lexCheck.Lib.XmlLib;
import java.util.Vector;

public class AdjEntry {
    private Vector<String> variants_ = new Vector();
    private Vector<String> position_ = new Vector();
    private Vector<String> compl_ = new Vector();
    private boolean stative_ = false;
    private Vector<String> nominalization_ = new Vector();

    public AdjEntry() {
        this.variants_ = new Vector();
        this.position_ = new Vector();
        this.compl_ = new Vector();
        this.nominalization_ = new Vector();
    }

    public Vector<String> GetVariants() {
        return this.variants_;
    }

    public Vector<String> GetPosition() {
        return this.position_;
    }

    public Vector<String> GetCompl() {
        return this.compl_;
    }

    public Vector<String> GetNominalization() {
        return this.nominalization_;
    }

    public boolean IsStative() {
        return this.stative_;
    }

    public void AddVariant(String variant) {
        this.variants_.add(variant);
    }

    public void SetVariants(Vector<String> variants) {
        this.variants_ = variants;
    }

    public void AddPosition(String position) {
        this.position_.add(position);
    }

    public void SetPosition(Vector<String> position) {
        this.position_ = position;
    }

    public void AddCompl(String compl) {
        this.compl_.add(compl);
    }

    public void SetCompl(Vector<String> compl) {
        this.compl_ = compl;
    }

    public void AddNominalization(String nominalization) {
        this.nominalization_.add(nominalization);
    }

    public void SetNominalization(Vector<String> nominalization) {
        this.nominalization_ = nominalization;
    }

    public void SetStative(boolean stative) {
        this.stative_ = stative;
    }

    public String GetText() {
        String text = new String();
        text = TextLib.AddToText(text, "variants=", this.variants_, 1);
        text = TextLib.AddToText(text, "position=", this.position_, 1);
        text = TextLib.AddToText(text, "compl=", this.compl_, 1);
        text = TextLib.AddToText(text, "stative", this.stative_, 1);
        text = TextLib.AddToText(text, "nominalization=", this.nominalization_, 1);
        return text;
    }

    public String GetXml() {
        boolean convertFlag = true;
        String xml = new String();
        xml = XmlLib.AddToXml(xml, "<adjEntry>", 2);
        xml = XmlLib.AddToXml(xml, "<variants>", "</variants>", this.variants_, 3, convertFlag);
        if (this.position_ != null) {
            for (int i = 0; i < this.position_.size(); ++i) {
                String positionTag = "<position type=\"" + this.position_.elementAt(i) + "\"/>";
                xml = XmlLib.AddToXml(xml, positionTag, 3);
            }
        }
        xml = XmlLib.AddToXml(xml, "<compl>", "</compl>", this.compl_, 3, convertFlag);
        xml = XmlLib.AddToXml(xml, "<stative/>", this.stative_, 3);
        xml = XmlLib.AddToXml(xml, "<nominalization>", "</nominalization>", this.nominalization_, 3, convertFlag);
        xml = XmlLib.AddToXml(xml, "</adjEntry>", 2);
        return xml;
    }
}

