/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiControl.LexiconDialogControl;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiLib.GridBag;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LexiconDialog
extends JDialog {
    private static final long serialVersionUID = 5L;
    private static boolean initGui_ = false;
    private static JLabel version_ = new JLabel("Data Version:");
    private static JLabel type_ = new JLabel("Data Type:");
    private static int TYPE_SIZE = 2;
    public static final String RB_UTF8 = "UTF-8";
    public static final String RB_ASCII = "ASCII";
    private static JRadioButton[] typeRb_ = new JRadioButton[TYPE_SIZE];
    private static ButtonGroup typeBGroup_ = new ButtonGroup();
    private static JComboBox<String> versionCb_ = null;
    public static final String B_SET = "SET";
    public static final String B_OK = "OK";
    public static final String B_CANCEL = "CANCEL";
    public static final String B_RESET = "RESET";
    public static final String B_DEFAULT = "DEFAULT";
    private static JButton okB_ = new JButton("Ok");
    private static JButton cancelB_ = new JButton("Cancel");
    private static JButton resetB_ = new JButton("Reset");
    private static JButton defaultB_ = new JButton("Default");
    private static boolean initGuiControl_ = false;
    private static LexiconDialogControl lexiconDialogControl_ = null;

    public LexiconDialog(LaFrame owner) {
        LexiconDialog.InitGui(owner);
        LexiconDialog.InitGuiControllers(owner);
    }

    public static JDialog GetDialog(LaFrame owner) {
        LexiconDialog.InitGui(owner);
        LexiconDialog.InitGuiControllers(owner);
        JDialog lexiconDialog = new JDialog();
        lexiconDialog.setModal(true);
        lexiconDialog.setLocationRelativeTo(owner);
        lexiconDialog.setSize(450, 180);
        lexiconDialog.add((Component)LexiconDialog.CreateDataPanel(), "Center");
        lexiconDialog.add((Component)LexiconDialog.CreateButtonPanel(), "South");
        return lexiconDialog;
    }

    public static void SetFont(Font font, Font guiFont) {
        typeRb_[0].setFont(guiFont);
        typeRb_[1].setFont(guiFont);
        versionCb_.setFont(font);
        okB_.setFont(guiFont);
        cancelB_.setFont(guiFont);
        resetB_.setFont(guiFont);
        defaultB_.setFont(guiFont);
    }

    public static int GetStatusOnTypeRadioButton() {
        int type = 0;
        if (typeRb_[1].isSelected()) {
            type = 1;
        }
        return type;
    }

    public static void SetStatusOnTypeRadioButton(int source) {
        switch (source) {
            case 0: {
                typeRb_[0].setSelected(true);
                break;
            }
            case 1: {
                typeRb_[1].setSelected(true);
            }
        }
    }

    public static String GetVersionOnComboBox() {
        return (String)versionCb_.getSelectedItem();
    }

    public static void SetVersionOnComboBox(String version) {
        versionCb_.setSelectedItem(version);
    }

    private static JPanel CreateDataPanel() {
        JPanel dataP = new JPanel();
        dataP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Lexicon Version: "));
        dataP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        gbc.anchor = 17;
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        dataP.add((Component)version_, gbc);
        GridBag.SetPosSize(gbc, 0, 1, 1, 1);
        dataP.add((Component)type_, gbc);
        GridBag.SetPosSize(gbc, 1, 0, 1, 1);
        dataP.add(versionCb_, gbc);
        for (int i = 0; i < TYPE_SIZE; ++i) {
            GridBag.SetPosSize(gbc, i + 1, 1, 1, 1);
            dataP.add((Component)typeRb_[i], gbc);
        }
        return dataP;
    }

    private static JPanel CreateButtonPanel() {
        JPanel buttonP = new JPanel();
        buttonP.add(okB_);
        buttonP.add(cancelB_);
        buttonP.add(resetB_);
        buttonP.add(defaultB_);
        return buttonP;
    }

    private static void InitGui(LaFrame owner) {
        if (!initGui_) {
            int firstVerion = owner.GetLaObj().GetConfigObj().GetFirstVersion();
            int latestVerion = owner.GetLaObj().GetConfigObj().GetLatestVersion();
            Vector<String> versions = new Vector<String>();
            for (int i = firstVerion; i <= latestVerion; ++i) {
                versions.add(String.valueOf(i));
            }
            versionCb_ = new JComboBox(versions);
            versionCb_.setEditable(true);
            versionCb_.setSelectedItem(latestVerion);
            initGui_ = true;
        }
    }

    private static void InitGuiControllers(LaFrame owner) {
        if (!initGuiControl_) {
            lexiconDialogControl_ = new LexiconDialogControl(owner);
            for (int i = 0; i < TYPE_SIZE; ++i) {
                typeRb_[i].addActionListener(lexiconDialogControl_);
            }
            okB_.setActionCommand(B_OK);
            cancelB_.setActionCommand(B_CANCEL);
            resetB_.setActionCommand(B_RESET);
            defaultB_.setActionCommand(B_DEFAULT);
            okB_.addActionListener(lexiconDialogControl_);
            cancelB_.addActionListener(lexiconDialogControl_);
            resetB_.addActionListener(lexiconDialogControl_);
            defaultB_.addActionListener(lexiconDialogControl_);
            initGuiControl_ = true;
        }
    }

    static {
        LexiconDialog.typeRb_[0] = new JRadioButton(RB_UTF8);
        LexiconDialog.typeRb_[1] = new JRadioButton(RB_ASCII);
        typeRb_[0].setSelected(true);
        for (int i = 0; i < TYPE_SIZE; ++i) {
            typeBGroup_.add(typeRb_[i]);
        }
    }
}

