/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiControl.LaMenuBarControl;
import java.awt.Font;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class LaMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 5L;
    public static final String LEXACCESS_INPUT = "Input";
    public static final String LEXACCESS_OUTPUT = "Output";
    public static final String LEXACCESS_EXIT = "Exit";
    public static final String BY_TERM_EUI = "By Term/EUI";
    public static final String BY_BASE = "By Base";
    public static final String BY_CATEGORY = "By Category";
    public static final String OPTION_GLOBAL = "Global Behavior";
    public static final String OPTION_OUTPUT = "Output Filter";
    public static final String OPTION_LEXICON_VERSION = "Lexicon Version";
    public static final String PREFERENCE_BOLD = "Bold";
    public static final String PREFERENCE_ITALIC = "Italic";
    public static final String PREFERENCE_FONT_DEFAULT = "Default Font";
    public static final String PREFERENCE_FONT_SIZE = "Font Size";
    public static final String PREFERENCE_FONT_SERIF = "Serif";
    public static final String PREFERENCE_FONT_SANSSERIF = "SansSerif";
    public static final String PREFERENCE_FONT_MONOSPACED = "Monospaced";
    public static final String PREFERENCE_FONT_DIALOG = "Dialog";
    public static final String PREFERENCE_FONT_DIALOGINPUT = "DialogInput";
    public static final String PREFERENCE_LAF_SYSTEM = "System";
    public static final String PREFERENCE_LAF_METAL = "Metal";
    public static final String PREFERENCE_LAF_MOTIF = "Motif";
    public static final String PREFERENCE_LAF_WINDOW = "Window";
    public static final String PREFERENCE_LAF_GTK = "GTK";
    public static final String HELP_ABOUT = "About";
    public static final String HELP_DOCUMENTS = "Documents";
    private JCheckBoxMenuItem boldItem_ = new JCheckBoxMenuItem("Bold", false);
    private JCheckBoxMenuItem italicItem_ = new JCheckBoxMenuItem("Italic", false);
    private JRadioButtonMenuItem dialogItem_ = new JRadioButtonMenuItem("Dialog");
    private JRadioButtonMenuItem dialogInputItem_ = new JRadioButtonMenuItem("DialogInput");
    private JRadioButtonMenuItem monospacedItem_ = new JRadioButtonMenuItem("Monospaced");
    private JRadioButtonMenuItem sansSerifItem_ = new JRadioButtonMenuItem("SansSerif");
    private JRadioButtonMenuItem serifItem_ = new JRadioButtonMenuItem("Serif");
    private JRadioButtonMenuItem item8_ = new JRadioButtonMenuItem("8");
    private JRadioButtonMenuItem item10_ = new JRadioButtonMenuItem("10");
    private JRadioButtonMenuItem item12_ = new JRadioButtonMenuItem("12");
    private JRadioButtonMenuItem item14_ = new JRadioButtonMenuItem("14");
    private JRadioButtonMenuItem item16_ = new JRadioButtonMenuItem("16");
    private JRadioButtonMenuItem item18_ = new JRadioButtonMenuItem("18");
    private JRadioButtonMenuItem item20_ = new JRadioButtonMenuItem("20");
    private JRadioButtonMenuItem item24_ = new JRadioButtonMenuItem("24");
    private JRadioButtonMenuItem item28_ = new JRadioButtonMenuItem("28");
    private JRadioButtonMenuItem item32_ = new JRadioButtonMenuItem("32");
    private static LaMenuBarControl laMenuBarControl_ = null;
    private static JMenu lexAccessMenu_ = new JMenu("LexAccess");
    private static JMenu optionsMenu_ = new JMenu("Options");
    private static JMenu preferencesMenu_ = new JMenu("Preferences");
    private static JMenu helpMenu_ = new JMenu("Help");
    private static JMenuItem[] laItems_ = new JMenuItem[4];
    private static JMenuItem[] searchItems_ = new JMenuItem[3];
    private static JMenuItem[] optionsItems_ = new JMenuItem[6];
    private static JMenuItem[] sizeItems_ = new JMenuItem[10];
    private static JMenuItem[] fontItems_ = new JMenuItem[5];
    private static JMenuItem[] lafItems_ = new JMenuItem[5];
    private static JMenuItem[] preferenceItems_ = new JMenuItem[7];
    private static JMenuItem[] helpItems_ = new JMenuItem[2];

    public LaMenuBar(LaFrame owner) {
        laMenuBarControl_ = new LaMenuBarControl(owner);
        this.InitLexAccessMenu();
        this.InitOptionsMenu();
        this.InitPreferencesMenu();
        this.InitHelpMenu();
        this.add(lexAccessMenu_);
        this.add(optionsMenu_);
        this.add(preferencesMenu_);
        this.add(helpMenu_);
    }

    public static void SetFont(Font font, Font guiFont) {
        lexAccessMenu_.setFont(guiFont);
        LaMenuBar.SetFont(laItems_, guiFont);
        optionsMenu_.setFont(guiFont);
        LaMenuBar.SetFont(searchItems_, guiFont);
        LaMenuBar.SetFont(optionsItems_, guiFont);
        preferencesMenu_.setFont(guiFont);
        LaMenuBar.SetFont(sizeItems_, guiFont);
        LaMenuBar.SetFont(fontItems_, guiFont);
        LaMenuBar.SetFont(lafItems_, guiFont);
        LaMenuBar.SetFont(preferenceItems_, guiFont);
        helpMenu_.setFont(guiFont);
        LaMenuBar.SetFont(helpItems_, guiFont);
    }

    public void SetDefaultFontMenu() {
        this.boldItem_.setState(false);
        this.italicItem_.setState(false);
        this.dialogItem_.setSelected(true);
        this.item12_.setSelected(true);
    }

    private static void SetFont(JMenuItem[] menuItems, Font font) {
        for (int i = 0; i < menuItems.length; ++i) {
            if (menuItems[i] == null) continue;
            menuItems[i].setFont(font);
        }
    }

    private void InitLexAccessMenu() {
        lexAccessMenu_.setMnemonic('L');
        JMenuItem inputItem = new JMenuItem(LEXACCESS_INPUT);
        JMenuItem outputItem = new JMenuItem(LEXACCESS_OUTPUT);
        JMenuItem exitItem = new JMenuItem(LEXACCESS_EXIT);
        inputItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        outputItem.setAccelerator(KeyStroke.getKeyStroke(85, 8));
        exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        LaMenuBar.laItems_[0] = inputItem;
        LaMenuBar.laItems_[1] = outputItem;
        LaMenuBar.laItems_[2] = null;
        LaMenuBar.laItems_[3] = exitItem;
        this.AddItemToMenu(lexAccessMenu_, laItems_);
    }

    private void InitOptionsMenu() {
        optionsMenu_.setMnemonic('O');
        JRadioButtonMenuItem byTermEuiItem = new JRadioButtonMenuItem(BY_TERM_EUI);
        JRadioButtonMenuItem byBaseItem = new JRadioButtonMenuItem(BY_BASE);
        JRadioButtonMenuItem byCategoryItem = new JRadioButtonMenuItem(BY_CATEGORY);
        byTermEuiItem.setSelected(true);
        byTermEuiItem.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        byBaseItem.setAccelerator(KeyStroke.getKeyStroke(66, 8));
        byCategoryItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        ButtonGroup searchGroup = new ButtonGroup();
        searchGroup.add(byTermEuiItem);
        searchGroup.add(byBaseItem);
        searchGroup.add(byCategoryItem);
        LaMenuBar.searchItems_[0] = byTermEuiItem;
        LaMenuBar.searchItems_[1] = byBaseItem;
        LaMenuBar.searchItems_[2] = byCategoryItem;
        JMenuItem gloablItem = new JMenuItem(OPTION_GLOBAL);
        JMenuItem outputItem = new JMenuItem(OPTION_OUTPUT);
        JMenuItem lexiconVersionItem = new JMenuItem(OPTION_LEXICON_VERSION);
        gloablItem.setAccelerator(KeyStroke.getKeyStroke(71, 8));
        outputItem.setAccelerator(KeyStroke.getKeyStroke(70, 8));
        lexiconVersionItem.setAccelerator(KeyStroke.getKeyStroke(86, 8));
        LaMenuBar.optionsItems_[0] = this.MakeMenu("Search Mode", searchItems_);
        LaMenuBar.optionsItems_[1] = null;
        LaMenuBar.optionsItems_[2] = gloablItem;
        LaMenuBar.optionsItems_[3] = outputItem;
        LaMenuBar.optionsItems_[4] = null;
        LaMenuBar.optionsItems_[5] = lexiconVersionItem;
        this.AddItemToMenu(optionsMenu_, optionsItems_);
    }

    private void InitPreferencesMenu() {
        preferencesMenu_.setMnemonic('P');
        this.dialogItem_.setSelected(true);
        ButtonGroup fontGroup = new ButtonGroup();
        fontGroup.add(this.dialogItem_);
        fontGroup.add(this.dialogInputItem_);
        fontGroup.add(this.monospacedItem_);
        fontGroup.add(this.sansSerifItem_);
        fontGroup.add(this.serifItem_);
        LaMenuBar.fontItems_[0] = this.dialogItem_;
        LaMenuBar.fontItems_[1] = this.dialogInputItem_;
        LaMenuBar.fontItems_[2] = this.monospacedItem_;
        LaMenuBar.fontItems_[3] = this.sansSerifItem_;
        LaMenuBar.fontItems_[4] = this.serifItem_;
        JMenuItem sizeItem = new JMenuItem(PREFERENCE_FONT_SIZE);
        this.item12_.setSelected(true);
        ButtonGroup sizeGroup = new ButtonGroup();
        sizeGroup.add(this.item8_);
        sizeGroup.add(this.item10_);
        sizeGroup.add(this.item12_);
        sizeGroup.add(this.item14_);
        sizeGroup.add(this.item16_);
        sizeGroup.add(this.item18_);
        sizeGroup.add(this.item20_);
        sizeGroup.add(this.item24_);
        sizeGroup.add(this.item28_);
        sizeGroup.add(this.item32_);
        LaMenuBar.sizeItems_[0] = this.item8_;
        LaMenuBar.sizeItems_[1] = this.item10_;
        LaMenuBar.sizeItems_[2] = this.item12_;
        LaMenuBar.sizeItems_[3] = this.item14_;
        LaMenuBar.sizeItems_[4] = this.item16_;
        LaMenuBar.sizeItems_[5] = this.item18_;
        LaMenuBar.sizeItems_[6] = this.item20_;
        LaMenuBar.sizeItems_[7] = this.item24_;
        LaMenuBar.sizeItems_[8] = this.item28_;
        LaMenuBar.sizeItems_[9] = this.item32_;
        JMenuItem defaultItem = new JMenuItem(PREFERENCE_FONT_DEFAULT);
        JRadioButtonMenuItem systemItem = new JRadioButtonMenuItem(PREFERENCE_LAF_SYSTEM);
        JRadioButtonMenuItem metalItem = new JRadioButtonMenuItem(PREFERENCE_LAF_METAL);
        JRadioButtonMenuItem motifItem = new JRadioButtonMenuItem(PREFERENCE_LAF_MOTIF);
        JRadioButtonMenuItem windowItem = new JRadioButtonMenuItem(PREFERENCE_LAF_WINDOW);
        JRadioButtonMenuItem gtkItem = new JRadioButtonMenuItem(PREFERENCE_LAF_GTK);
        metalItem.setSelected(true);
        ButtonGroup lafGroup = new ButtonGroup();
        lafGroup.add(systemItem);
        lafGroup.add(metalItem);
        lafGroup.add(motifItem);
        lafGroup.add(windowItem);
        lafGroup.add(gtkItem);
        LaMenuBar.lafItems_[0] = systemItem;
        LaMenuBar.lafItems_[1] = metalItem;
        LaMenuBar.lafItems_[2] = motifItem;
        LaMenuBar.lafItems_[3] = windowItem;
        LaMenuBar.lafItems_[4] = gtkItem;
        LaMenuBar.preferenceItems_[0] = this.boldItem_;
        LaMenuBar.preferenceItems_[1] = this.italicItem_;
        LaMenuBar.preferenceItems_[2] = this.MakeMenu("Font", fontItems_);
        LaMenuBar.preferenceItems_[3] = this.MakeMenu("Size", sizeItems_);
        LaMenuBar.preferenceItems_[4] = defaultItem;
        LaMenuBar.preferenceItems_[5] = null;
        LaMenuBar.preferenceItems_[6] = this.MakeMenu("Look and Feel", lafItems_);
        this.AddItemToMenu(preferencesMenu_, preferenceItems_);
    }

    private void InitHelpMenu() {
        helpMenu_.setMnemonic('H');
        JMenuItem aboutItem = new JMenuItem(HELP_ABOUT);
        JMenuItem docItem = new JMenuItem(HELP_DOCUMENTS);
        LaMenuBar.helpItems_[0] = aboutItem;
        LaMenuBar.helpItems_[1] = docItem;
        aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        docItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.AddItemToMenu(helpMenu_, helpItems_);
    }

    private void AddItemToMenu(JMenu menu, JMenuItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) {
                menu.addSeparator();
                continue;
            }
            items[i].addActionListener(laMenuBarControl_);
            menu.add(items[i]);
        }
    }

    private JMenu MakeMenu(Object parent, Object[] items) {
        JMenu menu = null;
        if (parent instanceof JMenu) {
            menu = (JMenu)parent;
        } else if (parent instanceof String) {
            menu = new JMenu((String)parent);
        } else {
            return null;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) {
                menu.addSeparator();
                continue;
            }
            menu.add(this.MakeMenuItem(items[i]));
        }
        return menu;
    }

    private JMenuItem MakeMenuItem(Object item) {
        JMenuItem mi = null;
        if (item instanceof String) {
            mi = new JMenuItem((String)item);
        } else if (item instanceof JMenuItem) {
            mi = (JMenuItem)item;
        } else {
            return null;
        }
        mi.addActionListener(laMenuBarControl_);
        return mi;
    }
}

