/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.MainPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiControl.ByCategoryPanelControl;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiLib.GridBag;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ByCategoryPanel
extends JPanel
implements Cloneable {
    private static final long serialVersionUID = 5L;
    private static boolean initGui_ = false;
    public static final int CATEGORY_NUM = 11;
    public static final String B_IN_SEARCH = "IN_SEARCH";
    public static final String B_CLEAR_ALL = "CLEAR_ALL";
    public static final String B_SELECT_ALL = "SELECT_ALL";
    public static final String B_SEARCH = "SEARCH";
    public static final String B_LEXICON = "LEXICON";
    public static final String B_RESET = "RESET";
    public static final String B_EXIT = "EXIT";
    private static boolean initGuiControl_ = false;
    private static ByCategoryPanelControl byCategoryPanelControl_ = null;
    private static JPanel inputScreenP_ = null;
    private static JPanel inputFileP_ = null;
    private static TitledBorder inputScreenBorder_ = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Please select categories: ");
    private static JCheckBox[] cbCategory_ = new JCheckBox[11];
    public static final long[] CATEGORY_VALUE = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L};
    private static JButton inSearchB_ = new JButton("Search");
    private static JButton clearAllB_ = new JButton("Clear All");
    private static JButton selectAllB_ = new JButton("Select All");
    private static TitledBorder inputFileBorder_ = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Read category from file: ");
    private static JTextField fileField_ = new JTextField(40);
    private static JLabel fileLabel_ = new JLabel("Reading categories from file is not allowed! Please set the input to screen.");
    private static TitledBorder outputBorder_ = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Search Results: ");
    private static JTextArea laOutputs_ = new JTextArea();
    private static JButton searchB_ = new JButton("Search");
    private static JButton lexiconB_ = new JButton("Lexicon");
    private static JButton resetB_ = new JButton("Reset");
    private static JButton exitB_ = new JButton("Exit");

    public ByCategoryPanel(LaFrame owner) {
        ByCategoryPanel.InitGui(owner);
        ByCategoryPanel.InitGuiControllers(owner);
    }

    public static JPanel CreateCategoryPanel(LaFrame owner) {
        ByCategoryPanel.InitGui(owner);
        ByCategoryPanel.InitGuiControllers(owner);
        JPanel categoryP = new JPanel();
        inputScreenP_ = ByCategoryPanel.CreateInputScreenPanel();
        inputFileP_ = ByCategoryPanel.CreateInputFilePanel();
        ByCategoryPanel.UpdateInputPanel(0);
        JPanel outputP = ByCategoryPanel.CreateOutputPanel();
        JPanel buttonP = ByCategoryPanel.CreateButtonPanel();
        categoryP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 5, 10, 5);
        gbc.fill = 2;
        GridBag.SetWeight(gbc, 100, 0);
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        categoryP.add((Component)inputScreenP_, gbc);
        GridBag.SetPosSize(gbc, 0, 1, 1, 1);
        categoryP.add((Component)inputFileP_, gbc);
        GridBag.SetPosSize(gbc, 0, 2, 1, 1);
        categoryP.add((Component)outputP, gbc);
        GridBag.SetPosSize(gbc, 0, 3, 1, 1);
        categoryP.add((Component)buttonP, gbc);
        return categoryP;
    }

    public static void UpdateInputPanel(int source) {
        if (source == 0) {
            inputScreenP_.setVisible(true);
            inputFileP_.setVisible(false);
            searchB_.setEnabled(true);
        } else if (source == 1) {
            inputScreenP_.setVisible(false);
            inputFileP_.setVisible(true);
            searchB_.setEnabled(false);
        }
    }

    public static void SetFileField(String inFile) {
        fileField_.setText(inFile);
    }

    public static void SetFont(Font font, Font guiFont) {
        inputScreenBorder_.setTitleFont(guiFont);
        inSearchB_.setFont(guiFont);
        clearAllB_.setFont(guiFont);
        selectAllB_.setFont(guiFont);
        for (int i = 0; i < 11; ++i) {
            cbCategory_[i].setFont(guiFont);
        }
        inputFileBorder_.setTitleFont(guiFont);
        fileField_.setFont(font);
        fileLabel_.setFont(guiFont);
        outputBorder_.setTitleFont(guiFont);
        laOutputs_.setFont(font);
        searchB_.setFont(guiFont);
        lexiconB_.setFont(guiFont);
        resetB_.setFont(guiFont);
        exitB_.setFont(guiFont);
    }

    public static JTextArea GetLaOutputs() {
        return laOutputs_;
    }

    public static void ClearAllCategory() {
        for (int i = 0; i < 11; ++i) {
            cbCategory_[i].setSelected(false);
        }
    }

    public static void SelectAllCategory() {
        for (int i = 0; i < 11; ++i) {
            cbCategory_[i].setSelected(true);
        }
    }

    public static long GetCategory() {
        long category = 0L;
        for (int i = 0; i < 11; ++i) {
            if (!cbCategory_[i].isSelected()) continue;
            category = Bit.Add(category, CATEGORY_VALUE[i]);
        }
        return category;
    }

    private static JPanel CreateInputScreenPanel() {
        int i;
        JPanel inputP = new JPanel();
        inputP.setLayout(new GridBagLayout());
        inputP.setBorder(inputScreenBorder_);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        gbc.anchor = 17;
        GridBag.SetWeight(gbc, 100, 100);
        JPanel categoryP = new JPanel();
        categoryP.setLayout(new GridBagLayout());
        for (i = 0; i < 6; ++i) {
            GridBag.SetPosSize(gbc, i, 0, 1, 1);
            categoryP.add((Component)cbCategory_[i], gbc);
        }
        for (i = 6; i < 11; ++i) {
            int ii = i - 6;
            GridBag.SetPosSize(gbc, ii, 1, 1, 1);
            categoryP.add((Component)cbCategory_[i], gbc);
        }
        JPanel searchP = new JPanel();
        gbc.anchor = 10;
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        searchP.add(inSearchB_);
        GridBag.SetPosSize(gbc, 1, 0, 1, 1);
        searchP.add(selectAllB_);
        GridBag.SetPosSize(gbc, 2, 0, 1, 1);
        searchP.add(clearAllB_);
        gbc.anchor = 10;
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        inputP.add((Component)categoryP, gbc);
        GridBag.SetPosSize(gbc, 0, 1, 1, 1);
        inputP.add((Component)searchP, gbc);
        return inputP;
    }

    private static JPanel CreateInputFilePanel() {
        JPanel inputP = new JPanel();
        inputP.setLayout(new GridBagLayout());
        inputP.setBorder(inputFileBorder_);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        GridBag.SetWeight(gbc, 100, 100);
        gbc.anchor = 17;
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        inputP.add((Component)fileField_, gbc);
        gbc.anchor = 13;
        GridBag.SetPosSize(gbc, 0, 1, 1, 1);
        inputP.add((Component)fileLabel_, gbc);
        return inputP;
    }

    private static JPanel CreateOutputPanel() {
        JPanel outputP = new JPanel();
        JScrollPane scrollPane = new JScrollPane(laOutputs_);
        outputP.setLayout(new GridBagLayout());
        outputP.setBorder(outputBorder_);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 2;
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 1, 1, 5, 1);
        outputP.add((Component)scrollPane, gbc);
        return outputP;
    }

    private static JPanel CreateButtonPanel() {
        JPanel buttonP = new JPanel();
        buttonP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        gbc.anchor = 10;
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        buttonP.add((Component)searchB_, gbc);
        GridBag.SetPosSize(gbc, 1, 0, 1, 1);
        buttonP.add((Component)lexiconB_, gbc);
        GridBag.SetPosSize(gbc, 2, 0, 1, 1);
        buttonP.add((Component)resetB_, gbc);
        GridBag.SetPosSize(gbc, 3, 0, 1, 1);
        buttonP.add((Component)exitB_, gbc);
        return buttonP;
    }

    private static void InitGui(LaFrame owner) {
        if (!initGui_) {
            laOutputs_.setText(MainPanel.GetBannerStr(owner));
            initGui_ = true;
        }
    }

    private static void InitGuiControllers(LaFrame owner) {
        if (!initGuiControl_) {
            byCategoryPanelControl_ = new ByCategoryPanelControl(owner);
            for (int i = 0; i < 11; ++i) {
                cbCategory_[i].addActionListener(byCategoryPanelControl_);
            }
            inSearchB_.setActionCommand(B_IN_SEARCH);
            clearAllB_.setActionCommand(B_CLEAR_ALL);
            selectAllB_.setActionCommand(B_SELECT_ALL);
            inSearchB_.addActionListener(byCategoryPanelControl_);
            clearAllB_.addActionListener(byCategoryPanelControl_);
            selectAllB_.addActionListener(byCategoryPanelControl_);
            searchB_.setActionCommand(B_SEARCH);
            lexiconB_.setActionCommand(B_LEXICON);
            resetB_.setActionCommand(B_RESET);
            exitB_.setActionCommand(B_EXIT);
            searchB_.addActionListener(byCategoryPanelControl_);
            lexiconB_.addActionListener(byCategoryPanelControl_);
            resetB_.addActionListener(byCategoryPanelControl_);
            exitB_.addActionListener(byCategoryPanelControl_);
            initGuiControl_ = true;
        }
    }

    static {
        fileField_.setEditable(false);
        ByCategoryPanel.cbCategory_[0] = new JCheckBox("Adj");
        ByCategoryPanel.cbCategory_[1] = new JCheckBox("Adv");
        ByCategoryPanel.cbCategory_[2] = new JCheckBox("Aux");
        ByCategoryPanel.cbCategory_[3] = new JCheckBox("Compl");
        ByCategoryPanel.cbCategory_[4] = new JCheckBox("Conj");
        ByCategoryPanel.cbCategory_[5] = new JCheckBox("Det");
        ByCategoryPanel.cbCategory_[6] = new JCheckBox("Modal");
        ByCategoryPanel.cbCategory_[7] = new JCheckBox("Noun");
        ByCategoryPanel.cbCategory_[8] = new JCheckBox("Prep");
        ByCategoryPanel.cbCategory_[9] = new JCheckBox("Pron");
        ByCategoryPanel.cbCategory_[10] = new JCheckBox("Verb");
        laOutputs_.setColumns(40);
        laOutputs_.setRows(25);
        laOutputs_.setEditable(false);
    }
}

