/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.MainPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiControl.ByBasePanelControl;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiLib.GridBag;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ByBasePanel
extends JPanel
implements Cloneable {
    private static final long serialVersionUID = 5L;
    private static boolean initGui_ = false;
    private static final int SEARCH_NUM = 4;
    public static final int EXACT_MATCH = 0;
    public static final int BEGIN_WITH = 1;
    public static final int CONTAIN = 2;
    public static final int END_WITH = 3;
    public static final String B_SCREEN_SEARCH = "SCREEN_SEARCH";
    public static final String B_CLEAR = "CLEAR";
    public static final String B_FILE_SEARCH = "FILE_SEARCH";
    public static final String RB_EXACT_MATCH = "EXACT_MATCH";
    public static final String RB_BEGIN_WITH = "BEGIN_WITH";
    public static final String RB_CONTAIN = "CONTAIN";
    public static final String RB_END_WITH = "END_WITH";
    public static final String B_SEARCH = "SEARCH";
    public static final String B_LEXICON = "LEXICON";
    public static final String B_RESET = "RESET";
    public static final String B_EXIT = "EXIT";
    private static boolean initGuiControl_ = false;
    private static ByBasePanelControl byBasePanelControl_ = null;
    private static JPanel inputP_ = null;
    private static JPanel inputScreenP_ = null;
    private static JPanel inputFileP_ = null;
    private static TitledBorder inputScreenBorder_ = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Please input the base: ");
    private static JTextField baseField_ = new JTextField(35);
    private static JButton screenSearchB_ = new JButton("Search");
    private static JButton clearB_ = new JButton("Clear");
    private static TitledBorder inputFileBorder_ = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Read base from file: ");
    private static JTextField fileField_ = new JTextField(40);
    private static JButton fileSearchB_ = new JButton("Search");
    private static JRadioButton[] rbSearch_ = new JRadioButton[4];
    private static ButtonGroup rbSearchGroup_ = new ButtonGroup();
    private static TitledBorder outputBorder_ = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Search Results: ");
    private static JTextArea laOutputs_ = new JTextArea();
    private static JButton searchB_ = new JButton("Search");
    private static JButton lexiconB_ = new JButton("Lexicon");
    private static JButton resetB_ = new JButton("Reset");
    private static JButton exitB_ = new JButton("Exit");

    public ByBasePanel(LaFrame owner) {
        ByBasePanel.InitGui(owner);
        ByBasePanel.InitGuiControllers(owner);
    }

    public static JPanel CreateBasePanel(LaFrame owner) {
        ByBasePanel.InitGui(owner);
        ByBasePanel.InitGuiControllers(owner);
        JPanel baseP = new JPanel();
        inputScreenP_ = ByBasePanel.CreateInputScreenPanel();
        inputFileP_ = ByBasePanel.CreateInputFilePanel();
        inputP_ = ByBasePanel.CreateInputPanel(owner);
        ByBasePanel.UpdateInputPanel(0);
        JPanel outputP = ByBasePanel.CreateOutputPanel();
        JPanel buttonP = ByBasePanel.CreateButtonPanel();
        baseP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 5, 10, 5);
        gbc.fill = 2;
        GridBag.SetWeight(gbc, 100, 0);
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        baseP.add((Component)inputP_, gbc);
        GridBag.SetPosSize(gbc, 0, 1, 1, 1);
        baseP.add((Component)outputP, gbc);
        GridBag.SetPosSize(gbc, 0, 2, 1, 1);
        baseP.add((Component)buttonP, gbc);
        return baseP;
    }

    public static void UpdateInputPanel(int source) {
        if (source == 0) {
            inputP_.setBorder(inputScreenBorder_);
            inputScreenP_.setVisible(true);
            inputFileP_.setVisible(false);
        } else if (source == 1) {
            inputP_.setBorder(inputFileBorder_);
            inputScreenP_.setVisible(false);
            inputFileP_.setVisible(true);
        }
    }

    public static void SetFileField(String inFile) {
        fileField_.setText(inFile);
    }

    public static void SetFont(Font font, Font guiFont) {
        inputScreenBorder_.setTitleFont(guiFont);
        baseField_.setFont(font);
        screenSearchB_.setFont(guiFont);
        clearB_.setFont(guiFont);
        inputFileBorder_.setTitleFont(guiFont);
        fileField_.setFont(font);
        fileSearchB_.setFont(guiFont);
        rbSearch_[0].setFont(guiFont);
        rbSearch_[1].setFont(guiFont);
        rbSearch_[2].setFont(guiFont);
        rbSearch_[3].setFont(guiFont);
        outputBorder_.setTitleFont(guiFont);
        laOutputs_.setFont(font);
        searchB_.setFont(guiFont);
        lexiconB_.setFont(guiFont);
        resetB_.setFont(guiFont);
        exitB_.setFont(guiFont);
    }

    public static JTextField GetBaseField() {
        return baseField_;
    }

    public static JTextArea GetLaOutputs() {
        return laOutputs_;
    }

    public static void ResetByBase() {
        rbSearch_[0].setSelected(true);
    }

    private static JPanel CreateInputPanel(LaFrame owner) {
        JPanel inputP = new JPanel();
        inputP.setLayout(new GridBagLayout());
        int source = owner.GetLaObj().GetInSource();
        if (source == 0) {
            inputP.setBorder(inputScreenBorder_);
        } else if (source == 1) {
            inputP.setBorder(inputFileBorder_);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 0;
        gbc.anchor = 17;
        GridBag.SetWeight(gbc, 100, 100);
        JPanel searchP = new JPanel();
        searchP.setLayout(new GridBagLayout());
        gbc.anchor = 10;
        for (int i = 0; i < 4; ++i) {
            GridBag.SetPosSize(gbc, i, 0, 1, 1);
            searchP.add((Component)rbSearch_[i], gbc);
        }
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        inputP.add((Component)inputScreenP_, gbc);
        GridBag.SetPosSize(gbc, 0, 1, 1, 1);
        inputP.add((Component)inputFileP_, gbc);
        GridBag.SetPosSize(gbc, 0, 2, 1, 1);
        inputP.add((Component)searchP, gbc);
        return inputP;
    }

    private static JPanel CreateInputScreenPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 0;
        gbc.anchor = 17;
        GridBag.SetWeight(gbc, 100, 100);
        JPanel baseP = new JPanel();
        baseP.setLayout(new GridBagLayout());
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        baseP.add((Component)baseField_, gbc);
        gbc.anchor = 13;
        GridBag.SetPosSize(gbc, 1, 0, 1, 1);
        baseP.add((Component)screenSearchB_, gbc);
        gbc.anchor = 10;
        GridBag.SetPosSize(gbc, 2, 0, 1, 1);
        baseP.add((Component)clearB_, gbc);
        return baseP;
    }

    private static JPanel CreateInputFilePanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 0;
        gbc.anchor = 17;
        GridBag.SetWeight(gbc, 100, 100);
        JPanel baseP = new JPanel();
        baseP.setLayout(new GridBagLayout());
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        baseP.add((Component)fileField_, gbc);
        gbc.anchor = 13;
        GridBag.SetPosSize(gbc, 1, 0, 1, 1);
        baseP.add((Component)fileSearchB_, gbc);
        return baseP;
    }

    private static JPanel CreateOutputPanel() {
        JPanel outputP = new JPanel();
        JScrollPane scrollPane = new JScrollPane(laOutputs_);
        outputP.setLayout(new GridBagLayout());
        outputP.setBorder(outputBorder_);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 2;
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 1, 1, 5, 1);
        outputP.add((Component)scrollPane, gbc);
        return outputP;
    }

    private static JPanel CreateButtonPanel() {
        JPanel buttonP = new JPanel();
        buttonP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        gbc.anchor = 10;
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        buttonP.add((Component)searchB_, gbc);
        GridBag.SetPosSize(gbc, 1, 0, 1, 1);
        buttonP.add((Component)lexiconB_, gbc);
        GridBag.SetPosSize(gbc, 2, 0, 1, 1);
        buttonP.add((Component)resetB_, gbc);
        GridBag.SetPosSize(gbc, 3, 0, 1, 1);
        buttonP.add((Component)exitB_, gbc);
        return buttonP;
    }

    private static void InitGui(LaFrame owner) {
        if (!initGui_) {
            laOutputs_.setText(MainPanel.GetBannerStr(owner));
            initGui_ = true;
        }
    }

    private static void InitGuiControllers(LaFrame owner) {
        if (!initGuiControl_) {
            byBasePanelControl_ = new ByBasePanelControl(owner);
            screenSearchB_.setActionCommand(B_SCREEN_SEARCH);
            clearB_.setActionCommand(B_CLEAR);
            fileSearchB_.setActionCommand(B_FILE_SEARCH);
            screenSearchB_.addActionListener(byBasePanelControl_);
            clearB_.addActionListener(byBasePanelControl_);
            fileSearchB_.addActionListener(byBasePanelControl_);
            rbSearch_[0].setActionCommand(RB_EXACT_MATCH);
            rbSearch_[1].setActionCommand(RB_BEGIN_WITH);
            rbSearch_[2].setActionCommand(RB_CONTAIN);
            rbSearch_[3].setActionCommand(RB_END_WITH);
            for (int i = 0; i < 4; ++i) {
                rbSearch_[i].addActionListener(byBasePanelControl_);
            }
            searchB_.setActionCommand(B_SEARCH);
            lexiconB_.setActionCommand(B_LEXICON);
            resetB_.setActionCommand(B_RESET);
            exitB_.setActionCommand(B_EXIT);
            searchB_.addActionListener(byBasePanelControl_);
            lexiconB_.addActionListener(byBasePanelControl_);
            resetB_.addActionListener(byBasePanelControl_);
            exitB_.addActionListener(byBasePanelControl_);
            initGuiControl_ = true;
        }
    }

    static {
        ByBasePanel.rbSearch_[0] = new JRadioButton("Exact Match");
        ByBasePanel.rbSearch_[1] = new JRadioButton("Begins with");
        ByBasePanel.rbSearch_[2] = new JRadioButton("Contains");
        ByBasePanel.rbSearch_[3] = new JRadioButton("Ends with");
        rbSearch_[0].setSelected(true);
        rbSearchGroup_.add(rbSearch_[0]);
        rbSearchGroup_.add(rbSearch_[1]);
        rbSearchGroup_.add(rbSearch_[2]);
        rbSearchGroup_.add(rbSearch_[3]);
        fileField_.setEditable(false);
        laOutputs_.setColumns(40);
        laOutputs_.setRows(25);
        laOutputs_.setEditable(false);
    }
}

