/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Gui;

import GuiTool.Global.LvgDef;
import GuiTool.Global.LvgGlobal;
import GuiTool.Gui.DerivationCatDialog;
import GuiTool.Gui.InflectionCatInflDialog;
import GuiTool.Gui.WordSizeDialog;
import GuiTool.GuiComp.FlowListPanel;
import GuiTool.GuiComp.OkCancelResetButtonPanel;
import GuiTool.GuiLib.GridBag;
import GuiTool.GuiLib.LvgHtmlBrowser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AddFlowDialog
extends JDialog {
    private static String[] item_ = new String[LvgDef.FLOW_NUM];
    private static JList<String> availableList_ = null;
    private static DefaultListModel<String> selectedModel_ = new DefaultListModel();
    private static JList<String> selectedList_ = new JList<String>(selectedModel_);
    private static JFrame owner_ = null;
    private static AddFlowDialog addFlowD_ = null;
    private static LvgHtmlBrowser helpDoc_ = null;
    private static final long serialVersionUID = 5L;

    private AddFlowDialog(JFrame owner) {
        super(owner, "Add a new flow", true);
        owner_ = owner;
        this.setLocationRelativeTo(owner);
        this.setSize(500, 400);
        FlowListPanel flowPanel = new FlowListPanel();
        availableList_ = flowPanel.GetList();
        Box button = Box.createVerticalBox();
        JButton addB = new JButton(" Add  ");
        JButton insertB = new JButton("Insert");
        JButton deleteB = new JButton("Delete");
        JButton helpB = new JButton(" Help ");
        button.add(Box.createVerticalStrut(10));
        button.add(addB);
        button.add(Box.createVerticalStrut(10));
        button.add(insertB);
        button.add(Box.createVerticalStrut(10));
        button.add(deleteB);
        button.add(Box.createVerticalStrut(10));
        button.add(helpB);
        selectedList_.setSelectionMode(0);
        JScrollPane selectedSp = new JScrollPane(selectedList_);
        Box selected = Box.createVerticalBox();
        selected.add(new JLabel("Current flow:"));
        selected.add(Box.createVerticalStrut(5));
        selected.add(selectedSp);
        JPanel centerP = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        centerP.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.insets = new Insets(10, 5, 20, 5);
        GridBag.SetPosSize(gbc, 0, 0, 1, 3);
        centerP.add((Component)flowPanel, gbc);
        gbc.fill = 0;
        gbc.anchor = 10;
        GridBag.SetPosSize(gbc, 1, 0, 1, 3);
        centerP.add((Component)button, gbc);
        gbc.fill = 1;
        GridBag.SetPosSize(gbc, 2, 0, 1, 3);
        centerP.add((Component)selected, gbc);
        OkCancelResetButtonPanel buttonP = new OkCancelResetButtonPanel();
        JButton okB = buttonP.GetOkButton();
        JButton cancelB = buttonP.GetCancelButton();
        JButton resetB = buttonP.GetResetButton();
        this.getContentPane().add((Component)centerP, "Center");
        this.getContentPane().add((Component)buttonP, "South");
        addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = availableList_.getSelectedIndex();
                if (index == 60) {
                    WordSizeDialog.AddWordSizeDialog(AddFlowDialog.this.getContentPane(), selectedModel_);
                } else if (index == 13) {
                    DerivationCatDialog.AddDerivationCatDialog(owner_, selectedModel_);
                } else if (index == 24) {
                    InflectionCatInflDialog.AddInflectionCatInflDialog(owner_, selectedModel_);
                } else {
                    selectedModel_.addElement(LvgDef.FLOW_FLAG[index]);
                }
            }
        });
        insertB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int srcIndex = availableList_.getSelectedIndex();
                int tarIndex = selectedList_.getSelectedIndex();
                int n = tarIndex = tarIndex > 0 ? tarIndex : 0;
                if (srcIndex == 60) {
                    WordSizeDialog.InsertWordSizeDialog(AddFlowDialog.this.getContentPane(), selectedModel_, tarIndex);
                } else if (srcIndex == 13) {
                    DerivationCatDialog.InsertDerivationCatDialog(owner_, selectedModel_, tarIndex);
                } else if (srcIndex == 24) {
                    InflectionCatInflDialog.InsertInflectionCatInflDialog(owner_, selectedModel_, tarIndex);
                } else {
                    selectedModel_.insertElementAt(LvgDef.FLOW_FLAG[srcIndex], tarIndex);
                }
            }
        });
        deleteB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = selectedList_.getSelectedIndex();
                if (index >= 0) {
                    selectedModel_.removeElementAt(index);
                }
            }
        });
        helpB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = availableList_.getSelectedIndex();
                String lvgDir = LvgGlobal.config_.GetConfiguration("LVG_DIR");
                String flowUrl = "file:" + lvgDir + "docs/designDoc/UDF/flow/" + LvgDef.FLOW_DOC[index];
                if (helpDoc_ == null) {
                    String title = "Lvg Flow Components Documents";
                    String homeUrl = "file:" + lvgDir + "docs/designDoc/UDF/flow/index.html";
                    helpDoc_ = new LvgHtmlBrowser(owner_, title, 600, 800, homeUrl, flowUrl);
                } else {
                    helpDoc_.SetPage(flowUrl);
                }
                helpDoc_.setVisible(true);
            }
        });
        okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (selectedModel_.size() > 0) {
                    String cmd = "-f";
                    for (int i = 0; i < selectedModel_.size(); ++i) {
                        cmd = cmd + ":" + (String)selectedModel_.elementAt(i);
                    }
                    LvgGlobal.cmd_.AddFlowComponent(cmd);
                }
                AddFlowDialog.this.setVisible(false);
            }
        });
        cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFlowDialog.this.setVisible(false);
            }
        });
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                selectedModel_.removeAllElements();
            }
        });
    }

    public static void ShowDialog(JFrame owner) {
        if (addFlowD_ == null) {
            addFlowD_ = new AddFlowDialog(owner);
        }
        selectedModel_.removeAllElements();
        addFlowD_.setVisible(true);
    }
}

