/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByBasePanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByCategoryPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByTermEuiPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.GlobalOptionDialog;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.InputSourceDialog;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaMenuBar;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LexiconDialog;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.MainPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.OutputOptionDialog;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.OutputSourceDialog;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiControl.KeysControl;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiLib.DocHtmlBrowser;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Model.LaObj;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Operations.GuiOperations;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class LaFrame
extends JFrame {
    private static final long serialVersionUID = 5L;
    private static final String LA_VERSION = "LexAccess, 2013";
    private LaObj laObj_ = new LaObj();
    private boolean bold_ = false;
    private boolean italic_ = false;
    private String style_ = "Dialog";
    private int size_ = 12;
    private Font font_ = null;
    private Font guiFont_ = null;
    private static LaFrame laFrame_ = null;
    private static LaMenuBar laMenuBar_ = null;
    private static DocHtmlBrowser helpDoc_ = null;
    private static JPanel mainPanel_ = null;
    private static JDialog inputSourceDialog_ = null;
    private static JDialog outputSourceDialog_ = null;
    private static JDialog globalOptionDialog_ = null;
    private static JDialog outputOptionDialog_ = null;
    private static JDialog lexiconDialog_ = null;

    public LaFrame() {
        laFrame_ = this;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        this.setDefaultCloseOperation(2);
        this.setTitle("LexAccess GUI Tool");
        this.setSize(600, 700);
        this.setLocation(5, 10);
        this.setResizable(true);
        Image img = tk.getImage(this.laObj_.GetConfigObj().GetLaDir() + "/data/image/lexAccessLogo.jpg");
        this.setIconImage(img);
        laMenuBar_ = new LaMenuBar(laFrame_);
        this.setJMenuBar(laMenuBar_);
        mainPanel_ = MainPanel.GetMainPanel(0, this);
        this.getContentPane().add(mainPanel_);
        this.addKeyListener(new KeysControl(laFrame_));
        inputSourceDialog_ = InputSourceDialog.GetDialog(this);
        outputSourceDialog_ = OutputSourceDialog.GetDialog(this);
        globalOptionDialog_ = GlobalOptionDialog.GetDialog(this);
        outputOptionDialog_ = OutputOptionDialog.GetDialog(this);
        lexiconDialog_ = LexiconDialog.GetDialog(this);
    }

    public void SetMainPanel(int searchMode) {
        mainPanel_ = MainPanel.GetMainPanel(searchMode, laFrame_);
        ByTermEuiPanel.UpdateInputPanel(this.laObj_.GetInSource());
        ByBasePanel.UpdateInputPanel(this.laObj_.GetInSource());
        ByCategoryPanel.UpdateInputPanel(this.laObj_.GetInSource());
    }

    public JDialog GetInputSourceDialog() {
        return inputSourceDialog_;
    }

    public JDialog GetOutputSourceDialog() {
        return outputSourceDialog_;
    }

    public JDialog GetGlobalOptionDialog() {
        return globalOptionDialog_;
    }

    public JDialog GetOutputOptionDialog() {
        return outputOptionDialog_;
    }

    public JDialog GetLexiconDialog() {
        return lexiconDialog_;
    }

    public DocHtmlBrowser GetHelpDoc() {
        return helpDoc_;
    }

    public void SetHelpDoc(DocHtmlBrowser helpDoc) {
        helpDoc_ = helpDoc;
    }

    public void SetStyle(String style) {
        this.style_ = style;
    }

    public void ToggleBold() {
        this.bold_ = !this.bold_;
    }

    public void ToggleItalic() {
        this.italic_ = !this.italic_;
    }

    public void SetSize(int size) {
        this.size_ = size;
    }

    public void SetDefaultFont() {
        laMenuBar_.SetDefaultFontMenu();
        this.style_ = "Dialog";
        this.bold_ = false;
        this.italic_ = false;
        this.size_ = 12;
    }

    public void UpdateFont() {
        this.font_ = new Font(this.style_, (this.bold_ ? 1 : 0) + (this.italic_ ? 2 : 0), this.size_);
        this.guiFont_ = new Font(this.style_, 1 + (this.italic_ ? 2 : 0), this.size_);
        GuiOperations.UpdateFont(this.font_, this.guiFont_, laFrame_);
        LaMenuBar.SetFont(this.font_, this.guiFont_);
        MainPanel.SetFont(this.font_, this.guiFont_);
        InputSourceDialog.SetFont(this.font_, this.guiFont_);
        GlobalOptionDialog.SetFont(this.font_, this.guiFont_);
        OutputOptionDialog.SetFont(this.font_, this.guiFont_);
        LexiconDialog.SetFont(this.font_, this.guiFont_);
        if (helpDoc_ != null) {
            helpDoc_.SetFont(this.font_, this.guiFont_);
        }
    }

    public Font GetFont() {
        return this.font_;
    }

    public Font GetGuiFont() {
        return this.guiFont_;
    }

    public void Dispose() {
        if (helpDoc_ != null) {
            helpDoc_.dispose();
        }
        inputSourceDialog_.dispose();
        outputSourceDialog_.dispose();
        globalOptionDialog_.dispose();
        outputOptionDialog_.dispose();
        lexiconDialog_.dispose();
        laFrame_.dispose();
    }

    public LaObj GetLaObj() {
        return this.laObj_;
    }
}

