/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.MainPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiControl.ByTermEuiPanelControl;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiLib.GridBag;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ByTermEuiPanel
extends JPanel
implements Cloneable {
    private static final long serialVersionUID = 5L;
    private static boolean initGui_ = false;
    public static final String B_SCREEN_SEARCH = "SCREEN_SEARCH";
    public static final String B_CLEAR = "CLEAR";
    public static final String B_FILE_SEARCH = "FILE_SEARCH";
    public static final String B_SEARCH = "SEARCH";
    public static final String B_LEXICON = "LEXICON";
    public static final String B_RESET = "RESET";
    public static final String B_EXIT = "EXIT";
    private static boolean initGuiControl_ = false;
    private static ByTermEuiPanelControl byTermEuiPanelControl_ = null;
    private static JPanel inputScreenP_ = null;
    private static JPanel inputFileP_ = null;
    private static TitledBorder inputScreenBorder_ = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Please input a term or EUI: ");
    private static JTextField termEuiField_ = new JTextField(35);
    private static JButton screenSearchB_ = new JButton("Search");
    private static JButton clearB_ = new JButton("Clear");
    private static TitledBorder inputFileBorder_ = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Read term/EUI from file: ");
    private static JTextField fileField_ = new JTextField(40);
    private static JButton fileSearchB_ = new JButton("Search");
    private static TitledBorder outputBorder_ = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Search Results: ");
    private static JTextArea laOutputs_ = new JTextArea();
    private static JButton searchB_ = new JButton("Search");
    private static JButton lexiconB_ = new JButton("Lexicon");
    private static JButton resetB_ = new JButton("Reset");
    private static JButton exitB_ = new JButton("Exit");

    public ByTermEuiPanel(LaFrame owner) {
        ByTermEuiPanel.InitGui(owner);
        ByTermEuiPanel.InitGuiControllers(owner);
    }

    public static JPanel CreateTermEuiPanel(LaFrame owner) {
        ByTermEuiPanel.InitGui(owner);
        ByTermEuiPanel.InitGuiControllers(owner);
        JPanel termEuiP = new JPanel();
        inputScreenP_ = ByTermEuiPanel.CreateInputScreenPanel();
        inputFileP_ = ByTermEuiPanel.CreateInputFilePanel();
        ByTermEuiPanel.UpdateInputPanel(0);
        JPanel outputP = ByTermEuiPanel.CreateOutputPanel();
        JPanel buttonP = ByTermEuiPanel.CreateButtonPanel();
        termEuiP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 5, 10, 5);
        gbc.fill = 2;
        GridBag.SetWeight(gbc, 100, 0);
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        termEuiP.add((Component)inputScreenP_, gbc);
        GridBag.SetPosSize(gbc, 0, 1, 1, 1);
        termEuiP.add((Component)inputFileP_, gbc);
        GridBag.SetPosSize(gbc, 0, 2, 1, 1);
        termEuiP.add((Component)outputP, gbc);
        GridBag.SetPosSize(gbc, 0, 3, 1, 1);
        termEuiP.add((Component)buttonP, gbc);
        return termEuiP;
    }

    public static void UpdateInputPanel(int source) {
        if (source == 0) {
            inputScreenP_.setVisible(true);
            inputFileP_.setVisible(false);
        } else if (source == 1) {
            inputScreenP_.setVisible(false);
            inputFileP_.setVisible(true);
        }
    }

    public static void SetFileField(String inFile) {
        fileField_.setText(inFile);
    }

    public static void SetFont(Font font, Font guiFont) {
        inputScreenBorder_.setTitleFont(guiFont);
        termEuiField_.setFont(font);
        screenSearchB_.setFont(guiFont);
        clearB_.setFont(guiFont);
        inputFileBorder_.setTitleFont(guiFont);
        fileField_.setFont(font);
        fileSearchB_.setFont(guiFont);
        outputBorder_.setTitleFont(guiFont);
        laOutputs_.setFont(font);
        lexiconB_.setFont(guiFont);
        searchB_.setFont(guiFont);
        resetB_.setFont(guiFont);
        exitB_.setFont(guiFont);
    }

    public static JTextField GetTermEuiField() {
        return termEuiField_;
    }

    public static JTextArea GetLaOutputs() {
        return laOutputs_;
    }

    private static JPanel CreateInputScreenPanel() {
        JPanel inputP = new JPanel();
        inputP.setLayout(new GridBagLayout());
        inputP.setBorder(inputScreenBorder_);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        gbc.anchor = 17;
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        inputP.add((Component)termEuiField_, gbc);
        gbc.anchor = 13;
        GridBag.SetPosSize(gbc, 1, 0, 1, 1);
        inputP.add((Component)screenSearchB_, gbc);
        gbc.anchor = 10;
        GridBag.SetPosSize(gbc, 2, 0, 1, 1);
        inputP.add((Component)clearB_, gbc);
        return inputP;
    }

    private static JPanel CreateInputFilePanel() {
        JPanel inputP = new JPanel();
        inputP.setLayout(new GridBagLayout());
        inputP.setBorder(inputFileBorder_);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        GridBag.SetWeight(gbc, 100, 100);
        gbc.anchor = 17;
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        inputP.add((Component)fileField_, gbc);
        gbc.anchor = 13;
        GridBag.SetPosSize(gbc, 1, 0, 1, 1);
        inputP.add((Component)fileSearchB_, gbc);
        return inputP;
    }

    private static JPanel CreateOutputPanel() {
        JPanel outputP = new JPanel();
        JScrollPane scrollPane = new JScrollPane(laOutputs_);
        outputP.setLayout(new GridBagLayout());
        outputP.setBorder(outputBorder_);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 2;
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 1, 1, 5, 1);
        outputP.add((Component)scrollPane, gbc);
        return outputP;
    }

    private static JPanel CreateButtonPanel() {
        JPanel buttonP = new JPanel();
        buttonP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        gbc.anchor = 10;
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        buttonP.add((Component)searchB_, gbc);
        GridBag.SetPosSize(gbc, 1, 0, 1, 1);
        buttonP.add((Component)lexiconB_, gbc);
        GridBag.SetPosSize(gbc, 2, 0, 1, 1);
        buttonP.add((Component)resetB_, gbc);
        GridBag.SetPosSize(gbc, 3, 0, 1, 1);
        buttonP.add((Component)exitB_, gbc);
        return buttonP;
    }

    private static void InitGui(LaFrame owner) {
        if (!initGui_) {
            laOutputs_.setText(MainPanel.GetBannerStr(owner));
            initGui_ = true;
        }
    }

    private static void InitGuiControllers(LaFrame owner) {
        if (!initGuiControl_) {
            byTermEuiPanelControl_ = new ByTermEuiPanelControl(owner);
            screenSearchB_.setActionCommand(B_SCREEN_SEARCH);
            clearB_.setActionCommand(B_CLEAR);
            fileSearchB_.setActionCommand(B_FILE_SEARCH);
            screenSearchB_.addActionListener(byTermEuiPanelControl_);
            clearB_.addActionListener(byTermEuiPanelControl_);
            fileSearchB_.addActionListener(byTermEuiPanelControl_);
            searchB_.setActionCommand(B_SEARCH);
            lexiconB_.setActionCommand(B_LEXICON);
            resetB_.setActionCommand(B_RESET);
            exitB_.setActionCommand(B_EXIT);
            searchB_.addActionListener(byTermEuiPanelControl_);
            lexiconB_.addActionListener(byTermEuiPanelControl_);
            resetB_.addActionListener(byTermEuiPanelControl_);
            exitB_.addActionListener(byTermEuiPanelControl_);
            initGuiControl_ = true;
        }
    }

    static {
        fileField_.setEditable(false);
        laOutputs_.setColumns(40);
        laOutputs_.setRows(25);
        laOutputs_.setEditable(false);
    }
}

