/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Api;

import gov.nih.nlm.nls.lexAccess.Api.LexAccessApiResult;
import gov.nih.nlm.nls.lexAccess.Db.DbBase;
import gov.nih.nlm.nls.lexAccess.Db.DbInflVars;
import gov.nih.nlm.nls.lexAccess.Db.DbLexRecord;
import gov.nih.nlm.nls.lexAccess.Lib.Configuration;
import gov.nih.nlm.nls.lexAccess.Util.GlobalVars;
import gov.nih.nlm.nls.lexCheck.Gram.CheckFormatEui;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lvg.Lib.BitMaskBase;
import gov.nih.nlm.nls.lvg.Lib.Category;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class LexAccessApi {
    public static final String LS_STR = GlobalVars.LS_STR;
    public static final int TEXT = 0;
    public static final int XML = 1;
    public static final int TEXT_XML = 2;
    public static final int BASE = 3;
    public static final int BASE_DETAILS = 4;
    public static final int SPELL_VAR = 5;
    public static final int SPELL_VAR_DETAILS = 6;
    public static final int INFL_VAR = 7;
    public static final int INFL_VAR_DETAILS = 8;
    public static final int B_NONE = 0;
    public static final int B_BEGIN = 1;
    public static final int B_CONTAIN = 2;
    public static final int B_END = 3;
    public static final int B_EXACT = 4;
    private String configFile_ = null;
    private Configuration conf_ = null;
    private String noOutputMsg_ = "-No Record Found-";
    private Connection conn_ = null;

    public LexAccessApi() {
        this.Init();
    }

    public LexAccessApi(String configFile) {
        this.configFile_ = configFile;
        this.Init();
    }

    public LexAccessApi(Connection conn) {
        this.conn_ = conn;
    }

    public LexAccessApi(Hashtable<String, String> properties) {
        this.Init(properties);
    }

    public LexAccessApi(String configFile, Hashtable<String, String> properties) {
        this.configFile_ = configFile;
        this.Init(properties);
    }

    public String GetResultStrByTerm(String inputTerm, long category, boolean showQuery, String query, boolean noOutputFlag, String noOutputMsg, boolean showTotalRecNum, int lexRecordFormat, String fieldSep) throws SQLException {
        LexAccessApiResult lexAccessApiResult = null;
        if (inputTerm != null && inputTerm.length() > 0) {
            lexAccessApiResult = this.GetLexRecords(inputTerm);
        }
        Vector<LexRecord> newLexRecordObjs = new Vector<LexRecord>();
        if (category < 2047L) {
            Vector<LexRecord> lexRecordObjs = lexAccessApiResult.GetJavaObjs();
            for (int i = 0; i < lexRecordObjs.size(); ++i) {
                LexRecord temp = lexRecordObjs.elementAt(i);
                long catValue = Category.ToValue((String)temp.GetCategory());
                if (!BitMaskBase.Contains((long)category, (long)catValue)) continue;
                newLexRecordObjs.addElement(temp);
            }
            lexAccessApiResult.SetJavaObjs(newLexRecordObjs);
        }
        return this.FormatResultToStr(lexAccessApiResult, inputTerm, showQuery, query, noOutputFlag, noOutputMsg, showTotalRecNum, lexRecordFormat, fieldSep);
    }

    public String GetResultStrByBase(String base, int baseBy, long category, boolean showQuery, String query, boolean noOutputFlag, String noOutputMsg, boolean showTotalRecNum, int lexRecordFormat, String fieldSep) throws SQLException {
        LexAccessApiResult lexAccessApiResult = null;
        if (base != null && base.length() > 0) {
            lexAccessApiResult = this.GetLexRecordsByBase(base, baseBy);
        }
        Vector<LexRecord> newLexRecordObjs = new Vector<LexRecord>();
        if (category < 2047L) {
            Vector<LexRecord> lexRecordObjs = lexAccessApiResult.GetJavaObjs();
            for (int i = 0; i < lexRecordObjs.size(); ++i) {
                LexRecord temp = lexRecordObjs.elementAt(i);
                long catValue = Category.ToValue((String)temp.GetCategory());
                if (!BitMaskBase.Contains((long)category, (long)catValue)) continue;
                newLexRecordObjs.addElement(temp);
            }
            lexAccessApiResult.SetJavaObjs(newLexRecordObjs);
        }
        return this.FormatResultToStr(lexAccessApiResult, base, showQuery, query, noOutputFlag, noOutputMsg, showTotalRecNum, lexRecordFormat, fieldSep);
    }

    public String GetResultStrByCategory(long category, boolean showQuery, String query, boolean noOutputFlag, String noOutputMsg, boolean showTotalRecNum, int lexRecordFormat, String fieldSep) throws SQLException {
        LexAccessApiResult lexAccessApiResult = null;
        lexAccessApiResult = this.GetLexRecordsByCat(category);
        return this.FormatResultToStr(lexAccessApiResult, new String(), showQuery, query, noOutputFlag, noOutputMsg, showTotalRecNum, lexRecordFormat, fieldSep);
    }

    public String FormatResultToStr(LexAccessApiResult lexAccessApiResult, String inputTerm, boolean showQuery, String query, boolean noOutputFlag, String noOutputMsg, boolean showTotalRecNum, int lexRecordFormat, String fieldSep) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        if (showQuery) {
            buffer.append("Query: '" + query.trim() + "'");
            buffer.append(LS_STR);
        }
        if (noOutputFlag && lexAccessApiResult.GetTotalRecordNumber() == 0) {
            buffer.append(inputTerm + fieldSep + noOutputMsg);
            buffer.append(LS_STR);
        }
        if (showTotalRecNum) {
            buffer.append("--- Total Records Number: " + lexAccessApiResult.GetTotalRecordNumber());
            buffer.append(LS_STR);
        }
        switch (lexRecordFormat) {
            case 0: {
                buffer.append(lexAccessApiResult.GetText());
                break;
            }
            case 1: {
                buffer.append(lexAccessApiResult.GetXml());
                break;
            }
            case 2: {
                buffer.append(lexAccessApiResult.GetText());
                buffer.append(lexAccessApiResult.GetXml());
                break;
            }
            case 3: {
                Vector<String> bases = lexAccessApiResult.GetBases();
                for (int i = 0; i < bases.size(); ++i) {
                    buffer.append(bases.elementAt(i));
                    buffer.append(LS_STR);
                }
                break;
            }
            case 4: {
                Vector<String> basesD = lexAccessApiResult.GetBases(fieldSep);
                for (int i = 0; i < basesD.size(); ++i) {
                    buffer.append(basesD.elementAt(i));
                    buffer.append(LS_STR);
                }
                break;
            }
            case 5: {
                Vector<String> spellingVars = lexAccessApiResult.GetSpellingVars();
                for (int i = 0; i < spellingVars.size(); ++i) {
                    buffer.append(spellingVars.elementAt(i));
                    buffer.append(LS_STR);
                }
                break;
            }
            case 6: {
                Vector<String> spellingVarsD = lexAccessApiResult.GetSpellingVars(fieldSep);
                for (int i = 0; i < spellingVarsD.size(); ++i) {
                    buffer.append(spellingVarsD.elementAt(i));
                    buffer.append(LS_STR);
                }
                break;
            }
            case 7: {
                Vector<String> inflVars = lexAccessApiResult.GetInflVars();
                for (int i = 0; i < inflVars.size(); ++i) {
                    buffer.append(inflVars.elementAt(i));
                    buffer.append(LS_STR);
                }
                break;
            }
            case 8: {
                Vector<String> inflVarsD = lexAccessApiResult.GetInflVars(fieldSep);
                for (int i = 0; i < inflVarsD.size(); ++i) {
                    buffer.append(inflVarsD.elementAt(i));
                    buffer.append(LS_STR);
                }
                break;
            }
        }
        return buffer.toString();
    }

    public LexAccessApiResult GetLexRecords(String input) throws SQLException {
        LexAccessApiResult lexAccessApiResult = new LexAccessApiResult();
        if (input == null || input.length() == 0) {
            return lexAccessApiResult;
        }
        boolean isEui = CheckFormatEui.IsValidEui((String)input);
        String text = new String();
        if (isEui) {
            String lexRecord;
            text = lexRecord = DbLexRecord.GetRecordByEui(this.conn_, input);
        } else {
            int i;
            Vector<String> euis = DbInflVars.GetUniqueEuisByInflVar(this.conn_, input);
            Vector<String> lexRecords = new Vector<String>();
            for (i = 0; i < euis.size(); ++i) {
                String eui = euis.elementAt(i);
                lexRecords.addElement(DbLexRecord.GetRecordByEui(this.conn_, eui));
            }
            for (i = 0; i < lexRecords.size(); ++i) {
                text = text + (String)lexRecords.elementAt(i);
            }
        }
        lexAccessApiResult.SetText(text);
        return lexAccessApiResult;
    }

    public LexAccessApiResult GetLexRecordsByBase(String input, int baseBy) throws SQLException {
        LexAccessApiResult lexAccessApiResult = new LexAccessApiResult();
        if (input == null || input.length() == 0) {
            return lexAccessApiResult;
        }
        String text = new String();
        Vector<String> lexRecords = DbLexRecord.GetRecordsByBase(this.conn_, input, baseBy);
        for (int i = 0; i < lexRecords.size(); ++i) {
            text = text + lexRecords.elementAt(i);
        }
        lexAccessApiResult.SetText(text);
        return lexAccessApiResult;
    }

    public LexAccessApiResult GetLexRecordsByCat(long category) throws SQLException {
        LexAccessApiResult lexAccessApiResult = new LexAccessApiResult();
        StringBuffer text = new StringBuffer();
        Vector<String> lexRecords = DbLexRecord.GetRecordsByCat(this.conn_, category);
        for (int i = 0; i < lexRecords.size(); ++i) {
            String lexRecord = lexRecords.elementAt(i);
            text.append(lexRecord);
        }
        lexAccessApiResult.SetText(text.toString());
        return lexAccessApiResult;
    }

    public Vector<String> GetBasesByEui(String eui) throws SQLException {
        Vector<String> bases = DbInflVars.GetBasesByEui(this.conn_, eui);
        return bases;
    }

    public Configuration GetConfiguration() {
        return this.conf_;
    }

    public Connection GetConnection() {
        return this.conn_;
    }

    public boolean ResetDbConnection(String dbVersion) {
        boolean flag = true;
        Connection tempConn = this.conn_;
        Connection newConn = DbBase.OpenConnection(this.conf_, dbVersion);
        if (newConn != null) {
            this.conn_ = newConn;
            this.CloseConnection(tempConn);
        } else {
            flag = false;
        }
        return flag;
    }

    public void CleanUp() {
        try {
            this.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void CloseConnection(Connection conn) {
        if (conn != null) {
            try {
                DbBase.CloseConnection(conn);
            }
            catch (Exception e) {
                System.out.println(" ** Error on CloseConnection(): " + e.getMessage());
            }
        }
    }

    private void Init() {
        boolean useClassPath = false;
        if (this.configFile_ == null) {
            useClassPath = true;
            this.configFile_ = "data.config.lexAccess";
        }
        this.conf_ = new Configuration(this.configFile_, useClassPath);
        if (this.conn_ == null) {
            try {
                this.conn_ = DbBase.OpenConnection(this.conf_);
            }
            catch (Exception e) {
                System.out.println(" ** on Init(): " + e.getMessage());
            }
        }
    }

    private void Init(Hashtable<String, String> properties) {
        boolean useClassPath = false;
        if (this.configFile_ == null) {
            useClassPath = true;
            this.configFile_ = "data.config.lexAccess";
        }
        this.conf_ = new Configuration(this.configFile_, useClassPath);
        if (properties != null) {
            this.conf_.OverwriteProperties(properties);
        }
        if (this.conn_ == null) {
            try {
                this.conn_ = DbBase.OpenConnection(this.conf_);
            }
            catch (Exception e) {
                System.out.println(" ** on Init(): " + e.getMessage());
            }
        }
    }

    private void Close() throws SQLException {
        if (this.conn_ != null) {
            DbBase.CloseConnection(this.conn_);
        }
    }
}

