/*
 * Decompiled with CFR 0.152.
 */
package cumulus_message_adapter.message_parser;

import com.amazonaws.services.lambda.runtime.Context;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cumulus_message_adapter.message_parser.AdapterLogger;
import cumulus_message_adapter.message_parser.IMessageAdapter;
import cumulus_message_adapter.message_parser.JsonUtils;
import cumulus_message_adapter.message_parser.MessageAdapterException;
import cumulus_message_adapter.message_parser.SchemaLocations;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class MessageAdapter
implements IMessageAdapter {
    private static final int MESSAGE_ADAPTER_TIMEOUT = 300;
    private static final String systemPython = "python3";

    public String GetMessageAdapterEnvironmentVariable() {
        return System.getenv("CUMULUS_MESSAGE_ADAPTER_DIR");
    }

    private ProcessBuilder buildProcess(String command) {
        boolean pythonExistsInPath;
        Object messageAdapterPath = System.getProperty("user.dir") + File.separator + "cumulus-message-adapter";
        String messageAdapterDir = this.GetMessageAdapterEnvironmentVariable();
        if (messageAdapterDir != null) {
            messageAdapterPath = messageAdapterDir;
        }
        if ((pythonExistsInPath = Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0])).anyMatch(path -> Files.exists(path.resolve(systemPython), new LinkOption[0]))) && System.getenv("USE_CMA_BINARY") != "true") {
            return new ProcessBuilder(new String[]{systemPython, messageAdapterPath, command});
        }
        return new ProcessBuilder((String)messageAdapterPath + "/cma_bin/cma", command);
    }

    @Override
    public String CallMessageAdapterFunction(String messageAdapterFunction, String inputJson) throws MessageAdapterException {
        String messageAdapterOutput = "";
        String command = "";
        try {
            ProcessBuilder processBuilder = this.buildProcess(messageAdapterFunction);
            command = processBuilder.command().toString();
            Process process = processBuilder.start();
            OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
            writer.write(inputJson);
            writer.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line != null) {
                AdapterLogger.LogDebug(line);
            }
            reader.close();
            Boolean processComplete = false;
            try {
                processComplete = process.waitFor(300L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                AdapterLogger.LogError(String.format("Cumulus Message Adapter error: %s: %s", messageAdapterFunction, e.getMessage()));
            }
            int exitValue = 1;
            if (processComplete.booleanValue()) {
                exitValue = process.exitValue();
            }
            if (!processComplete.booleanValue() || exitValue != 0) {
                Scanner scanner = new Scanner(process.getErrorStream());
                StringBuilder errorMessageBuilder = new StringBuilder();
                while (scanner.hasNextLine()) {
                    errorMessageBuilder.append(scanner.nextLine());
                }
                scanner.close();
                String errorString = String.format("%s: %s", messageAdapterFunction, errorMessageBuilder.toString());
                AdapterLogger.LogError("Cumulus Message Adapter error: " + errorString);
                throw new MessageAdapterException("Error executing " + errorString);
            }
            messageAdapterOutput = line;
        }
        catch (IOException e) {
            String errorString = String.format("Unable to find Cumulus Message Adapter: %s: %s", command, e.getMessage());
            AdapterLogger.LogError(errorString);
            throw new MessageAdapterException(errorString);
        }
        return messageAdapterOutput;
    }

    @Override
    public String LoadAndUpdateRemoteEvent(String eventJson, Context context, SchemaLocations schemaLocations) throws MessageAdapterException {
        Gson gson = new Gson();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("event", gson.fromJson(eventJson, Map.class));
        map.put("context", context);
        map.put("schemas", schemaLocations);
        return this.CallMessageAdapterFunction("loadAndUpdateRemoteEvent", gson.toJson(map));
    }

    @Override
    public String LoadNestedEvent(String eventJson, Context context, SchemaLocations schemaLocations) throws MessageAdapterException {
        Gson gson = new Gson();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("event", gson.fromJson(eventJson, Map.class));
        map.put("context", context);
        map.put("schemas", schemaLocations);
        return this.CallMessageAdapterFunction("loadNestedEvent", gson.toJson(map));
    }

    @Override
    public String CreateNextEvent(String remoteEventJson, String nestedEventJson, String taskJson, SchemaLocations schemaLocations) throws MessageAdapterException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.serializeNulls();
        Gson gson = gsonBuilder.create();
        Map<String, Object> nestedEventMap = JsonUtils.toMap(nestedEventJson);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("event", gson.fromJson(remoteEventJson, Map.class));
        map.put("message_config", nestedEventMap.get("messageConfig"));
        map.put("handler_response", gson.fromJson(taskJson, Map.class));
        map.put("schemas", schemaLocations);
        return this.CallMessageAdapterFunction("createNextEvent", gson.toJson(map));
    }
}

