/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.log4j2;

import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.LambdaRuntime;
import com.amazonaws.services.lambda.runtime.LambdaRuntimeInternal;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="Lambda", category="Core", elementType="appender", printObject=true)
public class LambdaAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "Lambda";
    public static final String PLUGIN_CATEGORY = "Core";
    public static final String PLUGIN_TYPE = "appender";
    private LambdaLogger logger = LambdaRuntime.getLogger();

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private LambdaAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        LambdaRuntimeInternal.setUseLog4jAppender(true);
    }

    @Override
    public void append(LogEvent event) {
        this.logger.log(super.getLayout().toByteArray(event));
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<LambdaAppender> {
        @Override
        public LambdaAppender build() {
            return new LambdaAppender(super.getName(), super.getFilter(), super.getOrCreateLayout(), super.isIgnoreExceptions());
        }
    }
}

