/*
 * Decompiled with CFR 0.152.
 */
package cumulus_message_adapter.message_parser;

import com.amazonaws.services.lambda.runtime.Context;
import com.google.gson.Gson;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterLogger {
    static final Logger _logger = LogManager.getLogger();
    static final String LEVEL_ERROR = "error";
    static final String LEVEL_FATAL = "fatal";
    static final String LEVEL_WARNING = "warn";
    static final String LEVEL_INFO = "info";
    static final String LEVEL_DEBUG = "debug";
    static final String LEVEL_TRACE = "trace";
    static String _executions;
    static String _sender;

    private static String GetNestedObject(String json, Stack<String> keys) {
        Gson gson = new Gson();
        Map map = gson.fromJson(json, Map.class);
        if (map != null && !keys.isEmpty()) {
            String key = keys.pop();
            Object nestedJson = map.get(key);
            if (nestedJson == null) {
                return null;
            }
            if (keys.isEmpty()) {
                return nestedJson.toString();
            }
            return AdapterLogger.GetNestedObject(gson.toJson(nestedJson), keys);
        }
        return null;
    }

    private static String GenerateMessage(String level, String message) {
        Gson gson = new Gson();
        Date date = new Date();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("executions", _executions);
        map.put("level", level);
        map.put("sender", _sender);
        map.put("message", message);
        map.put("timestamp", new Timestamp(date.getTime()).toString());
        return gson.toJson(map);
    }

    static void SetExecutions(String event) {
        Stack<String> executionNameKeys = new Stack<String>();
        executionNameKeys.push("execution_name");
        executionNameKeys.push("cumulus_meta");
        _executions = AdapterLogger.GetNestedObject(event, executionNameKeys);
    }

    static void InitializeLogger(Context context, String event) {
        AdapterLogger.SetExecutions(event);
        _sender = context != null ? context.getFunctionName() : null;
    }

    public static void LogError(String message) {
        _logger.error(AdapterLogger.GenerateMessage(LEVEL_ERROR, message));
    }

    public static void LogFatal(String message) {
        _logger.fatal(AdapterLogger.GenerateMessage(LEVEL_FATAL, message));
    }

    public static void LogWarning(String message) {
        _logger.warn(AdapterLogger.GenerateMessage(LEVEL_WARNING, message));
    }

    public static void LogInfo(String message) {
        _logger.info(AdapterLogger.GenerateMessage(LEVEL_INFO, message));
    }

    public static void LogDebug(String message) {
        _logger.debug(AdapterLogger.GenerateMessage(LEVEL_DEBUG, message));
    }

    public static void LogTrace(String message) {
        _logger.trace(AdapterLogger.GenerateMessage(LEVEL_TRACE, message));
    }
}

