/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.log4j2;

import com.amazonaws.services.lambda.runtime.LambdaRuntimeInternal;
import java.io.IOException;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="Lambda", category="Core", elementType="appender", printObject=true)
public class LambdaAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "Lambda";
    public static final String PLUGIN_CATEGORY = "Core";
    public static final String PLUGIN_TYPE = "appender";

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private LambdaAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        LambdaRuntimeInternal.setUseLog4jAppender(true);
    }

    @Override
    public void append(LogEvent event) {
        try {
            System.out.write(super.getLayout().toByteArray(event));
            System.out.flush();
            System.out.print(System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<LambdaAppender> {
        @Override
        public LambdaAppender build() {
            return new LambdaAppender(super.getName(), super.getFilter(), super.getOrCreateLayout(), super.isIgnoreExceptions());
        }
    }
}

