/*
 * Decompiled with CFR 0.152.
 */
package cumulus_message_adapter.message_parser;

import com.amazonaws.services.lambda.runtime.Context;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cumulus_message_adapter.message_parser.JsonUtils;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdapterLogger {
    static final Logger _logger = LogManager.getLogger();
    static final String LEVEL_ERROR = "error";
    static final String LEVEL_FATAL = "fatal";
    static final String LEVEL_WARNING = "warn";
    static final String LEVEL_INFO = "info";
    static final String LEVEL_DEBUG = "debug";
    static final String LEVEL_TRACE = "trace";
    static String _asyncOperationId;
    static String _executions;
    static String _granules;
    static String _parentArn;
    static String _sender;
    static String _stackName;
    static String _version;

    private static String GetNestedObject(String json, Stack<String> keys) {
        Gson gson = new Gson();
        Map<String, Object> map = JsonUtils.toMap(json);
        if (map != null && !keys.isEmpty()) {
            String key = keys.pop();
            Object nestedJson = map.get(key);
            if (nestedJson == null) {
                return null;
            }
            if (keys.isEmpty()) {
                return nestedJson instanceof String ? nestedJson.toString() : gson.toJson(nestedJson);
            }
            return AdapterLogger.GetNestedObject(gson.toJson(nestedJson), keys);
        }
        return null;
    }

    private static Stack<String> jsonPathToStack(String jsonPath) {
        String[] paths = jsonPath.split("\\.");
        Stack<String> keys = new Stack<String>();
        for (int i = paths.length - 1; i >= 0; --i) {
            keys.push(paths[i]);
        }
        return keys;
    }

    private static String GenerateMessage(String level, String message) {
        Gson gson = new Gson();
        Date date = new Date();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("asyncOperationId", _asyncOperationId);
        map.put("executions", _executions);
        map.put("granules", _granules);
        map.put("parentArn", _parentArn);
        map.put("sender", _sender);
        map.put("stackName", _stackName);
        map.put("version", _version);
        map.put("level", level);
        map.put("message", message);
        map.put("timestamp", new Timestamp(date.getTime()).toString());
        return gson.toJson(map);
    }

    static void SetAsyncOperationId(String event) {
        String[] paths;
        _asyncOperationId = null;
        for (String path : paths = new String[]{"cumulus_meta.asyncOperationId", "cma.event.cumulus_meta.asyncOperationId"}) {
            String value = AdapterLogger.GetNestedObject(event, AdapterLogger.jsonPathToStack(path));
            if (value == null) continue;
            _asyncOperationId = value;
            break;
        }
    }

    static void SetExecutions(String event) {
        String[] paths;
        _executions = null;
        for (String path : paths = new String[]{"cumulus_meta.execution_name", "cma.event.cumulus_meta.execution_name"}) {
            String value = AdapterLogger.GetNestedObject(event, AdapterLogger.jsonPathToStack(path));
            if (value == null) continue;
            _executions = value;
            break;
        }
    }

    static void SetGranules(String event) {
        _granules = null;
        String[] paths = new String[]{"payload.granules", "meta.input_granules", "cma.event.payload.granules", "cma.event.meta.input_granules"};
        Gson gson = new Gson();
        for (String path : paths) {
            Type listType;
            List granules;
            String granulesString = AdapterLogger.GetNestedObject(event, AdapterLogger.jsonPathToStack(path));
            if (granulesString == null || (granules = (List)gson.fromJson(granulesString, listType = new TypeToken<List<Map<String, Object>>>(){}.getType())) == null || granules.isEmpty()) continue;
            ArrayList<String> granuleIds = new ArrayList<String>();
            for (Map granule : granules) {
                granuleIds.add(granule.get("granuleId").toString());
            }
            _granules = gson.toJson(granuleIds);
            break;
        }
    }

    static void SetParentArn(String event) {
        String[] paths;
        _parentArn = null;
        for (String path : paths = new String[]{"cumulus_meta.parentExecutionArn", "cma.event.cumulus_meta.parentExecutionArn"}) {
            String value = AdapterLogger.GetNestedObject(event, AdapterLogger.jsonPathToStack(path));
            if (value == null) continue;
            _parentArn = value;
            break;
        }
    }

    static void SetStackName(String event) {
        String[] paths;
        _stackName = null;
        for (String path : paths = new String[]{"meta.stack", "cma.event.meta.stack"}) {
            String value = AdapterLogger.GetNestedObject(event, AdapterLogger.jsonPathToStack(path));
            if (value == null) continue;
            _stackName = value;
            break;
        }
    }

    static void InitializeLogger(Context context, String event) {
        AdapterLogger.SetAsyncOperationId(event);
        AdapterLogger.SetExecutions(event);
        AdapterLogger.SetGranules(event);
        AdapterLogger.SetParentArn(event);
        AdapterLogger.SetStackName(event);
        _sender = context != null ? context.getFunctionName() : null;
        _version = context != null ? context.getFunctionVersion() : null;
    }

    public static void LogError(String message) {
        _logger.error(AdapterLogger.GenerateMessage(LEVEL_ERROR, message));
    }

    public static void LogFatal(String message) {
        _logger.fatal(AdapterLogger.GenerateMessage(LEVEL_FATAL, message));
    }

    public static void LogWarning(String message) {
        _logger.warn(AdapterLogger.GenerateMessage(LEVEL_WARNING, message));
    }

    public static void LogInfo(String message) {
        _logger.info(AdapterLogger.GenerateMessage(LEVEL_INFO, message));
    }

    public static void LogDebug(String message) {
        _logger.debug(AdapterLogger.GenerateMessage(LEVEL_DEBUG, message));
    }

    public static void LogTrace(String message) {
        _logger.trace(AdapterLogger.GenerateMessage(LEVEL_TRACE, message));
    }
}

