# Development

**Contents**

* nREPL
* Proto-REPL
* System
* Code Reloading
* Convenience Functions


## nREPL

To write new code for CMR Service-Bridge you'll want to start up a REPL. The
primary development REPL for CMR Service-Bridge is a terminal-based nREPL:

```
$ lein repl
```
```text

 __________ ___   ___ _________
/   /_____/|   \ /   |    _o___)           A general-purpose API server
\___\%%%%%'|____|____|___|\____\               for bridging services in
 `BBBBBBBB' `BBBBBBB' `BB' `BBB'                         NASA Earthdata
 ____________________ _________ ___   ______________________ __________
/_________/   /_____/|    _o___)   \ /   \__/ \__/   /_____//   /_____/
`%%%%%%%%%|___\%%%%%'|___|\____\___/_\___/`%\_/%'\___\%%%%%'\___\%%%%%'
`BBBBBBBB' `BBBBBBBB' `BB' `BBB'`BBBBBBB'`BBBBBBB'`BBBBBBBB' `BBBBBBBB'
            _________ _________ __________________ ____________________
     ______|     o   )    _o___)\__/ \__/     O   Y   /_____/   /_____/
    |_____/|_____O___)___|\____\_`%\_/%'|_________|___\%%%%.]___\%%%%%'
            `BBBBBBB' `BB' `BBB'`BBBBBBB'`BBBBBBB' `BBBBBBBB'`BBBBBBBB'



nREPL server started on port 52191 on host 127.0.0.1 - nrepl://127.0.0.1:52191
REPL-y 0.3.7, nREPL 0.2.12
Clojure 1.8.0
Java HotSpot(TM) 64-Bit Server VM 1.8.0_91-b14
    Docs: (doc function-name-here)
          (find-doc "part-of-name-here")
  Source: (source function-name-here)
 Javadoc: (javadoc java-object-or-class-here)
    Exit: Control+D or (exit) or (quit)
 Results: Stored in vars *1, *2, *3, an exception in *e

[cmr.opendap.dev] λ=>
```


## Proto-REPL

For those using the Atom editor, CMR Service-Bridge also offers support for Proto-REPL.
To this end, the `user` ns has been provied at `dev-resources/src/user.clj`. It
is essentially a wrapper for `cmr.opendap.dev` (and can be removed once Proto-REPL
supports configurable starting namespaces, as `lein` does).


## System

With the REPL up, you're ready to bring up the CMR Service-Bridge system components:

```clj
[cmr.opendap.dev] λ=> (startup)
```

This will start the following CMR Service-Bridge components,
as the log messages show:

```
2018-11-08T10:24:28.641 [nREPL-worker-1] INFO cmr.exchange.common.components.config:44 - Starting config component ...
2018-11-08T10:24:28.677 [nREPL-worker-1] DEBUG cmr.exchange.common.components.config:45 - Started config component.
2018-11-08T10:24:28.679 [nREPL-worker-1] INFO cmr.exchange.common.components.logging:16 - Starting logging component ...
2018-11-08T10:24:28.679 [nREPL-worker-1] DEBUG cmr.exchange.common.components.logging:19 - Setting up logging with level :debug
2018-11-08T10:24:28.680 [nREPL-worker-1] DEBUG cmr.exchange.common.components.logging:21 - Logging namespaces: [cmr org.httpkit]
2018-11-08T10:24:28.683 [nREPL-worker-1] DEBUG cmr.exchange.common.components.logging:24 - Enabling color logging ...
2018-11-08T10:24:28.685 [nREPL-worker-1] DEBUG cmr.exchange.common.components.logging:27 - Started logging component.
2018-11-08T10:24:28.686 [nREPL-worker-1] INFO cmr.mission-control.components.pubsub:152 - Starting pub-sub component ...
2018-11-08T10:24:28.688 [nREPL-worker-1] DEBUG cmr.mission-control.pubsub.impl.core-async:49 - Creating pubsub manager ...
2018-11-08T10:24:28.692 [nREPL-worker-1] DEBUG cmr.mission-control.pubsub.impl.core-async:49 - Creating pubsub manager ...
2018-11-08T10:24:28.693 [nREPL-worker-1] INFO cmr.mission-control.components.pubsub:159 - Adding subscribers ...
2018-11-08T10:24:28.695 [nREPL-worker-1] DEBUG cmr.mission-control.components.pubsub:161 - Started pub-sub component.
2018-11-08T10:24:28.696 [nREPL-worker-1] INFO cmr.plugin.jar.components.registry:46 - Starting plugin registry component ...
2018-11-08T10:24:28.727 [nREPL-worker-1] DEBUG cmr.plugin.jar.components.registry:55 - plugin-name: CMR-Plugin
2018-11-08T10:24:28.728 [nREPL-worker-1] DEBUG cmr.plugin.jar.components.registry:56 - plugin-type: service-bridge-app
2018-11-08T10:24:28.728 [nREPL-worker-1] DEBUG cmr.plugin.jar.components.registry:57 - in-jar-filepath: config/cmr-plugin/config.edn
2018-11-08T10:24:28.729 [nREPL-worker-1] DEBUG cmr.plugin.jar.components.registry:58 - route-keys: [:httpd :route-fns]
2018-11-08T10:24:28.729 [nREPL-worker-1] DEBUG cmr.plugin.jar.components.registry:59 - api-key: :api
2018-11-08T10:24:28.730 [nREPL-worker-1] DEBUG cmr.plugin.jar.components.registry:60 - site-key: :site
2018-11-08T10:24:28.730 [nREPL-worker-1] DEBUG cmr.plugin.jar.components.registry:61 - reducer: cmr.plugin.jar.core$create_has_plugin_type_reducer@70e47516
2018-11-08T10:24:28.730 [nREPL-worker-1] DEBUG cmr.plugin.jar.components.registry:62 - jarfiles: clojure.lang.LazySeq@87bb79d5
2018-11-08T10:24:28.731 [nREPL-worker-1] DEBUG cmr.plugin.jar.components.registry:63 - Started plugin registry component.
2018-11-08T10:24:28.737 [nREPL-worker-1] INFO cmr.authz.components.caching:92 - Starting authz caching component ...
2018-11-08T10:24:28.747 [nREPL-worker-1] DEBUG cmr.authz.components.caching:45 - Creating TTL Cache with time-to-live of 3600000
2018-11-08T10:24:28.748 [nREPL-worker-1] DEBUG cmr.authz.components.caching:46 - Composing with LRU cache with threshold (item count) 1000
2018-11-08T10:24:28.748 [nREPL-worker-1] DEBUG cmr.authz.components.caching:94 - Started authz caching component.
2018-11-08T10:24:28.750 [nREPL-worker-1] INFO cmr.metadata.proxy.components.caching:127 - Starting concept caching component ...
2018-11-08T10:24:28.752 [nREPL-worker-1] DEBUG cmr.metadata.proxy.components.caching:49 - Creating memory-sensitive cache composed with LRU cache ...
2018-11-08T10:24:28.752 [nREPL-worker-1] DEBUG cmr.metadata.proxy.components.caching:129 - Started concept caching component.
2018-11-08T10:24:28.754 [nREPL-worker-1] INFO cmr.metadata.proxy.components.concept:119 - Starting concept component ...
2018-11-08T10:24:28.755 [nREPL-worker-1] DEBUG cmr.metadata.proxy.components.concept:120 - Started concept component.
2018-11-08T10:24:28.756 [nREPL-worker-1] INFO cmr.metadata.proxy.components.auth:195 - Starting authorization component ...
2018-11-08T10:24:28.756 [nREPL-worker-1] DEBUG cmr.metadata.proxy.components.auth:196 - Started authorization component.
2018-11-08T10:24:28.757 [nREPL-worker-1] INFO cmr.http.kit.components.server:32 - Starting httpd component ...
2018-11-08T10:24:30.129 [nREPL-worker-1] WARN cmr.exchange.common.util:95 - Couldn't resolve one or more of cmr.ous.app.routes.site/all
2018-11-08T10:24:30.153 [nREPL-worker-1] DEBUG cmr.http.kit.components.server:40 - HTTPD is listening on port 3013
2018-11-08T10:24:30.155 [nREPL-worker-1] DEBUG cmr.http.kit.components.server:41 - Started httpd component.
:running
```

A convenience function has been provided for use in the REPL which returns
the dynamic var where the system state is stored:

```clj
[cmr.opendap.dev] λ=> (system)
```

When you're done, you can shutdown the system and all of its components with
this:

```clj
[cmr.opendap.dev] λ=> (shutdown)
```


## Code Reloading

You can reload changed code in the REPL without leaving it.

If you don't have a running system, the quickest way to do this is with
`(refresh)`. However, this should not be used with a running system.

If you have starte the system, then you'll want to use `(reset)`. This stops a
running system, reloads the changed namespaces, and then restarts the system.


<!-- Named page links below: /-->
