# Development

**Contents**

* nREPL
* Proto-REPL
* System
* Code Reloading
* Convenience Functions


## nREPL

To write new code for CMR OPeNDAP you'll want to start up a REPL. The
primary development REPL for CMR OPeNDAP is a terminal-based nREPL:

```
$ lein repl
```
```text

 __________ ___   ___ _________
/   /_____/|   \ /   |    _o___)                       OPeNDAP support in
\___\%%%%%'|____|____|___|\____\                           NASA Earthdata
 `BBBBBBBB' `BBBBBBB' `BB' `BBB'
 _________ _________  __________ ___    __ _________  _______  _________
/    O    \    _o___)/   /_____/|   \  |  |     O   \/   O   \|    _o___)
\_________/___|%%%%%'\___\%%%%%'|____\_|__|_________/___/%\___\___|%%%%%'
 `BBBBBBB' `B'        `BBBBBBBB' `BBBBBBB' `BBBBBBB'`BB'   `BB'`B'



nREPL server started on port 52191 on host 127.0.0.1 - nrepl://127.0.0.1:52191
REPL-y 0.3.7, nREPL 0.2.12
Clojure 1.8.0
Java HotSpot(TM) 64-Bit Server VM 1.8.0_91-b14
    Docs: (doc function-name-here)
          (find-doc "part-of-name-here")
  Source: (source function-name-here)
 Javadoc: (javadoc java-object-or-class-here)
    Exit: Control+D or (exit) or (quit)
 Results: Stored in vars *1, *2, *3, an exception in *e

[cmr.opendap.dev] λ=>
```


## Proto-REPL

For those using the Atom editor, CMR OPeNDAP also offers support for Proto-REPL.
To this end, the `user` ns has been provied at `dev-resources/src/user.clj`. It
is essentially a wrapper for `cmr.opendap.dev` (and can be removed once Proto-REPL
supports configurable starting namespaces, as `lein` does).


## System

With the REPL up, you're ready to bring up the CMR OPeNDAP system components:

```clj
[cmr.opendap.dev] λ=> (startup)
```

This will start the following CMR OPeNDAP components:

* Configuration
* Logging
* The local LRU caching service
* The CMR OPeNDAP HTTP server for the REST API

as the log messages show:

```
2018-04-07T15:26:54.830 [nREPL-worker-0] INFO cmr.opendap.components.config:62 - Starting config component ...
2018-04-07T15:26:54.837 [nREPL-worker-0] INFO cmr.opendap.components.logging:22 - Starting logging component ...
2018-04-07T15:26:54.845 [nREPL-worker-0] INFO cmr.opendap.components.caching:56 - Starting caching component ...
2018-04-07T15:26:54.855 [nREPL-worker-0] INFO cmr.opendap.components.httpd:23 - Starting httpd component ...
```

A convenience function has been provided for use in the REPL which returns
the dynamic var where the system state is stored:

```clj
[cmr.opendap.dev] λ=> (system)
```

When you're done, you can shutdown the system and all of its components with
this:

```clj
[cmr.opendap.dev] λ=> (shutdown)
```


## Code Reloading

You can reload changed code in the REPL without leaving it.

If you don't have a running system, the quickest way to do this is with
`refresh`. However, this should not be used with a running system.

If you have starte the system, then you'll want to use `reset`. This stops a
running system, reloads the changed namespaces, and then restarts the system.


<!-- Named page links below: /-->
